/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.network.payload.transfer;

import de.crafty.eiv.common.recipe.ServerRecipeManager;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record ServerboundTransferPayload(HashMap<Integer, Integer> transferMap, HashMap<Integer, HashMap<Integer, ItemStack>> usedPlayerSlots) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundTransferPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, ServerboundTransferPayload::encodeMap, ServerboundTransferPayload::decodeMap);
    public static final CustomPacketPayload.Type<ServerboundTransferPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"recipe_transfer"));

    private CompoundTag encodeMap() {
        CompoundTag encoded = new CompoundTag();
        CompoundTag transferMap = new CompoundTag();
        this.transferMap.forEach((recipeSlot, destSlot) -> transferMap.putInt(String.valueOf(recipeSlot), destSlot.intValue()));
        encoded.put("transferMap", (Tag)transferMap);
        CompoundTag usedPlayerSlots = new CompoundTag();
        this.usedPlayerSlots.forEach((recipeSlot, usedSlots) -> {
            CompoundTag playerSlotsTag = new CompoundTag();
            usedSlots.forEach((playerSlot, stack) -> playerSlotsTag.put(String.valueOf(playerSlot), stack.save((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
            usedPlayerSlots.put(String.valueOf(recipeSlot), (Tag)playerSlotsTag);
        });
        encoded.put("usedPlayerSlots", (Tag)usedPlayerSlots);
        return encoded;
    }

    private static ServerboundTransferPayload decodeMap(CompoundTag encoded) {
        HashMap<Integer, Integer> transferMap = new HashMap<Integer, Integer>();
        CompoundTag encodedTransferMap = encoded.getCompound("transferMap");
        encodedTransferMap.getAllKeys().forEach(recipeSlot -> transferMap.put(Integer.valueOf(recipeSlot), encodedTransferMap.getInt(recipeSlot)));
        HashMap<Integer, HashMap<Integer, ItemStack>> usedPlayerSlots = new HashMap<Integer, HashMap<Integer, ItemStack>>();
        CompoundTag encodedUsedPlayerSlots = encoded.getCompound("usedPlayerSlots");
        encodedUsedPlayerSlots.getAllKeys().forEach(recipeSlot -> {
            HashMap usedSlots = new HashMap();
            CompoundTag playerSlotsTag = encodedUsedPlayerSlots.getCompound(recipeSlot);
            playerSlotsTag.getAllKeys().forEach(playerSlot -> {
                Optional stack = ItemStack.parse((HolderLookup.Provider)ServerRecipeManager.INSTANCE.getServer().registryAccess(), (Tag)playerSlotsTag.getCompound(playerSlot));
                usedSlots.put(Integer.valueOf(playerSlot), stack.orElseGet(() -> ((ItemStack)ItemStack.EMPTY).copy()));
            });
            usedPlayerSlots.put(Integer.valueOf(recipeSlot), usedSlots);
        });
        return new ServerboundTransferPayload(transferMap, usedPlayerSlots);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

