/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.overlay;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.overlay.ItemSlot;
import de.crafty.eiv.common.overlay.ItemViewOverlay;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ItemBookmarkOverlay {
    public static final ItemBookmarkOverlay INSTANCE = new ItemBookmarkOverlay();
    private final LinkedList<ItemSlot> slots = new LinkedList();
    private int width;
    private int height;
    private int xStart;
    private int fittingItemsPerRow;
    private int fittingItemsPerColumn;
    private int itemStartX;
    private int itemStartY;
    private final List<ItemStack> bookmarkedItems = new ArrayList<ItemStack>();
    private int startIndex = 0;

    private ItemBookmarkOverlay() {
    }

    public void bookmarkItem(ItemStack stack) {
        if (!this.bookmarkedItems.contains(stack)) {
            this.bookmarkedItems.add(stack);
            this.updateSlots();
        }
    }

    public List<ItemStack> getBookmarkedItems() {
        return this.bookmarkedItems;
    }

    public void saveBookmarkedItems(JsonObject json) {
        JsonArray array = new JsonArray();
        this.bookmarkedItems.forEach(stack -> array.add((JsonElement)((JsonElement)ItemStack.CODEC.encode(stack, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).getOrThrow()).getAsJsonObject()));
        json.add("bookmarkedItems", (JsonElement)array);
    }

    public void loadBookmarkedItems(JsonObject json) {
        this.bookmarkedItems.clear();
        if (!json.has("bookmarkedItems")) {
            return;
        }
        json.getAsJsonArray("bookmarkedItems").forEach(jsonE -> {
            JsonObject jsonItem = jsonE.getAsJsonObject();
            DataResult result = ItemStack.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonItem);
            if (result.isSuccess()) {
                this.bookmarkedItems.add((ItemStack)((Pair)result.getOrThrow()).getFirst());
            }
        });
        this.updateSlots();
    }

    /*
     * Unable to fully structure code
     */
    public void initForScreen(AbstractContainerScreen<? extends AbstractContainerMenu> screen) {
        currentInfo = ItemViewOverlay.INSTANCE.getCurrentInventoryInfo();
        if (!(screen instanceof AbstractRecipeBookScreen)) ** GOTO lbl-1000
        recipeBookScreen = (AbstractRecipeBookScreen)screen;
        if (recipeBookScreen.recipeBookComponent.isVisible()) {
            v0 = recipeBookScreen.recipeBookComponent.getXOrigin() - 32;
        } else lbl-1000:
        // 2 sources

        {
            v0 = currentInfo.leftPos();
        }
        spaceForOverlayX = v0;
        this.fittingItemsPerRow = Math.min(8, (spaceForOverlayX -= spaceForOverlayX > 54 ? 14 : 0) / 20);
        spaceForOverlayX = this.fittingItemsPerRow * 20;
        headlineSpace = 20;
        bottomSpace = 40;
        spaceForOverlayY = screen.height - (headlineSpace + bottomSpace);
        this.fittingItemsPerColumn = spaceForOverlayY / 20;
        this.width = spaceForOverlayX;
        this.height = screen.height;
        this.xStart = 0;
        this.itemStartX = 0;
        this.itemStartY = headlineSpace;
        this.updateSlots();
    }

    private void updateSlots() {
        if (this.startIndex >= this.bookmarkedItems.size()) {
            this.startIndex = Math.max(0, this.startIndex - this.fittingItemsPerRow * this.fittingItemsPerColumn);
        }
        this.slots.clear();
        int endIndex = this.startIndex + this.fittingItemsPerColumn * this.fittingItemsPerRow;
        for (int i = this.startIndex; i < endIndex && i < this.bookmarkedItems.size(); ++i) {
            ItemStack stack = this.bookmarkedItems.get(i);
            int j = i - this.startIndex;
            int xOff = (j - j / this.fittingItemsPerRow * this.fittingItemsPerRow) * 20;
            int yOff = j / this.fittingItemsPerRow * 20;
            this.slots.add(new ItemSlot(stack, this.itemStartX + xOff, this.itemStartY + yOff));
        }
    }

    public boolean scrollMouse(double mouseX, double mouseY, double scrolledX, double scrolledY) {
        if (mouseX > (double)this.width) {
            return false;
        }
        if (CommonEIVClient.isCheatmodeActive()) {
            for (ItemSlot slot : this.slots) {
                if (!slot.isHovered()) continue;
                slot.changeCheatmodeCount(scrolledY < 0.0 ? -1 : 1);
                return true;
            }
        }
        int fittingPerPage = this.fittingItemsPerRow * this.fittingItemsPerColumn;
        if (scrolledY < 0.0) {
            this.startIndex = Math.min(this.startIndex + fittingPerPage, this.bookmarkedItems.size() - (this.bookmarkedItems.size() - (this.bookmarkedItems.size() - 1) / fittingPerPage * fittingPerPage));
        }
        if (scrolledY > 0.0) {
            this.startIndex = Math.max(0, this.startIndex - fittingPerPage);
        }
        if (scrolledY != 0.0) {
            this.updateSlots();
        }
        return true;
    }

    public void clickMouse(int mouseX, int mouseY, int mouseButton) {
        if (mouseX > this.width) {
            return;
        }
        for (ItemSlot itemSlot : this.slots) {
            if (!itemSlot.isHovered()) continue;
            itemSlot.onClicked(mouseX, mouseY, mouseButton);
            break;
        }
    }

    public void keyPressed(int i, int j, int k) {
        for (ItemSlot slot : this.slots) {
            if (!slot.isHovered()) continue;
            if (CommonEIVClient.USAGE_KEYBIND.matches(i, j)) {
                ItemViewOverlay.INSTANCE.openRecipeView(slot.getStack(), ItemViewOverlay.ItemViewOpenType.INPUT);
            }
            if (CommonEIVClient.RECIPE_KEYBIND.matches(i, j)) {
                ItemViewOverlay.INSTANCE.openRecipeView(slot.getStack(), ItemViewOverlay.ItemViewOpenType.RESULT);
            }
            if (!CommonEIVClient.ADD_BOOKMARK_KEYBIND.matches(i, j)) break;
            this.bookmarkedItems.remove(slot.getStack());
            this.updateSlots();
            break;
        }
    }

    private int getPage() {
        int fittingPerPage = this.fittingItemsPerColumn * this.fittingItemsPerRow;
        int page = this.startIndex / fittingPerPage;
        if (page * fittingPerPage < this.startIndex) {
            ++page;
        }
        return page;
    }

    public void render(AbstractContainerScreen<? extends AbstractContainerMenu> screen, ItemViewOverlay.InventoryPositionInfo positionInfo, Minecraft client, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.slots.isEmpty()) {
            return;
        }
        Font font = client.font;
        guiGraphics.drawCenteredString(font, Component.translatable((String)"eiv.bookmarks").getString(), Math.max(this.width / 2, font.width(Component.translatable((String)"eiv.bookmarks").getString()) / 2 + 2), 6, -1);
        guiGraphics.fill(this.xStart, 0, this.width, screen.height, new Color(0, 0, 0, 64).getRGB());
        String pageString = this.getPage() + 1 + "/" + Math.max((this.bookmarkedItems.size() - 1) / (this.fittingItemsPerColumn * this.fittingItemsPerRow) + 1, this.getPage() + 1);
        guiGraphics.drawCenteredString(font, pageString, Math.max(this.width / 2, font.width(pageString) / 2 + 2), screen.height - 2 - 20 - 10, -1);
        for (ItemSlot slot : this.slots) {
            slot.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }
}

