/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.overlay;

import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.recipe.ClientRecipeCache;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemFilters {
    public static List<ItemStack> defaultFilter(String query) {
        ArrayList<ItemStack> firstPrio = new ArrayList<ItemStack>();
        ArrayList<ItemStack> secondPrio = new ArrayList<ItemStack>();
        ArrayList<ItemStack> thirdPrio = new ArrayList<ItemStack>();
        for (ItemStack stack : ItemFilters.fullStackList()) {
            String itemName = stack.getDisplayName().getString().toLowerCase();
            if (itemName.startsWith(query.toLowerCase())) {
                firstPrio.add(stack);
                continue;
            }
            if (itemName.contains(query.toLowerCase())) {
                secondPrio.add(stack);
                continue;
            }
            if (!stack.is(Items.ENCHANTED_BOOK)) continue;
            int compCheck = ItemFilters.getTooltipMatch(stack, query);
            if (compCheck == 1) {
                secondPrio.add(stack);
            }
            if (compCheck != 2) continue;
            thirdPrio.add(stack);
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        results.addAll(firstPrio);
        results.addAll(secondPrio);
        results.addAll(thirdPrio);
        return results;
    }

    public static List<ItemStack> modId(String query) {
        ArrayList<ItemStack> firstPrio = new ArrayList<ItemStack>();
        ArrayList<ItemStack> secondPrio = new ArrayList<ItemStack>();
        for (ItemStack stack : ItemFilters.fullStackList()) {
            String modName = CommonEIVClient.resolver().getModNameForItem(stack.getItem());
            if (modName == null) continue;
            if ((modName = modName.toLowerCase()).startsWith(query.toLowerCase())) {
                firstPrio.add(stack);
                continue;
            }
            if (!modName.contains(query.toLowerCase())) continue;
            secondPrio.add(stack);
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        results.addAll(firstPrio);
        results.addAll(secondPrio);
        return results;
    }

    public static List<ItemStack> tag(String query) {
        ArrayList firstPrio = new ArrayList();
        ArrayList secondPrio = new ArrayList();
        for (TagKey tag : BuiltInRegistries.ITEM.getTags().map(HolderSet.Named::key).toList()) {
            String tagName = tag.location().getPath().toLowerCase();
            if (tagName.startsWith(query.toLowerCase())) {
                BuiltInRegistries.ITEM.get(tag).ifPresent(items -> items.stream().map(itemHolder -> new ItemStack((ItemLike)itemHolder.value())).filter(item -> !firstPrio.contains(item)).forEach(stack -> {
                    firstPrio.add(stack);
                    firstPrio.addAll(ClientRecipeCache.INSTANCE.getStackSensitives(stack.getItem()).stream().map(ItemView.StackSensitive::stack).toList());
                }));
                continue;
            }
            if (!tagName.contains(query.toLowerCase())) continue;
            BuiltInRegistries.ITEM.get(tag).ifPresent(items -> items.stream().map(itemHolder -> new ItemStack((ItemLike)itemHolder.value())).filter(item -> !firstPrio.contains(item) && !secondPrio.contains(item)).forEach(stack -> {
                secondPrio.add(stack);
                secondPrio.addAll(ClientRecipeCache.INSTANCE.getStackSensitives(stack.getItem()).stream().map(ItemView.StackSensitive::stack).toList());
            }));
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        results.addAll(firstPrio);
        results.addAll(secondPrio);
        return results;
    }

    private static int getTooltipMatch(ItemStack stack, String query) {
        List lore = Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack);
        for (Component line : lore) {
            TranslatableContents translatableContents;
            ComponentContents componentContents = line.getContents();
            if (componentContents instanceof TranslatableContents && I18n.get((String)(translatableContents = (TranslatableContents)componentContents).getKey(), (Object[])new Object[0]).toLowerCase().startsWith(query.toLowerCase())) {
                return 1;
            }
            componentContents = line.getContents();
            if (!(componentContents instanceof TranslatableContents) || !I18n.get((String)(translatableContents = (TranslatableContents)componentContents).getKey(), (Object[])new Object[0]).toLowerCase().contains(query.toLowerCase())) continue;
            return 2;
        }
        return 0;
    }

    private static List<ItemStack> fullStackList() {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        BuiltInRegistries.ITEM.forEach(item -> {
            results.add(new ItemStack((ItemLike)item));
            results.addAll(ClientRecipeCache.INSTANCE.getStackSensitives((Item)item).stream().map(ItemView.StackSensitive::stack).toList());
        });
        return results;
    }
}

