/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.overlay;

import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.overlay.ItemBookmarkOverlay;
import de.crafty.eiv.common.overlay.ItemFilters;
import de.crafty.eiv.common.overlay.ItemSlot;
import de.crafty.eiv.common.recipe.ClientRecipeCache;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemViewOverlay {
    public static final ItemViewOverlay INSTANCE = new ItemViewOverlay();
    private final LinkedList<ItemSlot> slots = new LinkedList();
    public static EditBox SEARCHBAR = null;
    private long lastSearchbarClick = -1L;
    private int width;
    private int height;
    private int xStart;
    private int fittingItemsPerRow;
    private int fittingItemsPerColumn;
    private int itemStartX;
    private int itemStartY;
    private String currentQuery = "";
    private boolean itemFilterMode = false;
    private List<ItemStack> availableItems = new ArrayList<ItemStack>();
    private int startIndex = 0;
    private boolean enabled = true;
    private InventoryPositionInfo currentInfo = null;

    private ItemViewOverlay() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isItemFilterMode() {
        return this.itemFilterMode;
    }

    public void setEnabled(boolean enabled) {
        boolean prev = this.enabled;
        this.enabled = enabled;
        if (prev != enabled && enabled) {
            ItemViewOverlay.SEARCHBAR.visible = true;
        }
        if (prev != enabled && !enabled) {
            ItemViewOverlay.SEARCHBAR.visible = false;
        }
    }

    public InventoryPositionInfo getCurrentInventoryInfo() {
        return this.currentInfo;
    }

    public int getFittingItemsPerColumn() {
        return this.fittingItemsPerColumn;
    }

    public int getFittingItemsPerRow() {
        return this.fittingItemsPerRow;
    }

    public String getCurrentQuery() {
        return this.currentQuery;
    }

    public int getOverlayStartX() {
        return this.xStart;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<ItemStack> getAvailableItems() {
        return this.availableItems;
    }

    public boolean checkForScreenChange(AbstractContainerScreen<? extends AbstractContainerMenu> screen, InventoryPositionInfo newInfo) {
        if (!newInfo.matches(this.currentInfo)) {
            this.currentInfo = newInfo;
            this.initForScreen(screen);
            ItemBookmarkOverlay.INSTANCE.initForScreen(screen);
            return true;
        }
        return false;
    }

    public void initForScreen(AbstractContainerScreen<? extends AbstractContainerMenu> screen) {
        int spaceForOverlayX;
        this.fittingItemsPerRow = Math.min(8, (spaceForOverlayX -= (spaceForOverlayX = screen.width - (this.currentInfo.leftPos + this.currentInfo.imageWidth)) > 54 ? 14 : 0) / 20);
        spaceForOverlayX = this.fittingItemsPerRow * 20;
        int headlineSpace = 20;
        int bottomSpace = 40;
        int spaceForOverlayY = screen.height - (headlineSpace + bottomSpace);
        this.fittingItemsPerColumn = spaceForOverlayY / 20;
        this.width = spaceForOverlayX;
        this.height = screen.height;
        this.itemStartX = this.xStart = screen.width - this.width;
        this.itemStartY = headlineSpace;
        this.updateQuery(this.getCurrentQuery());
    }

    private void updateSlots() {
        this.slots.clear();
        int endIndex = this.startIndex + this.fittingItemsPerColumn * this.fittingItemsPerRow;
        for (int i = this.startIndex; i < endIndex && i < this.availableItems.size(); ++i) {
            ItemStack stack = this.availableItems.get(i);
            int j = i - this.startIndex;
            int xOff = (j - j / this.fittingItemsPerRow * this.fittingItemsPerRow) * 20;
            int yOff = j / this.fittingItemsPerRow * 20;
            this.slots.add(new ItemSlot(stack, this.itemStartX + xOff, this.itemStartY + yOff));
        }
    }

    public void updateQuery(String newQuery) {
        if (!newQuery.equals(this.currentQuery)) {
            this.startIndex = 0;
        }
        this.currentQuery = newQuery;
        this.availableItems = newQuery.startsWith("@") ? ItemFilters.modId(newQuery.substring(1)) : (newQuery.startsWith("#") ? ItemFilters.tag(newQuery.substring(1)) : ItemFilters.defaultFilter(newQuery));
        this.availableItems.removeIf(stack -> ItemView.getExcluded().contains(stack.getItem()));
        this.updateSlots();
    }

    public boolean scrollMouse(double mouseX, double mouseY, double scrolledX, double scrolledY) {
        if (!this.isEnabled()) {
            return false;
        }
        if (ItemBookmarkOverlay.INSTANCE.scrollMouse(mouseX, mouseY, scrolledX, scrolledY)) {
            return true;
        }
        if (mouseX < (double)this.itemStartX) {
            return false;
        }
        if (CommonEIVClient.isCheatmodeActive()) {
            for (ItemSlot slot : this.slots) {
                if (!slot.isHovered()) continue;
                slot.changeCheatmodeCount(scrolledY < 0.0 ? -1 : 1);
                return true;
            }
        }
        int fittingPerPage = this.fittingItemsPerRow * this.fittingItemsPerColumn;
        if (scrolledY < 0.0) {
            this.startIndex = Math.min(this.startIndex + fittingPerPage, this.availableItems.size() - (this.availableItems.size() - this.availableItems.size() / fittingPerPage * fittingPerPage));
        }
        if (scrolledY > 0.0) {
            this.startIndex = Math.max(0, this.startIndex - fittingPerPage);
        }
        if (scrolledY != 0.0) {
            this.updateSlots();
        }
        return true;
    }

    public void clickMouse(int mouseX, int mouseY, int mouseButton) {
        if (!this.isEnabled()) {
            return;
        }
        ItemBookmarkOverlay.INSTANCE.clickMouse(mouseX, mouseY, mouseButton);
        if (mouseX < this.xStart) {
            return;
        }
        if (SEARCHBAR.isHovered() && mouseButton == 0) {
            if (this.lastSearchbarClick != -1L && System.currentTimeMillis() - this.lastSearchbarClick <= 400L) {
                this.itemFilterMode = !this.itemFilterMode;
                this.lastSearchbarClick = -1L;
            } else {
                this.lastSearchbarClick = System.currentTimeMillis();
            }
        }
        for (ItemSlot itemSlot : this.slots) {
            if (!itemSlot.isHovered()) continue;
            itemSlot.onClicked(mouseX, mouseY, mouseButton);
            break;
        }
    }

    public void keyPressed(int i, int j, int k) {
        if (!SEARCHBAR.isFocused() && CommonEIVClient.TOGGLE_OVERLAY_KEYBIND.matches(i, j)) {
            INSTANCE.setEnabled(!INSTANCE.isEnabled());
        }
        if (!this.isEnabled()) {
            return;
        }
        ItemBookmarkOverlay.INSTANCE.keyPressed(i, j, k);
        for (ItemSlot slot : this.slots) {
            if (!slot.isHovered()) continue;
            if (CommonEIVClient.USAGE_KEYBIND.matches(i, j)) {
                INSTANCE.openRecipeView(slot.getStack(), ItemViewOpenType.INPUT);
            }
            if (CommonEIVClient.RECIPE_KEYBIND.matches(i, j)) {
                INSTANCE.openRecipeView(slot.getStack(), ItemViewOpenType.RESULT);
            }
            if (!CommonEIVClient.ADD_BOOKMARK_KEYBIND.matches(i, j)) break;
            ItemBookmarkOverlay.INSTANCE.bookmarkItem(slot.getStack());
            break;
        }
    }

    private int getPage() {
        int page;
        int fittingPerPage = this.fittingItemsPerColumn * this.fittingItemsPerRow;
        int n = page = fittingPerPage > 0 ? this.startIndex / fittingPerPage : 0;
        if (page * fittingPerPage < this.startIndex) {
            ++page;
        }
        return page;
    }

    public void render(AbstractContainerScreen<? extends AbstractContainerMenu> screen, InventoryPositionInfo positionInfo, Minecraft client, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.isEnabled() || this.fittingItemsPerColumn * this.fittingItemsPerRow <= 0) {
            return;
        }
        ItemBookmarkOverlay.INSTANCE.render(screen, positionInfo, client, guiGraphics, mouseX, mouseY, partialTicks);
        Font font = client.font;
        int maxPageIndex = this.availableItems.size() / (this.fittingItemsPerColumn * this.fittingItemsPerRow);
        guiGraphics.drawCenteredString(font, "ItemView", screen.width - this.getWidth() / 2, 6, -1);
        guiGraphics.fill(this.xStart, 0, screen.width, screen.height, new Color(0, 0, 0, 64).getRGB());
        guiGraphics.drawCenteredString(font, this.getPage() + 1 + "/" + (maxPageIndex + 1), screen.width - this.width / 2, screen.height - 2 - 20 - 10, -1);
        for (ItemSlot slot : this.slots) {
            slot.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderItemHighlighting(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.itemFilterMode || !this.isEnabled()) {
            return;
        }
        screen.getMenu().slots.forEach(slot -> {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.currentInfo.leftPos - 1), (float)(this.currentInfo.topPos - 1), 0.0f);
            if (!slot.hasItem() || INSTANCE.getAvailableItems().stream().noneMatch(stack -> stack.getItem() == slot.getItem().getItem())) {
                guiGraphics.fill(slot.x, slot.y, slot.x + 18, slot.y + 18, new Color(0, 0, 0, 128).getRGB());
            }
            guiGraphics.pose().popPose();
        });
    }

    public void openRecipeView(ItemStack stack, ItemViewOpenType openType) {
        if (stack.isEmpty()) {
            return;
        }
        LocalPlayer clientPlayer = Minecraft.getInstance().player;
        if (clientPlayer == null) {
            return;
        }
        List<IEivViewRecipe> foundRecipes = openType.recipeProvider().retrieveRecipes(stack);
        if (!foundRecipes.isEmpty()) {
            Screen parent = Minecraft.getInstance().screen;
            ArrayList<RecipeViewScreen> viewHistory = new ArrayList();
            if (parent instanceof RecipeViewScreen) {
                RecipeViewScreen viewScreen = (RecipeViewScreen)parent;
                parent = ((RecipeViewMenu)viewScreen.getMenu()).getParentScreen();
                viewHistory = ((RecipeViewMenu)viewScreen.getMenu()).getViewHistory();
            }
            Minecraft.getInstance().setScreen((Screen)new RecipeViewScreen(new RecipeViewMenu(parent, 0, clientPlayer.getInventory(), foundRecipes, stack, openType == ItemViewOpenType.RESULT ? SlotContent.Type.RESULT : SlotContent.Type.INGREDIENT, viewHistory), clientPlayer.getInventory(), (Component)Component.empty()));
        }
    }

    public record InventoryPositionInfo(int screenWidth, int screenHeight, int leftPos, int topPos, int imageWidth, int imageHeight) {
        private boolean matches(@Nullable InventoryPositionInfo info) {
            if (info == null) {
                return false;
            }
            return info.screenWidth == this.screenWidth && info.screenHeight == this.screenHeight && info.leftPos == this.leftPos && info.topPos == this.topPos && info.imageWidth == this.imageWidth && info.imageHeight == this.imageHeight;
        }
    }

    public static enum ItemViewOpenType {
        INPUT(ClientRecipeCache.INSTANCE::getRecipesForCraftingInput),
        RESULT(ClientRecipeCache.INSTANCE::getRecipesForCraftingOutput);

        final RecipeProvider recipeProvider;

        private ItemViewOpenType(RecipeProvider recipeProvider) {
            this.recipeProvider = recipeProvider;
        }

        RecipeProvider recipeProvider() {
            return this.recipeProvider;
        }

        static interface RecipeProvider {
            public List<IEivViewRecipe> retrieveRecipes(ItemStack var1);
        }
    }
}

