/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.overlay.itemlist.view;

import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.config.Configs;
import de.crafty.eiv.common.gui.EivClientSettingsScreen;
import de.crafty.eiv.common.overlay.AbstractEivOverlay;
import de.crafty.eiv.common.overlay.ItemFilters;
import de.crafty.eiv.common.overlay.ItemSlot;
import de.crafty.eiv.common.overlay.OverlayManager;
import de.crafty.eiv.common.overlay.itemlist.AbstractEivItemListOverlay;
import de.crafty.eiv.common.overlay.itemlist.bookmark.ItemBookmarkOverlay;
import de.crafty.eiv.common.recipe.ClientRecipeCache;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ItemViewOverlay
extends AbstractEivItemListOverlay {
    public static final ItemViewOverlay INSTANCE = new ItemViewOverlay();
    private static final ResourceLocation SETTINGS_WHEEL = ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"settings_wheel");
    private EditBox searchbar = null;
    private static final int HEADER_HEIGHT = 20;
    private static final int FOOTER_HEIGHT = 40;
    private long lastSearchbarClick = -1L;
    private String currentQuery = "";
    private boolean itemFilterMode = false;

    public ItemViewOverlay() {
        super(-1, -1, -1, -1);
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean prev = this.isEnabled();
        super.setEnabled(enabled);
        if (prev != enabled && enabled) {
            this.searchbar.visible = true;
        }
        if (prev != enabled && !enabled) {
            this.searchbar.visible = false;
        }
    }

    @Override
    public void onScreenChanged(AbstractEivOverlay.InventoryPositionInfo info) {
        this.initForScreen(info.screen(), info);
        super.onScreenChanged(info);
        this.updateQuery(this.getCurrentQuery());
        this.createSearchbarElement(OverlayManager.INSTANCE.currentInfo());
    }

    @Override
    protected void placeWidgets(AbstractEivOverlay.ScreenContext ctx) {
        ctx.addRenderable(this.searchbar);
        AbstractEivOverlay.InventoryPositionInfo info = OverlayManager.INSTANCE.currentInfo();
        SpriteIconButton btn = SpriteIconButton.builder((Component)Component.translatable((String)"eiv.client_settings.btn"), button -> Minecraft.getInstance().setScreen((Screen)new EivClientSettingsScreen((Screen)info.screen())), (boolean)true).size(18, 18).sprite(SETTINGS_WHEEL, 14, 14).build();
        btn.setPosition(0, info.screenHeight() - 18);
        ctx.addRenderable(btn);
    }

    private void initForScreen(AbstractContainerScreen<? extends AbstractContainerMenu> screen, AbstractEivOverlay.InventoryPositionInfo invInfo) {
        this.width = invInfo.screenWidth() - ((invInfo.screenWidth() - 176) / 2 + 176) - 14;
        this.width -= (this.width - 4) % 20;
        this.height = screen.height;
        this.x = invInfo.screenWidth() - this.width;
        this.y = 0;
        this.itemStartX = this.x + 2;
        this.itemStartY = 20;
        this.itemEndX = this.x + this.width - 2;
        this.itemEndY = this.y + this.height - 40;
    }

    private void updateQuery(String newQuery) {
        if (!newQuery.equals(this.currentQuery)) {
            this.startIndex = 0;
        }
        this.currentQuery = newQuery;
        this.availableItems = newQuery.startsWith("@") ? ItemFilters.modId(newQuery.substring(1)) : (newQuery.startsWith("#") ? ItemFilters.tag(newQuery.substring(1)) : ItemFilters.defaultFilter(newQuery));
        this.availableItems().removeIf(stack -> ItemView.getExcluded().contains(stack.getItem()));
        this.updateSlots();
    }

    @Override
    protected boolean keyPressed(int i, int j, int k) {
        super.keyPressed(i, j, k);
        for (ItemSlot slot : this.itemSlots()) {
            if (!slot.isHovered() || !CommonEIVClient.ADD_BOOKMARK_KEYBIND.matches(i, j)) continue;
            ItemBookmarkOverlay.INSTANCE.bookmarkItem(slot.getStack());
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.searchbar.isHovered() && mouseButton == 1) {
            this.searchbar.setValue("");
            OverlayManager.INSTANCE.currentInfo().screen().setFocused((GuiEventListener)this.searchbar);
        }
        if (mouseButton == 0 && !this.searchbar.isHovered() && this.searchbar.isFocused()) {
            this.searchbar.setFocused(false);
        }
        if (this.searchbar.isHovered() && mouseButton == 0) {
            if (this.lastSearchbarClick != -1L && System.currentTimeMillis() - this.lastSearchbarClick <= 400L) {
                this.itemFilterMode = !this.itemFilterMode;
                this.lastSearchbarClick = -1L;
            } else {
                this.lastSearchbarClick = System.currentTimeMillis();
            }
        }
        return false;
    }

    @Override
    protected void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.fittingPerPage() == 0) {
            return;
        }
        if (Configs.CLIENT_SETTINGS.isItemWrapMode()) {
            guiGraphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, new Color(0, 0, 0, 64).getRGB());
        } else {
            guiGraphics.fill(this.effectiveX, this.effectiveY, this.effectiveX + this.effectiveWidth, this.effectiveY + this.effectiveHeight, new Color(0, 0, 0, 64).getRGB());
        }
    }

    @Override
    protected void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft client = Minecraft.getInstance();
        Font font = client.font;
        if (Configs.CLIENT_SETTINGS.isItemWrapMode()) {
            this.drawScaledString(font, guiGraphics, (Component)Component.literal((String)"ItemView"), this.x + this.width / 2, this.y + 6, -1);
        } else {
            this.drawScaledString(font, guiGraphics, (Component)Component.literal((String)"ItemView"), this.effectiveX + this.effectiveWidth / 2, this.effectiveY + 6, -1);
        }
        if (this.fittingPerPage() > 0) {
            if (Configs.CLIENT_SETTINGS.isItemWrapMode()) {
                guiGraphics.drawCenteredString(font, this.getPage() + 1 + "/" + (this.getMaxPageIndex() + 1), this.x + this.width - this.width / 2, this.y + this.height - 2 - 20 - 10, -1);
            } else {
                guiGraphics.drawCenteredString(font, this.getPage() + 1 + "/" + (this.getMaxPageIndex() + 1), this.effectiveX + this.effectiveWidth / 2, this.effectiveY + this.effectiveHeight - 2 - 20 - 10, -1);
            }
        }
        for (ItemSlot slot : this.itemSlots()) {
            slot.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.renderItemHighlighting(OverlayManager.INSTANCE.currentInfo().screen(), guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderItemHighlighting(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.itemFilterMode) {
            return;
        }
        screen.getMenu().slots.forEach(slot -> {
            if (!slot.isActive() || !slot.isHighlightable()) {
                return;
            }
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(OverlayManager.INSTANCE.currentInfo().leftPos() - 1), (float)(OverlayManager.INSTANCE.currentInfo().topPos() - 1), 0.0f);
            if (!slot.hasItem() || this.availableItems.stream().noneMatch(stack -> stack.getItem() == slot.getItem().getItem())) {
                guiGraphics.fill(slot.x, slot.y, slot.x + 18, slot.y + 18, new Color(0, 0, 0, 128).getRGB());
            }
            guiGraphics.pose().popPose();
        });
    }

    public void createSearchbarElement(AbstractEivOverlay.InventoryPositionInfo info) {
        EditBox box;
        GuiEventListener guiEventListener;
        boolean wrapMode = Configs.CLIENT_SETTINGS.isItemWrapMode();
        int boxWidth = Math.min(100, (wrapMode ? this.width : this.effectiveWidth) - 4);
        int x = wrapMode ? this.x + this.width / 2 - boxWidth / 2 : this.effectiveX + this.effectiveWidth / 2 - boxWidth / 2;
        int y = info.screenHeight() - 22;
        if (this.searchbar != null && (guiEventListener = info.screen().getFocused()) instanceof EditBox && (box = (EditBox)guiEventListener).getMessage().equals((Object)Component.literal((String)"eiv:searchbar"))) {
            this.searchbar.setFocused(false);
        }
        if (this.searchbar != null && boxWidth == this.searchbar.getWidth() && x == this.searchbar.getX() && y == this.searchbar.getY()) {
            return;
        }
        EditBox newSearchbar = new EditBox(Minecraft.getInstance().font, x, y, boxWidth, 20, (Component)Component.literal((String)"eiv:searchbar"));
        newSearchbar.setMaxLength(32);
        newSearchbar.setValue(this.getCurrentQuery());
        newSearchbar.setResponder(this::updateQuery);
        newSearchbar.visible = this.isEnabled();
        this.searchbar = newSearchbar;
    }

    public void openRecipeView(ItemStack stack, ItemViewOpenType openType) {
        if (stack.isEmpty()) {
            return;
        }
        LocalPlayer clientPlayer = Minecraft.getInstance().player;
        if (clientPlayer == null) {
            return;
        }
        List<IEivViewRecipe> foundRecipes = openType.recipeProvider().retrieveRecipes(stack);
        if (!foundRecipes.isEmpty()) {
            Screen parent = Minecraft.getInstance().screen;
            ArrayList<RecipeViewScreen> viewHistory = new ArrayList();
            if (parent instanceof RecipeViewScreen) {
                RecipeViewScreen viewScreen = (RecipeViewScreen)parent;
                parent = ((RecipeViewMenu)viewScreen.getMenu()).getParentScreen();
                viewHistory = ((RecipeViewMenu)viewScreen.getMenu()).getViewHistory();
            }
            Minecraft.getInstance().setScreen((Screen)new RecipeViewScreen(new RecipeViewMenu(parent, 0, clientPlayer.getInventory(), foundRecipes, stack, openType == ItemViewOpenType.RESULT ? SlotContent.Type.RESULT : SlotContent.Type.INGREDIENT, viewHistory), clientPlayer.getInventory(), (Component)Component.empty()));
        }
    }

    public EditBox getSearchbar() {
        return this.searchbar;
    }

    public boolean isItemFilterMode() {
        return this.itemFilterMode;
    }

    public String getCurrentQuery() {
        return this.currentQuery;
    }

    public static enum ItemViewOpenType {
        INPUT(ClientRecipeCache.INSTANCE::getRecipesForCraftingInput),
        RESULT(ClientRecipeCache.INSTANCE::getRecipesForCraftingOutput);

        final RecipeProvider recipeProvider;

        private ItemViewOpenType(RecipeProvider recipeProvider) {
            this.recipeProvider = recipeProvider;
        }

        RecipeProvider recipeProvider() {
            return this.recipeProvider;
        }

        static interface RecipeProvider {
            public List<IEivViewRecipe> retrieveRecipes(ItemStack var1);
        }
    }
}

