/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe;

import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.network.payload.recipe.ClientboundCacheStartPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundFinishUpdatesPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundStartUpdatesPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdateEndPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdatePayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdateStartPayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundFinishStackSensitivesPayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundStackSensitivePayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundStartStackSensitivesPayload;
import de.crafty.eiv.common.recipe.ItemViewRecipes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class ServerRecipeManager {
    public static final ServerRecipeManager INSTANCE = new ServerRecipeManager();
    private static final HashMap<EivRecipeType<?>, List<ServerRecipeEntry>> PRESENT_RECIPES = new LinkedHashMap();
    private MinecraftServer server;
    private RecipeManager recipeManager;

    private ServerRecipeManager() {
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
        this.reload();
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void setRecipeManager(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    public RecipeManager getVanillaRecipeManager() {
        return this.recipeManager;
    }

    public <T extends Recipe<?>> List<T> getRecipesForType(RecipeType<T> recipeType) {
        return this.recipeManager.getRecipes().stream().filter(holder -> holder.value().getType().equals((Object)recipeType)).map(RecipeHolder::value).toList();
    }

    public void reload() {
        if (this.server == null || this.recipeManager == null) {
            return;
        }
        CommonEIV.LOGGER.info("Reloading all Recipes...");
        ItemView.getStackSensitive().clear();
        ItemView.getReloadCallbacks().forEach(ItemView.ReloadCallback::onReload);
        this.informAboutStackSensitives();
        this.reloadRecipes();
        this.broadcastAllRecipes();
    }

    public void informAboutStackSensitives() {
        if (this.server == null) {
            return;
        }
        ArrayList collected = new ArrayList();
        ItemView.getStackSensitive().forEach((item, stackSensitives) -> collected.addAll(stackSensitives));
        CommonEIV.LOGGER.info("Broadcasting Stack-Sensitives...");
        CommonEIV.LOGGER.info("Updating {} players...", (Object)this.server.getPlayerList().getPlayers().size());
        this.server.getPlayerList().getPlayers().forEach(player -> {
            CommonEIV.networkManager().sendPacket((ServerPlayer)player, new ClientboundStartStackSensitivesPayload(collected.size()));
            collected.forEach(stackSensitive -> CommonEIV.networkManager().sendPacket((ServerPlayer)player, new ClientboundStackSensitivePayload((ItemView.StackSensitive)stackSensitive)));
            CommonEIV.networkManager().sendPacket((ServerPlayer)player, new ClientboundFinishStackSensitivesPayload());
        });
    }

    public void reloadRecipes() {
        PRESENT_RECIPES.clear();
        ArrayList serverRecipes = new ArrayList();
        ItemViewRecipes.INSTANCE.getRecipeProviders().forEach(serverModRecipeProvider -> {
            ArrayList<IEivServerRecipe> recipes = new ArrayList<IEivServerRecipe>();
            serverModRecipeProvider.provide(recipes);
            serverRecipes.addAll(recipes);
        });
        serverRecipes.forEach(iEivServerModRecipe -> {
            ResourceLocation typeId = iEivServerModRecipe.getRecipeType().getId();
            List list = PRESENT_RECIPES.getOrDefault(iEivServerModRecipe.getRecipeType(), new ArrayList());
            list.add(new ServerRecipeEntry(ResourceLocation.fromNamespaceAndPath((String)typeId.getNamespace(), (String)(typeId.getPath() + "/" + String.valueOf(UUID.randomUUID()))), (IEivServerRecipe)iEivServerModRecipe));
            PRESENT_RECIPES.put(iEivServerModRecipe.getRecipeType(), list);
        });
    }

    public void broadcastAllRecipes() {
        if (this.server == null) {
            return;
        }
        CommonEIV.LOGGER.info("Broadcasting recipes...");
        this.server.getPlayerList().getPlayers().forEach(this::informAboutRecipes);
    }

    public void informAboutRecipes(ServerPlayer serverPlayer) {
        if (PRESENT_RECIPES.isEmpty()) {
            return;
        }
        CommonEIV.LOGGER.info("Informing {} about {} recipe types", (Object)serverPlayer.getName(), (Object)PRESENT_RECIPES.size());
        CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundStartUpdatesPayload());
        CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundCacheStartPayload(PRESENT_RECIPES.size()));
        PRESENT_RECIPES.forEach((type, entries) -> {
            CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundTypeUpdateStartPayload((EivRecipeType<?>)type, entries.size()));
            entries.forEach(recipe -> CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundTypeUpdatePayload((ServerRecipeEntry)recipe)));
            CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundTypeUpdateEndPayload((EivRecipeType<?>)type));
        });
        CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundFinishUpdatesPayload());
    }

    public void performRecipeTransfer(ServerPlayer player, HashMap<Integer, Integer> transferMap, HashMap<Integer, HashMap<Integer, ItemStack>> usedPlayerSlots) {
        transferMap.forEach((recipeSlot, destSlot) -> {
            HashMap<Integer, ItemStack> usedSlots = usedPlayerSlots.getOrDefault(recipeSlot, new HashMap());
            usedSlots.forEach((playerSlot, stack) -> {
                ItemStack currentInDest = player.containerMenu.getSlot(destSlot.intValue()).getItem();
                if (currentInDest.isEmpty()) {
                    player.containerMenu.getSlot(destSlot.intValue()).set(player.getInventory().removeItem(playerSlot.intValue(), stack.getCount()));
                } else {
                    player.containerMenu.getSlot(destSlot.intValue()).set(currentInDest.copyWithCount(currentInDest.getCount() + player.getInventory().removeItem(playerSlot.intValue(), stack.getCount()).getCount()));
                }
            });
        });
    }

    public record ServerRecipeEntry(ResourceLocation modRecipeId, IEivServerRecipe recipe) {
        public static final StreamCodec<FriendlyByteBuf, ServerRecipeEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, entry -> entry.modRecipeId().toString(), (StreamCodec)ByteBufCodecs.COMPOUND_TAG, ServerRecipeEntry::createFullTag, (s, compoundTag) -> new ServerRecipeEntry(ResourceLocation.tryParse((String)s), ServerRecipeEntry.fromTag(compoundTag)));

        public <T extends IEivServerRecipe> T asWrapped() {
            return (T)this.recipe;
        }

        private CompoundTag createFullTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("recipeType", this.recipe().getRecipeType().getId().toString());
            CompoundTag dataTag = new CompoundTag();
            this.recipe().writeToTag(dataTag);
            tag.put("recipeData", (Tag)dataTag);
            return tag;
        }

        private static IEivServerRecipe fromTag(CompoundTag tag) {
            if (!tag.contains("recipeType")) {
                return null;
            }
            EivRecipeType<?> recipeType = EivRecipeType.byId(ResourceLocation.parse((String)tag.getString("recipeType")));
            if (recipeType == null) {
                return null;
            }
            Object modRecipe = recipeType.getEmptyConstructor().construct();
            modRecipe.loadFromTag(tag.getCompound("recipeData"));
            return modRecipe;
        }
    }
}

