/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe.inventory;

import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.network.payload.transfer.ServerboundTransferPayload;
import de.crafty.eiv.common.overlay.itemlist.view.ItemViewOverlay;
import de.crafty.eiv.common.recipe.inventory.RecipeTransferData;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.rendering.AnimationTicker;
import de.crafty.eiv.common.recipe.util.EivUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;

public class RecipeViewScreen
extends AbstractContainerScreen<RecipeViewMenu> {
    private static final ResourceLocation VIEW_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"textures/gui/recipe_view.png");
    private final long timestamp;
    private Button prevRecipe;
    private Button nextRecipe;
    private Component guiTitle;
    private Component page;
    private final List<AnimationTicker> animationTickers;
    private final HashMap<ResourceLocation, Integer> animationTickCache;
    private final List<Button> transferButtons = new ArrayList<Button>();
    private final List<ViewTypeButton> viewTypeButtons = new ArrayList<ViewTypeButton>();
    private int viewTypePage = 0;
    private Button prevTypePage;
    private Button nextTypePage;

    public RecipeViewScreen(RecipeViewMenu recipeViewMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)recipeViewMenu, inventory, component);
        this.animationTickers = new ArrayList<AnimationTicker>();
        this.animationTickCache = new HashMap();
        this.imageHeight = ((RecipeViewMenu)this.getMenu()).getHeight();
        this.imageWidth = ((RecipeViewMenu)this.getMenu()).getWidth();
        this.guiTitle = component;
        this.page = this.createPageComponent();
        this.timestamp = inventory.player.level().getGameTime();
        recipeViewMenu.setViewScreen(this);
    }

    private Component createPageComponent() {
        return Component.literal((String)(((RecipeViewMenu)this.getMenu()).getCurrentPage() + 1 + "/" + (((RecipeViewMenu)this.getMenu()).getMaxPageIndex() + 1)));
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (CommonEIVClient.GO_BACK_RECIPE.matchesMouse(i) && ((RecipeViewMenu)this.getMenu()).goBack()) {
            return true;
        }
        if (CommonEIVClient.GO_FORWARD_RECIPE.matchesMouse(i) && ((RecipeViewMenu)this.getMenu()).goForward()) {
            return true;
        }
        return super.mouseReleased(d, e, i);
    }

    public boolean keyPressed(int i, int j, int k) {
        if (CommonEIVClient.GO_BACK_RECIPE.matches(i, j) && ((RecipeViewMenu)this.getMenu()).goBack()) {
            return true;
        }
        if (CommonEIVClient.GO_FORWARD_RECIPE.matches(i, j) && ((RecipeViewMenu)this.getMenu()).goForward()) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    protected void init() {
        super.init();
        this.prevRecipe = Button.builder((Component)Component.literal((String)"<"), button -> ((RecipeViewMenu)this.getMenu()).prevPage()).size(12, 12).build();
        this.nextRecipe = Button.builder((Component)Component.literal((String)">"), button -> ((RecipeViewMenu)this.getMenu()).nextRecipe()).size(12, 12).build();
        this.prevTypePage = Button.builder((Component)Component.literal((String)"<"), button -> {
            this.viewTypePage = Math.max(this.viewTypePage - 1, 0);
            this.checkGui();
        }).size(12, 12).build();
        this.nextTypePage = Button.builder((Component)Component.literal((String)">"), button -> {
            this.viewTypePage = Math.min(this.viewTypePage + 1, ((RecipeViewMenu)this.getMenu()).getViewTypeOrder().size() / 5);
            this.checkGui();
        }).size(12, 12).build();
        this.checkGui();
        this.addRenderableWidget((GuiEventListener)this.prevRecipe);
        this.addRenderableWidget((GuiEventListener)this.nextRecipe);
        this.addRenderableWidget((GuiEventListener)this.prevTypePage);
        this.addRenderableWidget((GuiEventListener)this.nextTypePage);
        int width = 24;
        int height = 24;
        this.viewTypeButtons.clear();
        for (int i = 0; i < ((RecipeViewMenu)this.getMenu()).getViewTypeOrder().size(); ++i) {
            int tempId = i % 5;
            int xPos = this.width / 2 - (5 * width / 2 + 4) + tempId * width + tempId * 2;
            int yPos = this.topPos - height - 1;
            this.viewTypeButtons.add(new ViewTypeButton(this, xPos, yPos, width, height, ((RecipeViewMenu)this.getMenu()).getViewTypeOrder().get(i), i));
        }
    }

    protected void checkGui() {
        this.prevRecipe.active = ((RecipeViewMenu)this.getMenu()).hasPrevRecipe();
        this.nextRecipe.active = ((RecipeViewMenu)this.getMenu()).hasNextRecipe();
        this.prevTypePage.visible = this.viewTypePage > 0;
        this.nextTypePage.visible = this.viewTypePage < (((RecipeViewMenu)this.getMenu()).getViewTypeOrder().size() - 1) / 5;
        this.imageHeight = ((RecipeViewMenu)this.getMenu()).getHeight();
        this.imageWidth = ((RecipeViewMenu)this.getMenu()).getWidth();
        this.topPos = 32;
        this.prevRecipe.setPosition(this.leftPos + 8, this.topPos + 4);
        this.nextRecipe.setPosition(this.leftPos + this.imageWidth - 8 - 12, this.topPos + 4);
        this.prevTypePage.setPosition(this.width / 2 - 64 - 2 - 12, this.topPos - 1 - 12 - 6);
        this.nextTypePage.setPosition(this.width / 2 + 64 + 2, this.topPos - 1 - 12 - 6);
        this.guiTitle = ((RecipeViewMenu)this.getMenu()).getViewType().getDisplayName();
        this.titleLabelX = this.imageWidth / 2 - this.font.width((FormattedText)this.guiTitle) / 2;
        this.page = this.createPageComponent();
        this.animationTickCache.clear();
        this.checkTickers();
        this.transferButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.transferButtons.clear();
        int guiLeft = this.leftPos + ((RecipeViewMenu)this.getMenu()).guiOffsetLeft();
        for (int i = 0; i < ((RecipeViewMenu)this.getMenu()).getCurrentDisplay().size(); ++i) {
            IEivViewRecipe currentView = ((RecipeViewMenu)this.getMenu()).getCurrentDisplay().get(i);
            int guiTop = this.topPos + ((RecipeViewMenu)this.getMenu()).guiOffsetTop(i);
            int finalI = i;
            Button button = Button.builder((Component)Component.literal((String)"+"), button1 -> {
                if (!currentView.supportsItemTransfer()) {
                    return;
                }
                Minecraft.getInstance().setScreen(((RecipeViewMenu)this.getMenu()).getParentScreen());
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null && EivUtil.matchesAnyTransferClass(currentView, Minecraft.getInstance().screen)) {
                    if (!currentView.canTransferToScreen((AbstractContainerScreen)Minecraft.getInstance().screen)) {
                        return;
                    }
                    IEivViewRecipe.RecipeTransferMap map = new IEivViewRecipe.RecipeTransferMap();
                    currentView.mapRecipeItems(map, (AbstractContainerScreen)Minecraft.getInstance().screen);
                    RecipeTransferData transferData = ((RecipeViewMenu)this.getMenu()).getTransferData().get(finalI);
                    HashMap<Integer, HashMap<Integer, ItemStack>> usedPlayerSlots = RecipeViewScreen.hasShiftDown() ? transferData.getStackedData().getUsedPlayerSlots() : transferData.getUsedPlayerSlots();
                    CommonEIV.networkManager().sendPacketToServer(new ServerboundTransferPayload(map.getTransferMap(), usedPlayerSlots));
                }
            }).size(12, 12).pos(guiLeft + currentView.getViewType().getDisplayWidth() + 4, guiTop + currentView.getViewType().getDisplayHeight() / 2 - 6).build();
            RecipeTransferData data = ((RecipeViewMenu)this.getMenu()).getTransferData().get(i);
            button.active = data.isSuccess() && currentView.supportsItemTransfer() && EivUtil.matchesAnyTransferClass(currentView, ((RecipeViewMenu)this.getMenu()).getParentScreen()) && currentView.canTransferToScreen((AbstractContainerScreen)((RecipeViewMenu)this.getMenu()).getParentScreen());
            button.visible = currentView.supportsItemTransfer();
            this.addRenderableWidget((GuiEventListener)button);
            this.transferButtons.add(button);
        }
    }

    private void checkTickers() {
        this.animationTickers.forEach(animationTicker -> this.animationTickCache.put(animationTicker.id(), animationTicker.getTick()));
        this.animationTickers.clear();
        ((RecipeViewMenu)this.getMenu()).getCurrentDisplay().forEach(recipe -> recipe.getAnimationTickers().forEach(animationTicker -> {
            this.animationTickers.add((AnimationTicker)animationTicker);
            if (this.animationTickCache.containsKey(animationTicker.id())) {
                animationTicker.setTick(this.animationTickCache.get(animationTicker.id()));
            } else {
                animationTicker.resetTick();
            }
        }));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        guiGraphics.drawString(this.font, this.guiTitle, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.page, (this.imageWidth - this.font.width((FormattedText)this.page)) / 2, this.imageHeight - 12, 0x404040, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @NotNull
    protected List<Component> getTooltipFromContainerItem(ItemStack itemStack) {
        List tooltip = super.getTooltipFromContainerItem(itemStack);
        CompoundTag tagTag = ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tagTag.contains("eiv_recipeTag")) {
            tooltip.add(Component.translatable((String)"view.eiv.tags").append(": ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)("#" + tagTag.getString("eiv_recipeTag"))).withStyle(ChatFormatting.GRAY)));
        }
        if (this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            ((RecipeViewMenu)this.getMenu()).getAdditionalStackModifier(this.hoveredSlot.getContainerSlot()).addTooltip(itemStack, tooltip);
        }
        tooltip.addLast(Component.literal((String)CommonEIVClient.resolver().getModNameForItem(itemStack.getItem())).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC));
        return tooltip;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (mouseX <= (double)this.leftPos && mouseX >= (double)(this.leftPos - 25) && mouseY >= (double)this.topPos && mouseY <= (double)(this.topPos + this.imageHeight)) {
            if (scrollY < 0.0) {
                ((RecipeViewMenu)this.getMenu()).nextReference();
            }
            if (scrollY > 0.0) {
                ((RecipeViewMenu)this.getMenu()).prevReference();
            }
            return true;
        }
        if (!(mouseX >= (double)this.leftPos && mouseX <= (double)(this.leftPos + this.imageWidth) && mouseY >= (double)this.topPos && mouseY <= (double)(this.topPos + this.imageHeight))) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        if (scrollY < 0.0) {
            ((RecipeViewMenu)this.getMenu()).nextPage();
            this.checkTickers();
        }
        if (scrollY > 0.0) {
            ((RecipeViewMenu)this.getMenu()).prevPage();
            this.checkTickers();
        }
        if (scrollY != 0.0) {
            this.page = this.createPageComponent();
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1 && this.hoveredSlot != null) {
            ItemViewOverlay.INSTANCE.openRecipeView(this.hoveredSlot.getItem(), ItemViewOverlay.ItemViewOpenType.INPUT);
            return true;
        }
        if (mouseButton == 0 && this.hoveredSlot != null) {
            ItemViewOverlay.INSTANCE.openRecipeView(this.hoveredSlot.getItem(), ItemViewOverlay.ItemViewOpenType.RESULT);
            return true;
        }
        if (mouseButton == 0) {
            for (int i = this.viewTypePage * 5; i < this.viewTypePage * 5 + 5 && this.viewTypeButtons.size() > i; ++i) {
                if (!this.viewTypeButtons.get(i).onClick(mouseButton, (int)mouseX, (int)mouseY)) continue;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private boolean isPrevTypeHovered(double mouseX, double mouseY) {
        return mouseX >= (double)(this.leftPos - 14 - 2) && mouseX <= (double)(this.leftPos - 2) && mouseY >= (double)(this.topPos + 2) && mouseY <= (double)(this.topPos + 2 + 14);
    }

    private boolean isNextTypeHovered(double mouseX, double mouseY) {
        return mouseX >= (double)(this.leftPos + this.imageWidth + 2) && mouseX <= (double)(this.leftPos + this.imageWidth + 2 + 14) && mouseY >= (double)(this.topPos + 2) && mouseY <= (double)(this.topPos + 2 + 14);
    }

    protected void containerTick() {
        this.animationTickers.forEach(AnimationTicker::tick);
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        long timeOpen = this.minecraft.player.clientLevel.getGameTime() - this.timestamp;
        if (timeOpen % 25L == 0L && timeOpen >= 25L) {
            ((RecipeViewMenu)this.getMenu()).tickContents();
        }
        ((RecipeViewMenu)this.getMenu()).getCurrentDisplay().forEach(IEivViewRecipe::tick);
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public int getGuiWidth() {
        return this.imageWidth;
    }

    public int getGuiHeight() {
        return this.imageHeight;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i;
        guiGraphics.blit(RenderType::guiTextured, VIEW_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight - 3, 256, 256);
        guiGraphics.blit(RenderType::guiTextured, VIEW_LOCATION, this.leftPos, this.topPos + (this.imageHeight - 3), 0.0f, 253.0f, this.imageWidth, 3, 256, 256);
        IEivRecipeViewType viewType = ((RecipeViewMenu)this.getMenu()).getViewType();
        int current = ((RecipeViewMenu)this.getMenu()).getCurrentTypeIndex();
        for (i = 0; i < 5; ++i) {
            guiGraphics.blit(RenderType::guiTextured, VIEW_LOCATION, this.width / 2 - 64 + i * 24 + i * 2, this.topPos - 24 - 1, 208.0f, 0.0f, 24, 24, 256, 256);
        }
        for (i = this.viewTypePage * 5; i < this.viewTypePage * 5 + 5 && this.viewTypeButtons.size() > i; ++i) {
            this.viewTypeButtons.get(i).render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        for (i = 0; i < ((RecipeViewMenu)this.getMenu()).getDisplayableCraftReferences(); ++i) {
            guiGraphics.blit(RenderType::guiTextured, VIEW_LOCATION, this.leftPos - 25, this.topPos + 4 + i * 24 + i, 231.0f, 48.0f, 25, 24, 256, 256);
        }
        if (((RecipeViewMenu)this.getMenu()).getCurrentCraftReference() > 0) {
            guiGraphics.blit(RenderType::guiTextured, VIEW_LOCATION, this.leftPos - 4 - 5 - 8, this.topPos + 4 - 1 - 4, 248.0f, 72.0f, 8, 4, 256, 256);
        }
        if (((RecipeViewMenu)this.getMenu()).getCurrentCraftReference() < ((RecipeViewMenu)this.getMenu()).getViewType().getCraftReferences().size() - ((RecipeViewMenu)this.getMenu()).getDisplayableCraftReferences()) {
            guiGraphics.blit(RenderType::guiTextured, VIEW_LOCATION, this.leftPos - 4 - 5 - 8, this.topPos + 4 + ((RecipeViewMenu)this.getMenu()).getDisplayableCraftReferences() * 25, 248.0f, 76.0f, 8, 4, 256, 256);
        }
        int guiLeft = this.leftPos + ((RecipeViewMenu)this.getMenu()).guiOffsetLeft();
        for (int i2 = 0; i2 < ((RecipeViewMenu)this.getMenu()).getCurrentDisplay().size(); ++i2) {
            int guiTop = this.topPos + ((RecipeViewMenu)this.getMenu()).guiOffsetTop(i2);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)guiLeft, (float)guiTop, 0.0f);
            guiGraphics.blit(RenderType::guiTextured, viewType.getGuiTexture(), 0, 0, 0.0f, 0.0f, viewType.getDisplayWidth(), viewType.getDisplayHeight(), viewType.getDisplayWidth(), viewType.getDisplayHeight());
            ((RecipeViewMenu)this.getMenu()).slots.stream().filter(slot -> ((RecipeViewMenu)this.getMenu()).isOptionalSlot(slot.index) && slot.hasItem()).forEach(slot -> {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(slot.x - (guiLeft - this.leftPos) - 1), (float)(slot.y - (guiTop - this.topPos) - 1), 0.0f);
                ((RecipeViewMenu)this.getMenu()).getOptionalSlotRenderer(slot.index).render(guiGraphics, mouseX - guiLeft, mouseY - guiTop, partialTicks);
                guiGraphics.pose().popPose();
            });
            this.renderInvalidSlots(guiGraphics, i2);
            ((RecipeViewMenu)this.getMenu()).getCurrentDisplay().get(i2).renderRecipe(this, guiGraphics, mouseX - guiLeft, mouseY - guiTop, partialTicks);
            guiGraphics.pose().popPose();
        }
    }

    private void renderInvalidSlots(GuiGraphics guiGraphics, int displayId) {
        Button button = this.transferButtons.get(displayId);
        if (!button.isHovered()) {
            return;
        }
        IEivViewRecipe current = ((RecipeViewMenu)this.getMenu()).getCurrentDisplay().get(displayId);
        RecipeTransferData data = ((RecipeViewMenu)this.getMenu()).getTransferData().get(displayId);
        if (data.isSuccess()) {
            return;
        }
        for (int slotId : data.getSlotResults().keySet()) {
            if (data.getSlotResults().get(slotId).booleanValue()) continue;
            int actualSlotId = slotId + displayId * current.getViewType().getSlotCount();
            Slot invSlot = ((RecipeViewMenu)this.getMenu()).getSlot(actualSlotId);
            int x = invSlot.x;
            int y = invSlot.y;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(-((RecipeViewMenu)this.getMenu()).guiOffsetLeft()), (float)(-((RecipeViewMenu)this.getMenu()).guiOffsetTop(displayId)), 0.0f);
            guiGraphics.fill(x, y, x + 16, y + 16, new Color(255, 0, 0, 64).getRGB());
            guiGraphics.pose().popPose();
        }
    }

    public void onClose() {
        super.onClose();
        Minecraft.getInstance().setScreen(((RecipeViewMenu)this.getMenu()).getParentScreen());
    }

    record ViewTypeButton(RecipeViewScreen viewScreen, int x, int y, int width, int height, IEivRecipeViewType viewType, int viewTypeId) {
        private boolean onClick(int mouseButton, int mouseX, int mouseY) {
            if (mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height) {
                return false;
            }
            ((RecipeViewMenu)this.viewScreen.getMenu()).setViewType(this.viewTypeId);
            AbstractWidget.playButtonClickSound((SoundManager)Minecraft.getInstance().getSoundManager());
            return true;
        }

        private void onHover(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height) {
                return;
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, this.viewType.getDisplayName(), mouseX, mouseY);
        }

        private void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            guiGraphics.blit(RenderType::guiTextured, VIEW_LOCATION, this.x(), this.y(), 232.0f, this.viewType() == ((RecipeViewMenu)this.viewScreen.getMenu()).getViewType() ? 24.0f : 0.0f, 24, 24, 256, 256);
            guiGraphics.renderFakeItem(this.viewType().getIcon(), this.x() + 4, this.y() + 4);
            this.onHover(guiGraphics, mouseX, mouseY);
        }
    }
}

