/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe.item;

import de.crafty.eiv.common.extra.FluidStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class FluidItem
extends BlockItem {
    private final Fluid fluid;

    public FluidItem(Block block, FluidItemProperties properties) {
        super(block, (Item.Properties)properties);
        this.fluid = properties.fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        FluidStack fluidStack = FluidStack.fromItemStack(itemStack);
        list.add((Component)Component.literal((String)String.valueOf(fluidStack.getAmount())).append((Component)Component.translatable((String)"eiv.fluid.unit")).withStyle(ChatFormatting.GRAY));
    }

    public static class FluidItemProperties
    extends Item.Properties {
        private Fluid fluid = Fluids.EMPTY;

        public FluidItemProperties fluid(Fluid fluid) {
            this.fluid = fluid;
            return this;
        }

        public FluidItemProperties setItemId(ResourceKey<Item> id) {
            this.setId(id);
            return this;
        }

        @NotNull
        protected String effectiveDescriptionId() {
            String s = super.effectiveDescriptionId();
            return s.replaceFirst("item.", "block.");
        }

        @NotNull
        public ResourceLocation effectiveModel() {
            return ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"fluiditem");
        }
    }
}

