/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.forge;

import com.mojang.brigadier.CommandDispatcher;
import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.api.IExtendedItemViewIntegration;
import de.crafty.eiv.common.command.EivCommand;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod(value="eiv")
public class ForgeEIV {
    public ForgeEIV(FMLJavaModLoadingContext context) {
        CommonEIV.LOGGER.info("Hello Minecraft!");
        MinecraftForge.EVENT_BUS.addListener(this::onCommandRegistry);
        CommonEIV.LOGGER.info("Scanning for integrations...");
        FMLLoader.getLoadingModList().getMods().forEach(modInfo -> {
            Optional optional = modInfo.getConfigElement("eiv");
            if (optional.isPresent()) {
                CommonEIV.LOGGER.info("Loading integration: {}", optional.get());
                try {
                    Class<?> clazz = Class.forName((String)optional.get());
                    IExtendedItemViewIntegration integration = (IExtendedItemViewIntegration)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    integration.onIntegrationInitialize();
                    CommonEIV.LOGGER.info("Integration initialized for mod: {}", (Object)modInfo.getModId());
                    return;
                }
                catch (Exception exception) {
                    CommonEIV.LOGGER.error("Failed to load integration: {}", optional.get());
                }
            }
        });
    }

    private void onCommandRegistry(RegisterCommandsEvent event) {
        EivCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

