/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.api.recipe;

import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.overlay.itemlist.view.ItemViewOverlay;
import de.crafty.eiv.common.recipe.ItemViewRecipes;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemView {
    private static final List<Item> EXCLUDED = new ArrayList<Item>();
    private static final HashMap<Item, List<StackSensitive>> STACK_SENSITIVE = new HashMap();
    private static final List<ReloadCallback> RELOAD_CALLBACKS = new ArrayList<ReloadCallback>();

    public static void addRecipeProvider(ItemViewRecipes.ServerRecipeProvider provider) {
        ItemViewRecipes.INSTANCE.addRecipeProvider(provider);
    }

    public static <T extends IEivServerRecipe> void registerRecipeWrapper(EivRecipeType<T> recipeType, ItemViewRecipes.ClientRecipeWrapper<T> wrapper) {
        ItemViewRecipes.INSTANCE.registerRecipeWrapper(recipeType, wrapper);
    }

    public static void excludeItem(Item item) {
        ItemView.excludeItems(item);
    }

    public static void excludeItems(Item ... items) {
        Arrays.stream(items).filter(item -> !EXCLUDED.contains(item)).forEach(EXCLUDED::add);
    }

    public static void addStackSensitive(ItemStack stack) {
        List present = STACK_SENSITIVE.getOrDefault(stack.getItem(), new ArrayList());
        present.add(new StackSensitive(stack));
        STACK_SENSITIVE.put(stack.getItem(), present);
    }

    public static HashMap<Item, List<StackSensitive>> getStackSensitive() {
        return STACK_SENSITIVE;
    }

    public static List<Item> getExcluded() {
        return EXCLUDED;
    }

    public static void openForStackIngredient(ItemStack stack) {
        ItemViewOverlay.INSTANCE.openRecipeView(stack, ItemViewOverlay.ItemViewOpenType.INPUT);
    }

    public static void openForStackResult(ItemStack stack) {
        ItemViewOverlay.INSTANCE.openRecipeView(stack, ItemViewOverlay.ItemViewOpenType.RESULT);
    }

    public static void addReloadCallback(ReloadCallback callback) {
        RELOAD_CALLBACKS.add(callback);
    }

    public static List<ReloadCallback> getReloadCallbacks() {
        return RELOAD_CALLBACKS;
    }

    public record StackSensitive(ItemStack stack) {
        private final ItemStack stack;
        public static final StreamCodec<RegistryFriendlyByteBuf, StackSensitive> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, stackSensitive -> EivTagUtil.encodeItemStackOnServer(stackSensitive.stack()), compoundTag -> new StackSensitive(EivTagUtil.decodeItemStackOnClient(compoundTag)));

        public ItemStack stack() {
            return this.stack.copy();
        }
    }

    public static interface ReloadCallback {
        public void onReload();
    }
}

