/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.smelting;

import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class SmeltingServerRecipe
implements IEivServerRecipe {
    public static final EivRecipeType<SmeltingServerRecipe> TYPE = EivRecipeType.register(ResourceLocation.withDefaultNamespace((String)"smelting"), () -> new SmeltingServerRecipe(null, ItemStack.EMPTY));
    private Ingredient input;
    private ItemStack result;

    public SmeltingServerRecipe(Ingredient input, ItemStack result) {
        this.input = input;
        this.result = result;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public void writeToTag(CompoundTag tag) {
        tag.put("input", (Tag)EivTagUtil.writeIngredient(this.input));
        tag.put("result", (Tag)EivTagUtil.encodeItemStackOnServer(this.result));
    }

    @Override
    public void loadFromTag(CompoundTag tag) {
        this.input = EivTagUtil.readIngredient(tag.getCompound("input").orElseGet(CompoundTag::new));
        this.result = EivTagUtil.decodeItemStackOnClient(tag.getCompound("result").orElseGet(CompoundTag::new));
    }

    @Override
    public EivRecipeType<? extends IEivServerRecipe> getRecipeType() {
        return TYPE;
    }
}

