/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.overlay;

import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.network.EivNetworkManager;
import de.crafty.eiv.common.network.payload.mode.ServerboundPickCheatmodeItemPayload;
import de.crafty.eiv.common.overlay.itemlist.view.ItemViewOverlay;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemSlot {
    private static final ResourceLocation SLOT_HIGHLIGHT_BACK_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_back");
    private static final ResourceLocation SLOT_HIGHLIGHT_FRONT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_front");
    private final ItemStack stack;
    private final int x;
    private final int y;
    private boolean hovered;
    private int currentCheatmodeCount = 1;

    public ItemSlot(ItemStack stack, int x, int y) {
        this.stack = stack;
        this.x = x;
        this.y = y;
    }

    public void changeCheatmodeCount(int change) {
        this.currentCheatmodeCount += change;
        this.currentCheatmodeCount = Math.max(1, Math.min(this.currentCheatmodeCount, this.stack.getMaxStackSize()));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.hovered = this.isMouseOver(mouseX, mouseY);
        if (!this.isHovered() && this.currentCheatmodeCount > 1) {
            this.currentCheatmodeCount = 1;
        }
        Minecraft mc = Minecraft.getInstance();
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(Screen.getTooltipFromItem((Minecraft)mc, (ItemStack)this.stack));
        if (CommonEIVClient.isCheatmodeActive()) {
            tooltip.addLast(Component.literal((String)"Taking x").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(this.currentCheatmodeCount)).withStyle(ChatFormatting.GOLD)));
        }
        tooltip.addLast(Component.literal((String)CommonEIVClient.resolver().getModNameForItem(this.stack.getItem())).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC));
        if (this.isHovered()) {
            guiGraphics.fill(this.x, this.y, this.x + 20, this.y + 20, new Color(255, 255, 255, 32).getRGB());
        }
        guiGraphics.renderItem(this.stack, this.x + 2, this.y + 2);
        if (this.isHovered()) {
            guiGraphics.setComponentTooltipForNextFrame(mc.font, tooltip, mouseX, mouseY);
        }
    }

    public void onClicked(int mouseX, int mouseY, int mouseButton) {
        LocalPlayer clientPlayer = Minecraft.getInstance().player;
        if (clientPlayer == null) {
            return;
        }
        if (mouseButton == 2 && CommonEIVClient.isCheatmodeActive()) {
            this.currentCheatmodeCount = this.stack.getMaxStackSize();
        }
        if (mouseButton == 0 && CommonEIVClient.isCheatmodeActive()) {
            EivNetworkManager.INSTANCE.sendPacketToServer(new ServerboundPickCheatmodeItemPayload(this.stack.copy(), this.currentCheatmodeCount));
            return;
        }
        if (mouseButton == 0) {
            ItemViewOverlay.INSTANCE.openRecipeView(this.stack, ItemViewOverlay.ItemViewOpenType.RESULT);
        }
        if (mouseButton == 1) {
            ItemViewOverlay.INSTANCE.openRecipeView(this.stack, ItemViewOverlay.ItemViewOpenType.INPUT);
        }
    }

    boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + 20 && mouseY >= this.y && mouseY < this.y + 20;
    }

    public boolean isHovered() {
        return this.hovered;
    }
}

