/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin;

import com.mojang.datafixers.util.Either;
import de.crafty.eiv.common.api.IExtendedItemViewIntegration;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.builtin.blasting.BlastingServerRecipe;
import de.crafty.eiv.common.builtin.blasting.BlastingViewRecipe;
import de.crafty.eiv.common.builtin.brewing.BrewingServerRecipe;
import de.crafty.eiv.common.builtin.brewing.BrewingViewRecipe;
import de.crafty.eiv.common.builtin.burning.BurningServerRecipe;
import de.crafty.eiv.common.builtin.burning.BurningViewRecipe;
import de.crafty.eiv.common.builtin.campfire.CampfireServerRecipe;
import de.crafty.eiv.common.builtin.campfire.CampfireViewRecipe;
import de.crafty.eiv.common.builtin.entity.EntityServerRecipe;
import de.crafty.eiv.common.builtin.entity.EntityViewRecipe;
import de.crafty.eiv.common.builtin.shaped.CraftingViewRecipe;
import de.crafty.eiv.common.builtin.shaped.ShapedServerRecipe;
import de.crafty.eiv.common.builtin.shapeless.ShapelessServerRecipe;
import de.crafty.eiv.common.builtin.shapeless.ShapelessViewRecipe;
import de.crafty.eiv.common.builtin.smelting.SmeltingServerRecipe;
import de.crafty.eiv.common.builtin.smelting.SmeltingViewRecipe;
import de.crafty.eiv.common.builtin.smithing.SmithingServerRecipe;
import de.crafty.eiv.common.builtin.smithing.SmithingViewRecipe;
import de.crafty.eiv.common.builtin.smoking.SmokingServerRecipe;
import de.crafty.eiv.common.builtin.smoking.SmokingViewRecipe;
import de.crafty.eiv.common.builtin.stonecutting.StonecutterServerRecipe;
import de.crafty.eiv.common.builtin.stonecutting.StonecutterViewRecipe;
import de.crafty.eiv.common.builtin.tipped_arrow.TippedArrowServerRecipe;
import de.crafty.eiv.common.builtin.transmute.TransmuteServerRecipe;
import de.crafty.eiv.common.builtin.villager.VillagerServerRecipe;
import de.crafty.eiv.common.builtin.villager.VillagerViewRecipe;
import de.crafty.eiv.common.mixin.world.item.alchemy.PotionBrewingAccessor;
import de.crafty.eiv.common.mixin.world.item.crafting.IngredientAccessor;
import de.crafty.eiv.common.mixin.world.item.crafting.TransmuteRecipeAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.LootPoolAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.LootTableAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.entries.CompositeEntryBaseAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.entries.LootItemAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.entries.LootPoolSingletonContainerAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.functions.SetPotionFunctionAccessor;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10223;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_221;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3956;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_6662;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_69;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8056;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.class_9895;

public class BuiltInEivIntegration
implements IExtendedItemViewIntegration {
    public static final class_2960 WIDGETS = class_2960.method_60655((String)"eiv", (String)"textures/gui/eiv_widgets.png");
    public static final class_2960 DEFAULT_SLOT_TEXTURE = class_2960.method_60655((String)"eiv", (String)"textures/gui/default_slot.png");

    @Override
    public void onIntegrationInitialize() {
        ItemView.excludeItem(class_1802.field_8162);
        ItemView.addReloadCallback(() -> {
            class_2378 potionRegistry = ServerRecipeManager.INSTANCE.getServer().method_30611().method_30530(class_7924.field_41215);
            potionRegistry.forEach(potion -> {
                ItemView.addStackSensitive(class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)potionRegistry.method_47983(potion)));
                ItemView.addStackSensitive(class_1844.method_57400((class_1792)class_1802.field_8436, (class_6880)potionRegistry.method_47983(potion)));
                ItemView.addStackSensitive(class_1844.method_57400((class_1792)class_1802.field_8150, (class_6880)potionRegistry.method_47983(potion)));
                if (ServerRecipeManager.INSTANCE.getServer().method_59777().method_20361(potionRegistry.method_47983(potion))) {
                    class_1799 tipped = new class_1799((class_1935)class_1802.field_8087);
                    tipped.method_57379(class_9334.field_49651, (Object)new class_1844(potionRegistry.method_47983(potion)));
                    ItemView.addStackSensitive(tipped);
                }
            });
            class_2378 enchantmentRegistry = ServerRecipeManager.INSTANCE.getServer().method_30611().method_30530(class_7924.field_41265);
            enchantmentRegistry.forEach(enchantment -> {
                for (int i = enchantment.method_8187(); i <= enchantment.method_8183(); ++i) {
                    class_1799 enchantedBook = class_1890.method_61711((class_1889)new class_1889(enchantmentRegistry.method_47983(enchantment), i));
                    ItemView.addStackSensitive(enchantedBook);
                }
            });
        });
        ItemView.addRecipeProvider(recipeList -> class_7923.field_41177.forEach(entityType -> {
            if (entityType.method_16351().isEmpty()) {
                return;
            }
            class_52 table = ServerRecipeManager.INSTANCE.getServer().method_58576().method_58295((class_5321)entityType.method_16351().get());
            LootTableAccessor accessor = (LootTableAccessor)table;
            ArrayList<class_1799> loot = new ArrayList<class_1799>();
            for (class_55 pool : accessor.getPools()) {
                LootPoolAccessor lootPoolAccessor = (LootPoolAccessor)pool;
                for (class_79 container : lootPoolAccessor.entries()) {
                    if (container instanceof class_77) {
                        class_77 lootItem = (class_77)container;
                        LootItemAccessor lootItemAccessor = (LootItemAccessor)lootItem;
                        LootPoolSingletonContainerAccessor containerAccessor = (LootPoolSingletonContainerAccessor)((Object)lootItemAccessor);
                        class_1799 stack = new class_1799((class_1935)lootItemAccessor.getItem().comp_349());
                        containerAccessor.getFunctions().forEach(function -> {
                            if (function instanceof class_6662) {
                                class_6662 setPotionFunction = (class_6662)function;
                                stack.method_57379(class_9334.field_49651, (Object)((class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274)).method_57403(((SetPotionFunctionAccessor)setPotionFunction).getPotion()));
                            }
                        });
                        for (class_5341 condition : lootPoolAccessor.conditions()) {
                            if (!(condition instanceof class_221)) continue;
                            stack.method_57379(class_9334.field_49632, (Object)((class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340)).method_57499((class_2561)class_2561.method_43471((String)"view.eiv.type.entity.playerKill").method_27692(class_124.field_1061)));
                        }
                        loot.add(stack);
                    }
                    if (!(container instanceof class_69)) continue;
                    class_69 entryBase = (class_69)container;
                    CompositeEntryBaseAccessor entryBaseAccessor = (CompositeEntryBaseAccessor)entryBase;
                    entryBaseAccessor.getChildren().forEach(child -> {
                        if (child instanceof class_77) {
                            class_77 lootItem = (class_77)child;
                            LootItemAccessor lootItemAccessor = (LootItemAccessor)lootItem;
                            loot.add(new class_1799(lootItemAccessor.getItem()));
                        }
                    });
                }
            }
            if (entityType == class_1299.field_6119) {
                loot.add(new class_1799((class_1935)class_1802.field_8137));
            }
            if (!loot.isEmpty()) {
                recipeList.add(new EntityServerRecipe((class_1299<?>)entityType, (List<class_1799>)loot));
            }
        }));
        ItemView.addRecipeProvider(recipeList -> {
            class_9895 fuelValues = ServerRecipeManager.INSTANCE.getServer().method_62735();
            fuelValues.method_61751().forEach(item -> recipeList.add(new BurningServerRecipe((class_1792)item, fuelValues.method_61755(new class_1799((class_1935)item)))));
        });
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(class_3956.field_17546).forEach(recipe -> recipeList.add(new SmeltingServerRecipe(recipe.method_64720(), recipe.field_17643))));
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(class_3956.field_17547).forEach(recipe -> recipeList.add(new BlastingServerRecipe(recipe.method_64720(), recipe.field_17643))));
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(class_3956.field_17548).forEach(recipe -> recipeList.add(new SmokingServerRecipe(recipe.method_64720(), recipe.field_17643))));
        ItemView.addRecipeProvider(recipeList -> {
            ServerRecipeManager.INSTANCE.getRecipesForType(class_3956.field_17545).forEach(recipe -> {
                if (recipe instanceof class_1867) {
                    class_1867 shapelessRecipe = (class_1867)recipe;
                    recipeList.add(new ShapelessServerRecipe(shapelessRecipe.field_9047, shapelessRecipe.field_9050));
                }
                if (recipe instanceof class_1869) {
                    class_1869 shapedRecipe = (class_1869)recipe;
                    HashMap<Integer, class_1856> ingredients = new HashMap<Integer, class_1856>();
                    int i = 0;
                    for (int y = 0; y < 3; ++y) {
                        for (int x = 0; x < 3; ++x) {
                            if (x >= shapedRecipe.method_8150() || y >= shapedRecipe.method_8158()) continue;
                            if (((Optional)shapedRecipe.method_61693().get(i)).isPresent()) {
                                ingredients.put(x + y * 3, (class_1856)((Optional)shapedRecipe.method_61693().get(i)).get());
                            }
                            ++i;
                        }
                    }
                    recipeList.add(new ShapedServerRecipe(shapedRecipe.method_8150(), shapedRecipe.method_8158(), ingredients, shapedRecipe.field_9053));
                }
                if (recipe instanceof class_10223) {
                    TransmuteRecipeAccessor accessor = (TransmuteRecipeAccessor)recipe;
                    ArrayList<class_1799> results = new ArrayList<class_1799>();
                    Either ingredientContent = ((IngredientAccessor)accessor.getInput()).getValues().method_40248();
                    ArrayList<class_1792> ingredients = new ArrayList<class_1792>();
                    if (ingredientContent.left().isPresent()) {
                        SlotContent.getItemsFromTag((class_6862<class_1792>)((class_6862)ingredientContent.left().get())).ifPresent(holders -> holders.forEach(holder -> ingredients.add((class_1792)holder.comp_349())));
                    }
                    if (ingredientContent.right().isPresent()) {
                        ingredients.addAll(((List)ingredientContent.right().get()).stream().map(class_6880::comp_349).toList());
                    }
                    ingredients.forEach(ingredient -> results.add(accessor.getResult().method_66340(new class_1799((class_1935)ingredient))));
                    if (!ingredients.isEmpty() && !results.isEmpty()) {
                        recipeList.add(new TransmuteServerRecipe(accessor.getInput(), accessor.getMaterial(), results));
                    }
                }
            });
            class_2378 potionRegistry = ServerRecipeManager.INSTANCE.getServer().method_30611().method_30530(class_7924.field_41215);
            potionRegistry.forEach(potion -> {
                class_1799 potionStack = class_1844.method_57400((class_1792)class_1802.field_8150, (class_6880)potionRegistry.method_47983(potion));
                recipeList.add(new TippedArrowServerRecipe(potionStack));
            });
        });
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(class_3956.field_17549).forEach(campfireCookingRecipe -> recipeList.add(new CampfireServerRecipe(campfireCookingRecipe.method_64720(), campfireCookingRecipe.field_17643))));
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(class_3956.field_17641).forEach(stonecutterRecipe -> recipeList.add(new StonecutterServerRecipe(stonecutterRecipe.method_64720(), stonecutterRecipe.field_17643))));
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(class_3956.field_25388).forEach(smithingRecipe -> {
            if (smithingRecipe instanceof class_8062) {
                class_8062 trimRecipe = (class_8062)smithingRecipe;
                recipeList.add(new SmithingServerRecipe(true, trimRecipe.method_64723(), trimRecipe.method_64722().orElse(null), trimRecipe.method_64724().orElse(null), (class_8056)trimRecipe.field_56321.comp_349(), null));
            }
            if (smithingRecipe instanceof class_8060) {
                class_8060 transformRecipe = (class_8060)smithingRecipe;
                recipeList.add(new SmithingServerRecipe(false, transformRecipe.method_64723(), transformRecipe.method_64722().orElse(null), transformRecipe.method_64724().orElse(null), null, transformRecipe.field_42033));
            }
        }));
        ItemView.addRecipeProvider(recipeList -> {
            class_1845 potionBrewing = ServerRecipeManager.INSTANCE.getServer().method_59777();
            List<class_1845.class_1846<class_1842>> potionMixes = ((PotionBrewingAccessor)potionBrewing).getPotionMixes();
            List<class_1845.class_1846<class_1792>> containerMixes = ((PotionBrewingAccessor)potionBrewing).getContainerMixes();
            containerMixes.forEach(itemMix -> recipeList.add(new BrewingServerRecipe(new class_1799((class_1935)itemMix.comp_2192().comp_349()), itemMix.comp_2191(), new class_1799((class_1935)itemMix.comp_2190().comp_349()))));
            potionMixes.forEach(potionMix -> {
                recipeList.add(new BrewingServerRecipe(class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)potionMix.comp_2192()), potionMix.comp_2191(), class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)potionMix.comp_2190())));
                recipeList.add(new BrewingServerRecipe(class_1844.method_57400((class_1792)class_1802.field_8436, (class_6880)potionMix.comp_2192()), potionMix.comp_2191(), class_1844.method_57400((class_1792)class_1802.field_8436, (class_6880)potionMix.comp_2190())));
                recipeList.add(new BrewingServerRecipe(class_1844.method_57400((class_1792)class_1802.field_8150, (class_6880)potionMix.comp_2192()), potionMix.comp_2191(), class_1844.method_57400((class_1792)class_1802.field_8150, (class_6880)potionMix.comp_2190())));
            });
        });
        ItemView.addRecipeProvider(recipeList -> class_3853.field_17067.forEach((profession, byProfessionLevel) -> byProfessionLevel.forEach((professionLevel, itemListings) -> Arrays.stream(itemListings).toList().forEach(listing -> {
            if (listing instanceof class_3853.class_4161) {
                class_3853.class_4161 emeraldForItems = (class_3853.class_4161)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_4161>(VillagerServerRecipe.VillagerOfferType.EMERALD_FOR_ITEMS, emeraldForItems)));
            }
            if (listing instanceof class_3853.class_4165) {
                class_3853.class_4165 itemsForEmeralds = (class_3853.class_4165)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_4165>(VillagerServerRecipe.VillagerOfferType.ITEMS_FOR_EMERALDS, itemsForEmeralds)));
            }
            if (listing instanceof class_3853.class_4166) {
                class_3853.class_4166 suspiciousStewForEmerald = (class_3853.class_4166)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_4166>(VillagerServerRecipe.VillagerOfferType.SUSPICIOUS_STEW, suspiciousStewForEmerald)));
            }
            if (listing instanceof class_3853.class_1648) {
                class_3853.class_1648 enchantBookForEmeralds = (class_3853.class_1648)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_1648>(VillagerServerRecipe.VillagerOfferType.ENCHANT_BOOK, enchantBookForEmeralds)));
            }
            if (listing instanceof class_3853.class_1654) {
                class_3853.class_1654 treasureMapForEmeralds = (class_3853.class_1654)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_1654>(VillagerServerRecipe.VillagerOfferType.TREASURE_MAP, treasureMapForEmeralds)));
            }
            if (listing instanceof class_3853.class_4167) {
                class_3853.class_4167 tippedArrowForItemsAndEmeralds = (class_3853.class_4167)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_4167>(VillagerServerRecipe.VillagerOfferType.TIPPED_ARROW, tippedArrowForItemsAndEmeralds)));
            }
            if (listing instanceof class_3853.class_4163) {
                class_3853.class_4163 enchantedItemForEmeralds = (class_3853.class_4163)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_4163>(VillagerServerRecipe.VillagerOfferType.ENCHANTED_ITEM_FOR_EMERALDS, enchantedItemForEmeralds)));
            }
            if (listing instanceof class_3853.class_4160) {
                class_3853.class_4160 dyedArmorForEmeralds = (class_3853.class_4160)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_4160>(VillagerServerRecipe.VillagerOfferType.DYED_ARMOR, dyedArmorForEmeralds)));
            }
            if (listing instanceof class_3853.class_4164) {
                class_3853.class_4164 itemsAndEmeraldsToItems = (class_3853.class_4164)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_4164>(VillagerServerRecipe.VillagerOfferType.ITEMS_AND_EMERALDS_TO_ITEMS, itemsAndEmeraldsToItems)));
            }
            if (listing instanceof class_3853.class_4162) {
                class_3853.class_4162 emeraldsForVillagerTypeItem = (class_3853.class_4162)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_4162>(VillagerServerRecipe.VillagerOfferType.EMERALDS_FOR_VILLAGER_TYPE, emeraldsForVillagerTypeItem)));
            }
            if (listing instanceof class_3853.class_8640) {
                class_3853.class_8640 typeSpecificTrade = (class_3853.class_8640)listing;
                recipeList.add(new VillagerServerRecipe((class_5321<class_3852>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<class_3853.class_8640>(VillagerServerRecipe.VillagerOfferType.TYPE_SPECIFIC, typeSpecificTrade)));
            }
        }))));
        ItemView.registerRecipeWrapper(BurningServerRecipe.TYPE, unwrapped -> List.of(new BurningViewRecipe((BurningServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(SmeltingServerRecipe.TYPE, unwrapped -> List.of(new SmeltingViewRecipe((SmeltingServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(BlastingServerRecipe.TYPE, unwrapped -> List.of(new BlastingViewRecipe((BlastingServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(SmokingServerRecipe.TYPE, unwrapped -> List.of(new SmokingViewRecipe((SmokingServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(ShapelessServerRecipe.TYPE, unwrapped -> List.of(new ShapelessViewRecipe((ShapelessServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(ShapedServerRecipe.TYPE, unwrapped -> List.of(new CraftingViewRecipe((ShapedServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(TransmuteServerRecipe.TYPE, unwrapped -> List.of(new ShapelessViewRecipe((TransmuteServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(TippedArrowServerRecipe.TYPE, unwrapped -> List.of(new CraftingViewRecipe((TippedArrowServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(CampfireServerRecipe.TYPE, unwrapped -> List.of(new CampfireViewRecipe((CampfireServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(StonecutterServerRecipe.TYPE, unwrapped -> List.of(new StonecutterViewRecipe((StonecutterServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(SmithingServerRecipe.TYPE, unwrapped -> {
            ArrayList recipes = new ArrayList();
            SlotContent.of(unwrapped.getTemplate()).getValidContents().forEach(templateStack -> SlotContent.of(unwrapped.getBase()).getValidContents().forEach(baseStack -> recipes.add(new SmithingViewRecipe(unwrapped.isTrim(), unwrapped.getAddition(), (class_1799)baseStack, (class_1799)templateStack, unwrapped.getPattern(), unwrapped.getUpgradeResult()))));
            return recipes;
        });
        ItemView.registerRecipeWrapper(BrewingServerRecipe.TYPE, unwrapped -> List.of(new BrewingViewRecipe((BrewingServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(VillagerServerRecipe.TYPE, unwrapped -> unwrapped.getOffers().stream().map(VillagerViewRecipe::new).toList());
        ItemView.registerRecipeWrapper(EntityServerRecipe.TYPE, unwrapped -> List.of(new EntityViewRecipe((EntityServerRecipe)unwrapped)));
    }
}

