/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.villager;

import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.mixin.world.entity.npc.DyedArmorForEmeraldsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.EmeraldForItemsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.EmeraldsForVillagerTypeItemAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.EnchantBookForEmeraldsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.EnchantedItemForEmeraldsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.ItemsAndEmeraldsToItemsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.ItemsForEmeraldsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.SuspiciousStewForEmeraldAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.TippedArrowForItemsAndEmeraldsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.TreasureMapForEmeraldsAccessor;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9282;
import net.minecraft.class_9290;
import net.minecraft.class_9294;
import net.minecraft.class_9334;
import net.minecraft.class_9428;
import net.minecraft.class_9636;
import net.minecraft.class_9741;
import net.minecraft.class_9743;
import net.minecraft.class_9744;
import net.minecraft.class_9745;
import net.minecraft.class_9889;
import org.jetbrains.annotations.Nullable;

public class VillagerServerRecipe
implements IEivServerRecipe {
    public static final EivRecipeType<VillagerServerRecipe> TYPE = EivRecipeType.register(class_2960.method_60656((String)"villager_trading"), () -> new VillagerServerRecipe(null, 0, null));
    private class_5321<class_3852> profession;
    private int professionLevel;
    private final VillagerDataObject<?> dataObject;
    private List<VillagerOffer> clientSideVillagerOffers = new ArrayList<VillagerOffer>();

    public VillagerServerRecipe(class_5321<class_3852> profession, int professionLevel, VillagerDataObject<?> dataObject) {
        this.profession = profession;
        this.professionLevel = professionLevel;
        this.dataObject = dataObject;
    }

    public List<VillagerOffer> getOffers() {
        return this.clientSideVillagerOffers;
    }

    public class_5321<class_3852> getProfession() {
        return this.profession;
    }

    public int getProfessionLevel() {
        return this.professionLevel;
    }

    @Override
    public void writeToTag(class_2487 tag) {
        tag.method_10582("profession", this.profession.method_29177().toString());
        tag.method_10569("professionLevel", this.professionLevel);
        tag.method_10582("type", this.dataObject.type().id().toString());
        class_2487 data = new class_2487();
        this.dataObject.type().encoder().encode(VillagerServerRecipe.castListing(this.dataObject.listing), data);
        tag.method_10566("data", (class_2520)data);
    }

    @Override
    public void loadFromTag(class_2487 tag) {
        if (tag.method_10545("profession")) {
            this.profession = ((class_6880.class_6883)class_7923.field_41195.method_10223(class_2960.method_60654((String)((String)tag.method_10558("profession").orElseThrow()))).orElseThrow()).method_40237();
        }
        this.professionLevel = tag.method_68083("professionLevel", 0);
        VillagerOfferType type = VillagerOfferType.byId(class_2960.method_60654((String)((String)tag.method_10558("type").orElseThrow())));
        this.clientSideVillagerOffers = type.decoder().decode(this.profession, this.professionLevel, tag.method_68568("data"));
    }

    public static <T extends class_3853.class_1652> T castListing(class_3853.class_1652 listing) {
        return (T)listing;
    }

    @Override
    public EivRecipeType<? extends IEivServerRecipe> getRecipeType() {
        return TYPE;
    }

    private static List<class_1799> createOfferStacksFromEnchantmentProvider(class_9741 provider, class_1799 stack) {
        ArrayList<class_1799> offerStacks = new ArrayList<class_1799>();
        class_9889 enchantable = (class_9889)stack.method_58694(class_9334.field_53695);
        class_9741 class_97412 = provider;
        Objects.requireNonNull(class_97412);
        class_9741 class_97413 = class_97412;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_9745.class, class_9743.class, class_9744.class}, (Object)class_97413, n)) {
            case 0: {
                class_9745 singleEnchantment = (class_9745)class_97413;
                for (int i = singleEnchantment.comp_2770().method_35009(); i <= singleEnchantment.comp_2770().method_35011(); ++i) {
                    class_1799 offerStack = stack.method_7972();
                    offerStack.method_7978(singleEnchantment.comp_2769(), i);
                    offerStacks.add(offerStack);
                }
                break;
            }
            case 1: {
                class_9743 byCost = (class_9743)class_97413;
                if (enchantable == null) {
                    return List.of();
                }
                float f = 0.15f;
                float f1 = -0.15f;
                int byCostMin = byCost.comp_2765().method_35009();
                int byCostMax = byCost.comp_2765().method_35011();
                ++byCostMin;
                byCostMin = class_3532.method_15340((int)Math.round((float)byCostMin + (float)byCostMin * f1), (int)1, (int)Integer.MAX_VALUE);
                byCostMax += 1 + enchantable.comp_2938() / 4 + enchantable.comp_2938() / 4;
                byCostMax = class_3532.method_15340((int)Math.round((float)byCostMax + (float)byCostMax * f), (int)1, (int)Integer.MAX_VALUE);
                for (int i = byCostMin; i <= byCostMax; ++i) {
                    class_1890.method_8229((int)i, (class_1799)stack.method_7972(), (Stream)byCost.comp_2764().method_40239()).forEach(enchantmentInstance -> {
                        class_1799 offerStack = stack.method_7972();
                        offerStack.method_7978(enchantmentInstance.comp_3486(), enchantmentInstance.comp_3487());
                        offerStacks.add(offerStack);
                    });
                }
                break;
            }
            case 2: {
                class_9744 byCostWithDifficulty = (class_9744)class_97413;
                if (enchantable == null) {
                    return List.of();
                }
                float f = 0.15f;
                float f1 = -0.15f;
                int byCostMin = byCostWithDifficulty.comp_2767();
                int byCostMax = byCostWithDifficulty.comp_2767() + byCostWithDifficulty.comp_2768();
                ++byCostMin;
                byCostMin = class_3532.method_15340((int)Math.round((float)byCostMin + (float)byCostMin * f1), (int)1, (int)Integer.MAX_VALUE);
                byCostMax += 1 + enchantable.comp_2938() / 4 + enchantable.comp_2938() / 4;
                byCostMax = class_3532.method_15340((int)Math.round((float)byCostMax + (float)byCostMax * f), (int)1, (int)Integer.MAX_VALUE);
                for (int i = byCostMin; i < byCostMax; ++i) {
                    class_1890.method_8229((int)i, (class_1799)stack.method_7972(), (Stream)byCostWithDifficulty.comp_2766().method_40239()).forEach(enchantmentInstance -> {
                        class_1799 offerStack = stack.method_7972();
                        offerStack.method_7978(enchantmentInstance.comp_3486(), enchantmentInstance.comp_3487());
                        offerStacks.add(offerStack);
                    });
                }
                break;
            }
            default: {
                offerStacks.add(stack.method_7972());
            }
        }
        return offerStacks;
    }

    public record VillagerDataObject<T extends class_3853.class_1652>(VillagerOfferType<T> type, T listing) {
    }

    public record VillagerOfferType<T extends class_3853.class_1652>(class_2960 id, Encoder<T> encoder, Decoder decoder) {
        private static final HashMap<class_2960, VillagerOfferType<?>> TYPES = new HashMap();
        private static final HashMap<Class<?>, class_2960> ID_BY_CLASS = new HashMap();
        public static final VillagerOfferType<class_3853.class_4161> EMERALD_FOR_ITEMS = VillagerOfferType.register(class_2960.method_60656((String)"emerald_for_items"), class_3853.class_4161.class, (listing, out) -> {
            EmeraldForItemsAccessor accessor = (EmeraldForItemsAccessor)listing;
            out.method_10566("cost", (class_2520)EivTagUtil.encodeItemStackOnServer(accessor.getItemStack().comp_2427()));
            out.method_10569("emeraldCount", accessor.getEmeraldAmount());
            out.method_10569("villagerXp", accessor.getVillagerXp());
            out.method_10569("maxUses", accessor.getMaxUses());
        }, (profession, professionLevel, in) -> {
            class_1799 cost = EivTagUtil.decodeItemStackOnClient(in.method_68568("cost"));
            int emeraldCount = in.method_68083("emeraldCount", 0);
            int villagerXp = in.method_68083("villagerXp", 0);
            int maxUses = in.method_68083("maxUses", 0);
            class_5321 villagerType = !in.method_10545("requiredType") ? null : ((class_6880.class_6883)class_7923.field_41194.method_10223(class_2960.method_60654((String)((String)in.method_10558("requiredType").orElseThrow()))).orElseThrow()).method_40237();
            return List.of(new VillagerOffer((class_5321<class_3852>)profession, professionLevel, (class_5321<class_3854>)villagerType, List.of(new class_1799((class_1935)class_1802.field_8687, emeraldCount)), List.of(cost), List.of(), villagerXp, maxUses));
        });
        public static final VillagerOfferType<class_3853.class_4165> ITEMS_FOR_EMERALDS = VillagerOfferType.register(class_2960.method_60656((String)"items_for_emeralds"), class_3853.class_4165.class, (listing, out) -> {
            ItemsForEmeraldsAccessor accessor = (ItemsForEmeraldsAccessor)listing;
            ArrayList<class_1799> offerStacks = new ArrayList<class_1799>();
            if (accessor.enchantmentProvider().isPresent()) {
                class_9741 provider = (class_9741)((class_6880.class_6883)ServerRecipeManager.INSTANCE.getServer().method_30611().method_30530(class_7924.field_51839).method_46746(accessor.enchantmentProvider().get()).orElseThrow()).comp_349();
                offerStacks.addAll(VillagerServerRecipe.createOfferStacksFromEnchantmentProvider(provider, accessor.itemStack()));
            } else {
                offerStacks.add(accessor.itemStack().method_7972());
            }
            out.method_10566("offers", (class_2520)EivTagUtil.writeList(offerStacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
            out.method_10569("emeraldCost", accessor.emeraldCost());
            out.method_10569("villagerXp", accessor.villagerXp());
            out.method_10569("maxUses", accessor.maxUses());
        }, (profession, professionLevel, in) -> {
            List<class_1799> offers = EivTagUtil.readList(in, "offers", EivTagUtil::decodeItemStackOnClient);
            int emeraldCost = in.method_68083("emeraldCost", 0);
            int villagerXp = in.method_68083("villagerXp", 0);
            int maxUses = in.method_68083("maxUses", 0);
            class_5321 villagerType = !in.method_10545("requiredType") ? null : ((class_6880.class_6883)class_7923.field_41194.method_10223(class_2960.method_60654((String)((String)in.method_10558("requiredType").orElseThrow()))).orElseThrow()).method_40237();
            return List.of(new VillagerOffer((class_5321<class_3852>)profession, professionLevel, (class_5321<class_3854>)villagerType, offers, List.of(new class_1799((class_1935)class_1802.field_8687, emeraldCost)), List.of(), villagerXp, maxUses));
        });
        public static final VillagerOfferType<class_3853.class_4166> SUSPICIOUS_STEW = VillagerOfferType.register(class_2960.method_60656((String)"suspicious_stew"), class_3853.class_4166.class, (listing, out) -> {
            SuspiciousStewForEmeraldAccessor accessor = (SuspiciousStewForEmeraldAccessor)listing;
            class_1799 stewStack = new class_1799((class_1935)class_1802.field_8766, 1);
            stewStack.method_57379(class_9334.field_49652, (Object)accessor.effects());
            out.method_10566("stew", (class_2520)EivTagUtil.encodeItemStackOnServer(stewStack));
            out.method_10569("emeraldCost", 1);
            out.method_10569("villagerXp", accessor.xp());
            out.method_10569("maxUses", 12);
        }, (profession, professionLevel, in) -> {
            class_1799 stew = EivTagUtil.decodeItemStackOnClient(in.method_68568("stew"));
            int emeraldCost = in.method_68083("emeraldCost", 0);
            int villagerXp = in.method_68083("villagerXp", 0);
            int maxUses = in.method_68083("maxUses", 0);
            class_5321 villagerType = !in.method_10545("requiredType") ? null : ((class_6880.class_6883)class_7923.field_41194.method_10223(class_2960.method_60654((String)((String)in.method_10558("requiredType").orElseThrow()))).orElseThrow()).method_40237();
            return List.of(new VillagerOffer((class_5321<class_3852>)profession, professionLevel, (class_5321<class_3854>)villagerType, List.of(stew), List.of(new class_1799((class_1935)class_1802.field_8687, emeraldCost)), List.of(), villagerXp, maxUses));
        });
        public static final VillagerOfferType<class_3853.class_1648> ENCHANT_BOOK = VillagerOfferType.register(class_2960.method_60656((String)"enchant_book"), class_3853.class_1648.class, (listing, out) -> {
            EnchantBookForEmeraldsAccessor accessor = (EnchantBookForEmeraldsAccessor)listing;
            HashMap<class_5321, List> offers = new HashMap<class_5321, List>();
            HashMap costs = new HashMap();
            class_2378 enchantmentRegistry = ServerRecipeManager.INSTANCE.getServer().method_30611().method_30530(class_7924.field_41265);
            enchantmentRegistry.method_46733(accessor.tradeableEnchantments()).ifPresent(holders -> holders.method_40239().forEach(enchantment -> {
                ArrayList<class_1799> offerStacks = new ArrayList<class_1799>();
                ArrayList<class_1799> costStacks = new ArrayList<class_1799>();
                for (int i = Math.max(accessor.minLevel(), ((class_1887)enchantment.comp_349()).method_8187()); i <= accessor.maxLevel() && i <= ((class_1887)enchantment.comp_349()).method_8183(); ++i) {
                    class_1799 enchantedBook = class_1890.method_61711((class_1889)new class_1889(enchantment, i));
                    offerStacks.add(enchantedBook);
                    int emeraldCostsMin = 2 + 3 * i;
                    int emeraldCostsMax = 5 + i * 10 - 1 + 3 * i;
                    if (enchantment.method_40220(class_9636.field_51546)) {
                        emeraldCostsMin *= 2;
                        emeraldCostsMax *= 2;
                    }
                    if (emeraldCostsMin > 64) {
                        emeraldCostsMin = 64;
                    }
                    if (emeraldCostsMax > 64) {
                        emeraldCostsMax = 64;
                    }
                    class_1799 costStack = new class_1799((class_1935)class_1802.field_8687, emeraldCostsMin + (emeraldCostsMax - emeraldCostsMin) / 2);
                    class_9290 lore = (class_9290)costStack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340);
                    lore = lore.method_57499((class_2561)class_2561.method_43470((String)(emeraldCostsMin + " - " + emeraldCostsMax)).method_27692(class_124.field_1080));
                    costStack.method_57379(class_9334.field_49632, (Object)lore);
                    costStacks.add(costStack);
                }
                offers.put((class_5321)enchantment.method_40230().get(), offerStacks);
                costs.put((class_5321)enchantment.method_40230().get(), costStacks);
            }));
            class_2487 offersTag = new class_2487();
            offers.forEach((enchantment, stacks) -> {
                List costStacks = (List)costs.get(enchantment);
                class_2487 offerTag = new class_2487();
                offerTag.method_10566("offerStacks", (class_2520)EivTagUtil.writeList(stacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
                offerTag.method_10566("costStacks", (class_2520)EivTagUtil.writeList(costStacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
                offersTag.method_10566(enchantment.method_29177().method_36181(), (class_2520)offerTag);
            });
            out.method_10566("offers", (class_2520)offersTag);
            out.method_10569("villagerXp", accessor.villagerXp());
            out.method_10569("maxUses", 12);
        }, (profession, professionLevel, in) -> {
            class_5321 villagerType = !in.method_10545("requiredType") ? null : ((class_6880.class_6883)class_7923.field_41194.method_10223(class_2960.method_60654((String)((String)in.method_10558("requiredType").orElseThrow()))).orElseThrow()).method_40237();
            ArrayList villagerOffers = new ArrayList();
            int villagerXp = in.method_68083("villagerXp", 0);
            int maxUses = in.method_68083("maxUses", 0);
            class_2487 offersTag = in.method_68568("offers");
            offersTag.method_68567().stream().map(tag -> tag.method_68571().orElseGet(class_2487::new)).forEach(offerTag -> {
                List<class_1799> offerStacks = EivTagUtil.readList(offerTag, "offerStacks", EivTagUtil::decodeItemStackOnClient);
                List<class_1799> costStacks = EivTagUtil.readList(offerTag, "costStacks", EivTagUtil::decodeItemStackOnClient);
                VillagerOffer offer = new VillagerOffer((class_5321<class_3852>)profession, professionLevel, (class_5321<class_3854>)villagerType, offerStacks, costStacks, List.of(new class_1799((class_1935)class_1802.field_8529)), villagerXp, maxUses);
                villagerOffers.add(offer);
            });
            return villagerOffers;
        });
        public static final VillagerOfferType<class_3853.class_1654> TREASURE_MAP = VillagerOfferType.register(class_2960.method_60656((String)"treasure_map"), class_3853.class_1654.class, (listing, out) -> {
            TreasureMapForEmeraldsAccessor accessor = (TreasureMapForEmeraldsAccessor)listing;
            out.method_10582("decoration", ((class_5321)accessor.destinationType().method_40230().orElseThrow()).method_29177().toString());
            out.method_10582("displayName", accessor.displayName());
            out.method_10569("emeraldCost", accessor.emeraldCost());
            out.method_10569("villagerXp", accessor.villagerXp());
            out.method_10569("maxUses", accessor.maxUses());
        }, (profession, professionLevel, in) -> {
            class_9428 decorationType = (class_9428)class_7923.field_50078.method_17966(class_2960.method_60654((String)((String)in.method_10558("decoration").orElseThrow()))).orElseThrow();
            String displayName = in.method_68564("displayName", "");
            int emeraldCost = in.method_68083("emeraldCost", 0);
            int villagerXp = in.method_68083("villagerXp", 0);
            int maxUses = in.method_68083("maxUses", 0);
            class_1799 offerStack = new class_1799((class_1935)class_1802.field_8204);
            offerStack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)displayName));
            if (decorationType.method_58452()) {
                offerStack.method_57379(class_9334.field_49645, (Object)new class_9294(decorationType.comp_2516()));
            }
            class_1799 costStack1 = new class_1799((class_1935)class_1802.field_8687, emeraldCost);
            class_1799 costStack2 = new class_1799((class_1935)class_1802.field_8251);
            class_5321 villagerType = !in.method_10545("requiredType") ? null : ((class_6880.class_6883)class_7923.field_41194.method_10223(class_2960.method_60654((String)((String)in.method_10558("requiredType").orElseThrow()))).orElseThrow()).method_40237();
            return List.of(new VillagerOffer((class_5321<class_3852>)profession, professionLevel, (class_5321<class_3854>)villagerType, List.of(offerStack), List.of(costStack1), List.of(costStack2), villagerXp, maxUses));
        });
        public static final VillagerOfferType<class_3853.class_4167> TIPPED_ARROW = VillagerOfferType.register(class_2960.method_60656((String)"tipped_arrow"), class_3853.class_4167.class, (listing, out) -> {
            TippedArrowForItemsAndEmeraldsAccessor accessor = (TippedArrowForItemsAndEmeraldsAccessor)listing;
            ArrayList offerStacks = new ArrayList();
            List<class_6880> potions = class_7923.field_41179.method_42017().filter(potionReference -> !((class_1842)potionReference.comp_349()).method_8049().isEmpty() && ServerRecipeManager.INSTANCE.getServer().method_59777().method_20361((class_6880)potionReference)).collect(Collectors.toList());
            potions.forEach(holder -> {
                class_1799 offerStack = new class_1799((class_1935)accessor.toItem().method_7909(), accessor.toCount());
                offerStack.method_57379(class_9334.field_49651, (Object)new class_1844(holder));
                offerStacks.add(offerStack);
            });
            out.method_10566("offers", (class_2520)EivTagUtil.writeList(offerStacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
            out.method_10582("fromItem", EivTagUtil.itemToString(accessor.fromItem()));
            out.method_10569("fromCount", accessor.fromCount());
            out.method_10569("emeraldCost", accessor.emeraldCost());
            out.method_10569("villagerXp", accessor.villagerXp());
            out.method_10569("maxUses", accessor.maxUses());
        }, (profession, professionLevel, in) -> {
            List<class_1799> offers = EivTagUtil.readList(in, "offers", EivTagUtil::decodeItemStackOnClient);
            class_1792 fromItem = EivTagUtil.itemFromString(in.method_68564("fromItem", ""));
            int fromCount = in.method_68083("fromCount", 0);
            int emeraldCost = in.method_68083("emeraldCost", 0);
            int villagerXp = in.method_68083("villagerXp", 0);
            int maxUses = in.method_68083("maxUses", 0);
            class_5321 villagerType = !in.method_10545("requiredType") ? null : ((class_6880.class_6883)class_7923.field_41194.method_10223(class_2960.method_60654((String)((String)in.method_10558("requiredType").orElseThrow()))).orElseThrow()).method_40237();
            return List.of(new VillagerOffer((class_5321<class_3852>)profession, professionLevel, (class_5321<class_3854>)villagerType, offers, List.of(new class_1799((class_1935)class_1802.field_8687, emeraldCost)), List.of(new class_1799((class_1935)fromItem, fromCount)), villagerXp, maxUses));
        });
        public static final VillagerOfferType<class_3853.class_4163> ENCHANTED_ITEM_FOR_EMERALDS = VillagerOfferType.register(class_2960.method_60656((String)"enchanted_item_for_emeralds"), class_3853.class_4163.class, (listing, out) -> {
            EnchantedItemForEmeraldsAccessor accessor = (EnchantedItemForEmeraldsAccessor)listing;
            ArrayList offerStacks = new ArrayList();
            int bonusCostMin = 0;
            int bonusCostMax = 19;
            int totalCostsMin = Math.min(accessor.baseEmeraldCost() + bonusCostMin, 64);
            int totalCostsMax = Math.min(accessor.baseEmeraldCost() + bonusCostMax, 64);
            class_5455.class_6890 registryAccess = ServerRecipeManager.INSTANCE.getServer().method_30611();
            Optional optional = registryAccess.method_30530(class_7924.field_41265).method_46733(class_9636.field_51549);
            class_9889 enchantable = (class_9889)accessor.itemStack().method_58694(class_9334.field_53695);
            if (optional.isEmpty()) {
                return;
            }
            if (enchantable == null) {
                return;
            }
            float f = 0.15f;
            float f1 = -0.15f;
            ++bonusCostMin;
            bonusCostMin = class_3532.method_15340((int)Math.round((float)bonusCostMin + (float)bonusCostMin * f1), (int)1, (int)Integer.MAX_VALUE);
            bonusCostMax += 1 + enchantable.comp_2938() / 4 + enchantable.comp_2938() / 4;
            bonusCostMax = class_3532.method_15340((int)Math.round((float)bonusCostMax + (float)bonusCostMax * f), (int)1, (int)Integer.MAX_VALUE);
            for (int i = bonusCostMin; i <= bonusCostMax; ++i) {
                List list = class_1890.method_8229((int)i, (class_1799)accessor.itemStack(), (Stream)((class_6885.class_6888)optional.get()).method_40239());
                list.forEach(enchantmentInstance -> {
                    class_1799 stack = accessor.itemStack().method_7972();
                    stack.method_7978(enchantmentInstance.comp_3486(), enchantmentInstance.comp_3487());
                    if (offerStacks.stream().noneMatch(stack1 -> stack1.method_58657().equals((Object)stack.method_58657()))) {
                        offerStacks.add(stack);
                    }
                });
            }
            class_1799 costStack = new class_1799((class_1935)class_1802.field_8687, totalCostsMin + (totalCostsMax - totalCostsMin) / 2);
            class_9290 lore = (class_9290)costStack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340);
            lore.method_57499((class_2561)class_2561.method_43470((String)(totalCostsMin + " - " + totalCostsMax)).method_27692(class_124.field_1080));
            costStack.method_57379(class_9334.field_49632, (Object)lore);
            out.method_10566("offers", (class_2520)EivTagUtil.writeList(offerStacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
            out.method_10566("costStack", (class_2520)EivTagUtil.encodeItemStackOnServer(costStack));
            out.method_10569("villagerXp", accessor.villagerXp());
            out.method_10569("maxUses", accessor.maxUses());
        }, (profession, professionLevel, in) -> {
            List<class_1799> offerStacks = EivTagUtil.readList(in, "offers", EivTagUtil::decodeItemStackOnClient);
            class_1799 costStack = EivTagUtil.decodeItemStackOnClient(in.method_68568("costStack"));
            int villagerXp = in.method_68083("villagerXp", 0);
            int maxUses = in.method_68083("maxUses", 0);
            class_5321 villagerType = !in.method_10545("requiredType") ? null : ((class_6880.class_6883)class_7923.field_41194.method_10223(class_2960.method_60654((String)((String)in.method_10558("requiredType").orElseThrow()))).orElseThrow()).method_40237();
            return List.of(new VillagerOffer((class_5321<class_3852>)profession, professionLevel, (class_5321<class_3854>)villagerType, offerStacks, List.of(costStack), List.of(), villagerXp, maxUses));
        });
        public static final VillagerOfferType<class_3853.class_4160> DYED_ARMOR = VillagerOfferType.register(class_2960.method_60656((String)"dyed_armor"), class_3853.class_4160.class, (listing, out) -> {
            DyedArmorForEmeraldsAccessor accessor = (DyedArmorForEmeraldsAccessor)listing;
            class_1799 offerStack = new class_1799((class_1935)accessor.getItem());
            out.method_10566("offerStack", (class_2520)EivTagUtil.encodeItemStackOnServer(offerStack));
            out.method_10569("emeraldCost", accessor.getValue());
            out.method_10569("villagerXp", accessor.getVillagerXp());
            out.method_10569("maxUses", accessor.getMaxUses());
        }, (profession, professionLevel, in) -> {
            class_1799 offerStack = EivTagUtil.decodeItemStackOnClient(in.method_68568("offerStack"));
            int emeraldCost = in.method_68083("emeraldCost", 0);
            int villagerXp = in.method_68083("villagerXp", 0);
            int maxUses = in.method_68083("maxUses", 0);
            ArrayList<class_1799> offerStacks = new ArrayList<class_1799>();
            if (offerStack.method_31573(class_3489.field_48803)) {
                for (class_1767 color1 : class_1767.values()) {
                    offerStacks.add(class_9282.method_57471((class_1799)offerStack.method_7972(), List.of(class_1769.method_7803((class_1767)color1))));
                }
            } else {
                offerStacks.add(offerStack);
            }
            class_5321 villagerType = !in.method_10545("requiredType") ? null : ((class_6880.class_6883)class_7923.field_41194.method_10223(class_2960.method_60654((String)((String)in.method_10558("requiredType").orElseThrow()))).orElseThrow()).method_40237();
            return List.of(new VillagerOffer((class_5321<class_3852>)profession, professionLevel, (class_5321<class_3854>)villagerType, offerStacks, List.of(new class_1799((class_1935)class_1802.field_8687, emeraldCost)), List.of(), villagerXp, maxUses));
        });
        public static final VillagerOfferType<class_3853.class_4164> ITEMS_AND_EMERALDS_TO_ITEMS = VillagerOfferType.register(class_2960.method_60656((String)"items_and_emeralds_to_items"), class_3853.class_4164.class, (listing, out) -> {
            ItemsAndEmeraldsToItemsAccessor accessor = (ItemsAndEmeraldsToItemsAccessor)listing;
            class_1799 costStack = accessor.fromItem().comp_2427().method_7972();
            ArrayList<class_1799> offerStacks = new ArrayList<class_1799>();
            if (accessor.enchantmentProvider().isPresent()) {
                class_9741 provider = (class_9741)((class_6880.class_6883)ServerRecipeManager.INSTANCE.getServer().method_30611().method_30530(class_7924.field_51839).method_46746(accessor.enchantmentProvider().get()).orElseThrow()).comp_349();
                offerStacks.addAll(VillagerServerRecipe.createOfferStacksFromEnchantmentProvider(provider, accessor.toItem()));
            } else {
                offerStacks.add(accessor.toItem().method_7972());
            }
            out.method_10566("offerStacks", (class_2520)EivTagUtil.writeList(offerStacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
            out.method_10566("costStack", (class_2520)EivTagUtil.encodeItemStackOnServer(costStack));
            out.method_10569("emeraldCost", accessor.emeraldCost());
            out.method_10569("villagerXp", accessor.getVillagerXp());
            out.method_10569("maxUses", accessor.getMaxUses());
        }, (profession, professionLevel, in) -> {
            List<class_1799> offerStacks = EivTagUtil.readList(in, "offerStacks", EivTagUtil::decodeItemStackOnClient);
            class_1799 costStack = EivTagUtil.decodeItemStackOnClient(in.method_68568("costStack"));
            int emeraldCost = in.method_68083("emeraldCost", 0);
            int villagerXp = in.method_68083("villagerXp", 0);
            int maxUses = in.method_68083("maxUses", 0);
            class_5321 villagerType = !in.method_10545("requiredType") ? null : ((class_6880.class_6883)class_7923.field_41194.method_10223(class_2960.method_60654((String)((String)in.method_10558("requiredType").orElseThrow()))).orElseThrow()).method_40237();
            return List.of(new VillagerOffer((class_5321<class_3852>)profession, professionLevel, (class_5321<class_3854>)villagerType, offerStacks, List.of(new class_1799((class_1935)class_1802.field_8687, emeraldCost)), List.of(costStack), villagerXp, maxUses));
        });
        public static final VillagerOfferType<class_3853.class_4162> EMERALDS_FOR_VILLAGER_TYPE = VillagerOfferType.register(class_2960.method_60656((String)"emeralds_for_villager_type"), class_3853.class_4162.class, (listing, out) -> {
            EmeraldsForVillagerTypeItemAccessor accessor = (EmeraldsForVillagerTypeItemAccessor)listing;
            out.method_10569("cost", accessor.getCost());
            out.method_10569("villagerXp", accessor.getVillagerXp());
            out.method_10569("maxUses", accessor.getMaxUses());
            class_2487 tradesTag = new class_2487();
            accessor.getTrades().forEach((villagerType, item) -> tradesTag.method_10582(villagerType.method_29177().toString(), EivTagUtil.itemToString(item)));
            out.method_10566("trades", (class_2520)tradesTag);
        }, (profession, professionLevel, in) -> {
            int cost = in.method_68083("cost", 0);
            int villagerXp = in.method_68083("villagerXp", 0);
            int maxUses = in.method_68083("maxUses", 0);
            HashMap<class_5321, class_1792> trades = new HashMap<class_5321, class_1792>();
            class_2487 tradesTag = in.method_68568("trades");
            tradesTag.method_68561((s, tag) -> {
                class_5321 villagerType = ((class_6880.class_6883)class_7923.field_41194.method_10223(class_2960.method_60654((String)s)).orElseThrow()).method_40237();
                class_1792 item = EivTagUtil.itemFromString((String)tag.method_68658().orElseThrow());
                trades.put(villagerType, item);
            });
            ArrayList villagerOffers = new ArrayList();
            trades.forEach((villagerTypeResourceKey, item) -> villagerOffers.add(new VillagerOffer((class_5321<class_3852>)profession, professionLevel, (class_5321<class_3854>)villagerTypeResourceKey, List.of(new class_1799((class_1935)class_1802.field_8687)), List.of(new class_1799((class_1935)item, cost)), List.of(), villagerXp, maxUses)));
            return villagerOffers;
        });
        public static final VillagerOfferType<class_3853.class_8640> TYPE_SPECIFIC = VillagerOfferType.register(class_2960.method_60656((String)"type_specific"), class_3853.class_8640.class, (listing, out) -> listing.comp_1962().forEach((villagerType, itemListing) -> {
            VillagerOfferType offerType = VillagerOfferType.byClass(itemListing.getClass());
            if (offerType == null) {
                return;
            }
            class_2487 encodedListing = new class_2487();
            offerType.encoder().encode(VillagerServerRecipe.castListing(itemListing), encodedListing);
            encodedListing.method_10582("requiredType", villagerType.method_29177().toString());
            encodedListing.method_10582("listingType", offerType.id().toString());
            out.method_10566(villagerType.method_29177().toString(), (class_2520)encodedListing);
        }), (profession, professionLevel, in) -> {
            ArrayList villagerOffers = new ArrayList();
            in.method_68561((villagerType, tag) -> {
                class_2487 listingTag = (class_2487)tag.method_68571().orElseThrow();
                class_2960 listingId = class_2960.method_60654((String)((String)listingTag.method_10558("listingType").orElseThrow()));
                VillagerOfferType offerType = VillagerOfferType.byId(listingId);
                villagerOffers.addAll(offerType.decoder().decode((class_5321<class_3852>)profession, professionLevel, listingTag));
            });
            return villagerOffers;
        });

        public static <T extends class_3853.class_1652> VillagerOfferType<T> register(class_2960 id, Class<T> clazz, Encoder<T> encoder, Decoder decoder) {
            VillagerOfferType<T> type = new VillagerOfferType<T>(id, encoder, decoder);
            TYPES.put(id, type);
            ID_BY_CLASS.put(clazz, id);
            return type;
        }

        public static <T extends class_3853.class_1652> VillagerOfferType<T> byId(class_2960 id) {
            return TYPES.get(id);
        }

        public static <T extends class_3853.class_1652> VillagerOfferType<T> byClass(Class<T> clazz) {
            if (ID_BY_CLASS.containsKey(clazz)) {
                return VillagerOfferType.byId(ID_BY_CLASS.get(clazz));
            }
            return null;
        }

        public static interface Encoder<T extends class_3853.class_1652> {
            public void encode(T var1, class_2487 var2);
        }

        public static interface Decoder {
            public List<VillagerOffer> decode(class_5321<class_3852> var1, int var2, class_2487 var3);
        }
    }

    public record VillagerOffer(class_5321<class_3852> profession, int professionLevel, @Nullable class_5321<class_3854> requiredtype, List<class_1799> offerStacks, List<class_1799> cost1, List<class_1799> cost2, int villagerXp, int maxUses) {
    }
}

