/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.overlay.itemlist.view;

import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.config.Configs;
import de.crafty.eiv.common.gui.EivClientSettingsScreen;
import de.crafty.eiv.common.overlay.AbstractEivOverlay;
import de.crafty.eiv.common.overlay.ItemSlot;
import de.crafty.eiv.common.overlay.OverlayManager;
import de.crafty.eiv.common.overlay.itemlist.AbstractEivItemListOverlay;
import de.crafty.eiv.common.overlay.itemlist.bookmark.ItemBookmarkOverlay;
import de.crafty.eiv.common.overlay.itemlist.view.ItemFilters;
import de.crafty.eiv.common.recipe.ClientRecipeCache;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;
import net.minecraft.class_8662;

public class ItemViewOverlay
extends AbstractEivItemListOverlay {
    public static final ItemViewOverlay INSTANCE = new ItemViewOverlay();
    private static final class_2960 SETTINGS_WHEEL = class_2960.method_60655((String)"eiv", (String)"settings_wheel");
    private class_342 searchbar = null;
    private static final int HEADER_HEIGHT = 20;
    private static final int FOOTER_HEIGHT = 40;
    private long lastSearchbarClick = -1L;
    private String currentQuery = "";
    private boolean itemFilterMode = false;

    public ItemViewOverlay() {
        super(-1, -1, -1, -1);
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean prev = this.isEnabled();
        super.setEnabled(enabled);
        if (prev != enabled && enabled) {
            this.searchbar.field_22764 = true;
        }
        if (prev != enabled && !enabled) {
            this.searchbar.field_22764 = false;
        }
    }

    @Override
    public void onScreenChanged(AbstractEivOverlay.InventoryPositionInfo info) {
        this.initForScreen(info.screen(), info);
        super.onScreenChanged(info);
        this.updateQuery(this.getCurrentQuery());
        this.createSearchbarElement(OverlayManager.INSTANCE.currentInfo());
    }

    @Override
    protected void placeWidgets(AbstractEivOverlay.ScreenContext ctx) {
        ctx.addRenderable(this.searchbar);
        AbstractEivOverlay.InventoryPositionInfo info = OverlayManager.INSTANCE.currentInfo();
        class_8662 btn = class_8662.method_52723((class_2561)class_2561.method_43471((String)"eiv.client_settings.btn"), button -> class_310.method_1551().method_1507((class_437)new EivClientSettingsScreen((class_437)info.screen())), (boolean)true).method_52726(18, 18).method_52727(SETTINGS_WHEEL, 14, 14).method_52724();
        btn.method_48229(0, info.screenHeight() - 18);
        ctx.addRenderable(btn);
    }

    private void initForScreen(class_465<? extends class_1703> screen, AbstractEivOverlay.InventoryPositionInfo invInfo) {
        this.width = invInfo.screenWidth() - ((invInfo.screenWidth() - 176) / 2 + 176) - 14;
        this.width -= (this.width - 4) % 20;
        this.height = screen.field_22790;
        this.x = invInfo.screenWidth() - this.width;
        this.y = 0;
        this.itemStartX = this.x + 2;
        this.itemStartY = 20;
        this.itemEndX = this.x + this.width - 2;
        this.itemEndY = this.y + this.height - 40;
    }

    private void updateQuery(String newQuery) {
        if (!newQuery.equals(this.currentQuery)) {
            this.startIndex = 0;
        }
        this.currentQuery = newQuery;
        this.availableItems = newQuery.startsWith("@") ? ItemFilters.modId(newQuery.substring(1)) : (newQuery.startsWith("#") ? ItemFilters.tag(newQuery.substring(1)) : ItemFilters.defaultFilter(newQuery));
        this.availableItems().removeIf(stack -> ItemView.getExcluded().contains(stack.method_7909()));
        this.updateSlots();
    }

    @Override
    protected boolean keyPressed(int i, int j, int k) {
        super.keyPressed(i, j, k);
        for (ItemSlot slot : this.itemSlots()) {
            if (!slot.isHovered() || !CommonEIVClient.ADD_BOOKMARK_KEYBIND.method_1417(i, j)) continue;
            ItemBookmarkOverlay.INSTANCE.bookmarkItem(slot.getStack());
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.searchbar.method_49606() && mouseButton == 1) {
            this.searchbar.method_1852("");
            OverlayManager.INSTANCE.currentInfo().screen().method_25395((class_364)this.searchbar);
        }
        if (mouseButton == 0 && !this.searchbar.method_49606() && this.searchbar.method_25370()) {
            this.searchbar.method_25365(false);
        }
        if (this.searchbar.method_49606() && mouseButton == 0) {
            if (this.lastSearchbarClick != -1L && System.currentTimeMillis() - this.lastSearchbarClick <= 400L) {
                this.itemFilterMode = !this.itemFilterMode;
                this.lastSearchbarClick = -1L;
            } else {
                this.lastSearchbarClick = System.currentTimeMillis();
            }
        }
        return false;
    }

    @Override
    protected void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.fittingPerPage() == 0) {
            return;
        }
        if (Configs.CLIENT_SETTINGS.isItemWrapMode()) {
            guiGraphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, new Color(0, 0, 0, 64).getRGB());
        } else {
            guiGraphics.method_25294(this.effectiveX, this.effectiveY, this.effectiveX + this.effectiveWidth, this.effectiveY + this.effectiveHeight, new Color(0, 0, 0, 64).getRGB());
        }
    }

    @Override
    protected void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        class_310 client = class_310.method_1551();
        class_327 font = client.field_1772;
        if (Configs.CLIENT_SETTINGS.isItemWrapMode()) {
            this.drawScaledString(font, guiGraphics, (class_2561)class_2561.method_43470((String)"ItemView"), this.x + this.width / 2, this.y + 6, -1);
        } else {
            this.drawScaledString(font, guiGraphics, (class_2561)class_2561.method_43470((String)"ItemView"), this.effectiveX + this.effectiveWidth / 2, this.effectiveY + 6, -1);
        }
        if (this.fittingPerPage() > 0) {
            if (Configs.CLIENT_SETTINGS.isItemWrapMode()) {
                guiGraphics.method_25300(font, this.getPage() + 1 + "/" + (this.getMaxPageIndex() + 1), this.x + this.width - this.width / 2, this.y + this.height - 2 - 20 - 10, -1);
            } else {
                guiGraphics.method_25300(font, this.getPage() + 1 + "/" + (this.getMaxPageIndex() + 1), this.effectiveX + this.effectiveWidth / 2, this.effectiveY + this.effectiveHeight - 2 - 20 - 10, -1);
            }
        }
        for (ItemSlot slot : this.itemSlots()) {
            slot.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.renderItemHighlighting(OverlayManager.INSTANCE.currentInfo().screen(), guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderItemHighlighting(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.itemFilterMode) {
            return;
        }
        screen.method_17577().field_7761.forEach(slot -> {
            if (!slot.method_7682() || !slot.method_51306()) {
                return;
            }
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)(OverlayManager.INSTANCE.currentInfo().leftPos() - 1), (float)(OverlayManager.INSTANCE.currentInfo().topPos() - 1));
            if (!slot.method_7681() || this.availableItems.stream().noneMatch(stack -> stack.method_7909() == slot.method_7677().method_7909())) {
                guiGraphics.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 18, slot.field_7872 + 18, new Color(0, 0, 0, 128).getRGB());
            }
            guiGraphics.method_51448().popMatrix();
        });
    }

    public void createSearchbarElement(AbstractEivOverlay.InventoryPositionInfo info) {
        class_342 box;
        class_364 class_3642;
        boolean wrapMode = Configs.CLIENT_SETTINGS.isItemWrapMode();
        int boxWidth = Math.min(100, (wrapMode ? this.width : this.effectiveWidth) - 4);
        int x = wrapMode ? this.x + this.width / 2 - boxWidth / 2 : this.effectiveX + this.effectiveWidth / 2 - boxWidth / 2;
        int y = info.screenHeight() - 22;
        if (this.searchbar != null && (class_3642 = info.screen().method_25399()) instanceof class_342 && (box = (class_342)class_3642).method_25369().equals((Object)class_2561.method_43470((String)"eiv:searchbar"))) {
            this.searchbar.method_25365(false);
        }
        if (this.searchbar != null && boxWidth == this.searchbar.method_25368() && x == this.searchbar.method_46426() && y == this.searchbar.method_46427()) {
            return;
        }
        class_342 newSearchbar = new class_342(class_310.method_1551().field_1772, x, y, boxWidth, 20, (class_2561)class_2561.method_43470((String)"eiv:searchbar"));
        newSearchbar.method_1880(32);
        newSearchbar.method_1852(this.getCurrentQuery());
        newSearchbar.method_1863(this::updateQuery);
        newSearchbar.field_22764 = this.isEnabled();
        this.searchbar = newSearchbar;
    }

    public void openRecipeView(class_1799 stack, ItemViewOpenType openType) {
        if (stack.method_7960()) {
            return;
        }
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            return;
        }
        List<IEivViewRecipe> foundRecipes = openType.recipeProvider().retrieveRecipes(stack);
        if (!foundRecipes.isEmpty()) {
            class_437 parent = class_310.method_1551().field_1755;
            ArrayList<RecipeViewScreen> viewHistory = new ArrayList();
            if (parent instanceof RecipeViewScreen) {
                RecipeViewScreen viewScreen = (RecipeViewScreen)parent;
                parent = ((RecipeViewMenu)viewScreen.method_17577()).getParentScreen();
                viewHistory = ((RecipeViewMenu)viewScreen.method_17577()).getViewHistory();
            }
            class_310.method_1551().method_1507((class_437)new RecipeViewScreen(new RecipeViewMenu(parent, 0, clientPlayer.method_31548(), foundRecipes, stack, openType == ItemViewOpenType.RESULT ? SlotContent.Type.RESULT : SlotContent.Type.INGREDIENT, viewHistory), clientPlayer.method_31548(), (class_2561)class_2561.method_43473()));
        }
    }

    public class_342 getSearchbar() {
        return this.searchbar;
    }

    public boolean isItemFilterMode() {
        return this.itemFilterMode;
    }

    public String getCurrentQuery() {
        return this.currentQuery;
    }

    public static enum ItemViewOpenType {
        INPUT(ClientRecipeCache.INSTANCE::getRecipesForCraftingInput),
        RESULT(ClientRecipeCache.INSTANCE::getRecipesForCraftingOutput);

        final RecipeProvider recipeProvider;

        private ItemViewOpenType(RecipeProvider recipeProvider) {
            this.recipeProvider = recipeProvider;
        }

        RecipeProvider recipeProvider() {
            return this.recipeProvider;
        }

        static interface RecipeProvider {
            public List<IEivViewRecipe> retrieveRecipes(class_1799 var1);
        }
    }
}

