/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe.inventory;

import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.BuiltInEivIntegration;
import de.crafty.eiv.common.recipe.inventory.RecipeTransferData;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.recipe.inventory.ViewContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class RecipeViewMenu
extends class_1703 {
    protected static final int MAX_POSSIBLE_HEIGHT = 224;
    protected static final int BUFFER_ZONE = 16;
    protected static final int TOP_SPACE = 24;
    protected static final int BOTTOM_SPACE = 24;
    private final class_1657 player;
    private ViewContainer viewContainer;
    private List<? extends IEivViewRecipe> recipes;
    private IEivRecipeViewType viewType;
    private int maxPossiblePerPage;
    private int maxPageIndex;
    private int currentPage;
    private final List<IEivViewRecipe> currentDisplay;
    private final LinkedHashMap<IEivRecipeViewType, List<IEivViewRecipe>> sortedByType;
    private final List<IEivRecipeViewType> viewTypeOrder;
    private int currentTypeIndex;
    private int menuWidth;
    private int menuHeight;
    private final class_1799 origin;
    private final SlotContent.Type originType;
    private final HashMap<Integer, AdditionalStackModifier> additionalStackModifiers;
    private final HashMap<Integer, OptionalSlotRenderer> optionalSlotRenderers;
    private RecipeViewScreen viewScreen;
    private final class_437 parentScreen;
    private final ArrayList<RecipeViewScreen> viewHistory;
    private int currentCraftReference;
    private final List<RecipeTransferData> transferData;

    public RecipeViewMenu(class_437 parentScreen, int containerId, class_1661 inventory, List<? extends IEivViewRecipe> recipes, class_1799 origin, SlotContent.Type originType, ArrayList<RecipeViewScreen> viewHistory) {
        super(CommonEIVClient.RECIPE_VIEW_MENU, containerId);
        this.viewHistory = viewHistory;
        this.parentScreen = parentScreen;
        this.transferData = new ArrayList<RecipeTransferData>();
        this.currentCraftReference = 0;
        this.origin = origin;
        this.originType = originType;
        this.additionalStackModifiers = new HashMap();
        this.optionalSlotRenderers = new HashMap();
        this.sortedByType = new LinkedHashMap();
        HashMap<IEivRecipeViewType, HashMap> prioOrder = new HashMap<IEivRecipeViewType, HashMap>();
        recipes.forEach(iEivRecipe -> {
            List list = prioOrder.getOrDefault(iEivRecipe.getViewType(), new HashMap()).getOrDefault(iEivRecipe.getPriority(), new ArrayList());
            list.add(iEivRecipe);
            HashMap<Integer, List> map = prioOrder.getOrDefault(iEivRecipe.getViewType(), new HashMap());
            map.put(iEivRecipe.getPriority(), list);
            prioOrder.put(iEivRecipe.getViewType(), map);
        });
        prioOrder.forEach((viewType, map) -> {
            ArrayList list = new ArrayList();
            map.values().forEach(list::addAll);
            this.sortedByType.put((IEivRecipeViewType)viewType, list);
        });
        this.viewTypeOrder = new ArrayList<IEivRecipeViewType>();
        List unsortedTypes = this.sortedByType.keySet().stream().toList();
        HashMap byId = new HashMap();
        unsortedTypes.forEach(viewType -> byId.put(viewType.getId().toString(), viewType));
        ArrayList ids = new ArrayList(byId.keySet());
        ids.sort(String::compareTo);
        ids.forEach(id -> this.viewTypeOrder.add((IEivRecipeViewType)byId.get(id)));
        this.currentTypeIndex = 0;
        this.currentPage = 0;
        this.currentDisplay = new ArrayList<IEivViewRecipe>();
        if (recipes.isEmpty()) {
            CommonEIV.LOGGER.error("Attempting to open Menu with 0 recipes");
        }
        this.player = inventory.field_7546;
        this.updateByViewType();
        if (!this.sortedByType.isEmpty()) {
            return;
        }
        this.viewContainer = new ViewContainer(0);
        this.viewType = IEivRecipeViewType.NONE;
    }

    public RecipeViewMenu(int containerId, class_1661 inventory) {
        this(null, containerId, inventory, IEivViewRecipe.PLACEHOLDER, class_1799.field_8037, SlotContent.Type.ANY, new ArrayList<RecipeViewScreen>());
    }

    public int getCurrentCraftReference() {
        return this.currentCraftReference;
    }

    public class_437 getParentScreen() {
        return this.parentScreen;
    }

    public ArrayList<RecipeViewScreen> getViewHistory() {
        return this.viewHistory;
    }

    public boolean goBack() {
        if (this.viewScreen != null && this.viewHistory.indexOf((Object)this.viewScreen) > 0) {
            class_310.method_1551().method_1507((class_437)this.viewHistory.get(this.viewHistory.indexOf((Object)this.viewScreen) - 1));
            return true;
        }
        return false;
    }

    public boolean goForward() {
        if (this.viewScreen != null && this.viewHistory.size() - 1 > this.viewHistory.indexOf((Object)this.viewScreen)) {
            class_310.method_1551().method_1507((class_437)this.viewHistory.get(this.viewHistory.indexOf((Object)this.viewScreen) + 1));
            return true;
        }
        return false;
    }

    public void setViewScreen(RecipeViewScreen viewScreen) {
        this.viewScreen = viewScreen;
        this.viewHistory.add(viewScreen);
    }

    public class_1799 getOrigin() {
        return this.origin;
    }

    public AdditionalStackModifier getAdditionalStackModifier(int slot) {
        return this.additionalStackModifiers.getOrDefault(slot, AdditionalStackModifier.NONE);
    }

    public boolean isOptionalSlot(int slot) {
        return this.optionalSlotRenderers.containsKey(slot);
    }

    public OptionalSlotRenderer getOptionalSlotRenderer(int slot) {
        return this.optionalSlotRenderers.getOrDefault(slot, OptionalSlotRenderer.DEFAULT);
    }

    @NotNull
    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return this.viewContainer.method_5443(player);
    }

    public int getMaxPossiblePerPage() {
        return this.maxPossiblePerPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getMaxPageIndex() {
        return this.maxPageIndex;
    }

    public void nextReference() {
        this.currentCraftReference = Math.min(this.currentCraftReference + 1, this.viewType.getCraftReferences().size() - this.getDisplayableCraftReferences());
        this.updateReferences();
    }

    public void prevReference() {
        this.currentCraftReference = Math.max(this.currentCraftReference - 1, 0);
        this.updateReferences();
    }

    public void nextPage() {
        this.currentPage = Math.min(this.currentPage + 1, this.maxPageIndex);
        this.updateByPage();
    }

    public void prevPage() {
        this.currentPage = Math.max(this.currentPage - 1, 0);
        this.updateByPage();
    }

    public void nextRecipe() {
        int prevPage = this.currentPage;
        this.currentPage = Math.min(this.currentPage + 1, this.maxPageIndex);
        if (prevPage != this.currentPage) {
            this.updateByPage();
        }
    }

    public void setViewType(int typeId) {
        int prevIndex = this.currentTypeIndex;
        this.currentTypeIndex = typeId;
        if (prevIndex != this.currentTypeIndex) {
            this.updateByViewType();
        }
    }

    public boolean hasNextRecipe() {
        return this.currentPage < this.maxPageIndex;
    }

    public boolean hasPrevRecipe() {
        return this.currentPage > 0;
    }

    public List<IEivRecipeViewType> getViewTypeOrder() {
        return this.viewTypeOrder;
    }

    public int getCurrentTypeIndex() {
        return this.currentTypeIndex;
    }

    protected List<IEivViewRecipe> getCurrentDisplay() {
        return this.currentDisplay;
    }

    private List<IEivViewRecipe> getRecipeDisplay() {
        ArrayList<IEivViewRecipe> recipesOnPage = new ArrayList<IEivViewRecipe>();
        for (int i = this.currentPage * this.maxPossiblePerPage; i < Math.min(this.getRecipes().size(), (this.currentPage + 1) * this.maxPossiblePerPage); ++i) {
            recipesOnPage.add(this.getRecipes().get(i));
        }
        return recipesOnPage;
    }

    protected void updateByPage() {
        int i;
        this.additionalStackModifiers.clear();
        this.optionalSlotRenderers.clear();
        this.field_7761.clear();
        this.currentDisplay.forEach(IEivViewRecipe::fadeRecipe);
        this.currentDisplay.clear();
        this.currentDisplay.addAll(this.getRecipeDisplay());
        this.currentDisplay.forEach(IEivViewRecipe::initRecipe);
        this.currentCraftReference = 0;
        for (i = 0; i < this.currentDisplay.size(); ++i) {
            IEivViewRecipe recipe = this.currentDisplay.get(i);
            recipe.getIngredients().forEach(slotContent -> slotContent.bindOrigin(this.origin, this.originType));
            recipe.getResults().forEach(slotContent -> slotContent.bindOrigin(this.origin, this.originType));
            recipe.getIngredients().forEach(slotContent -> slotContent.setType(SlotContent.Type.INGREDIENT));
            recipe.getResults().forEach(slotContent -> slotContent.setType(SlotContent.Type.RESULT));
            SlotDefinition slotDefinition = new SlotDefinition();
            this.viewType.placeSlots(slotDefinition);
            for (class_1735 slot : slotDefinition.getItemSlots()) {
                int id = slot.method_34266() + i * this.getViewType().getSlotCount();
                this.method_7621(new class_1735(slot.field_7871, id, slot.field_7873 + this.guiOffsetLeft(), slot.field_7872 + this.guiOffsetTop(i)));
            }
            SlotFillContext slotFillContext = new SlotFillContext();
            recipe.bindSlots(slotFillContext);
            for (int j = 0; j < this.getViewType().getSlotCount(); ++j) {
                int slotId = j + i * this.getViewType().getSlotCount();
                this.viewContainer.method_5447(slotId, slotFillContext.contentBySlot(j).getByIndex(slotFillContext.contentBySlot(j).index()));
                if (slotFillContext.getAdditionalTooltips().containsKey(j)) {
                    this.additionalStackModifiers.put(slotId, slotFillContext.getAdditionalTooltips().get(j));
                }
                if (!slotFillContext.getOptionalSlotRenderers().containsKey(j)) continue;
                this.optionalSlotRenderers.put(slotId, slotFillContext.getOptionalSlotRenderers().get(j));
            }
        }
        this.transferData.clear();
        for (i = 0; i < this.getCurrentDisplay().size(); ++i) {
            this.transferData.add(this.checkMatchingContent(i));
        }
        if (this.viewScreen != null) {
            this.viewScreen.checkGui();
        }
        this.updateDependencies();
        for (i = 0; i < this.getDisplayableCraftReferences(); ++i) {
            this.method_7621(new class_1735((class_1263)this.viewContainer, this.viewType.getSlotCount() * this.getCurrentDisplay().size() + i, -21, 8 + i * 24 + i));
        }
        this.updateReferences();
    }

    public int getDisplayableCraftReferences() {
        List<class_1799> craftReferences = this.getViewType().getCraftReferences();
        return Math.min(craftReferences.size(), (this.getHeight() - 4) / 25);
    }

    private void updateReferences() {
        List<class_1799> craftReferences = this.viewType.getCraftReferences();
        for (int i = this.currentCraftReference; i < Math.min(this.viewType.getCraftReferences().size(), this.currentCraftReference + this.getDisplayableCraftReferences()); ++i) {
            this.method_7611(this.viewType.getSlotCount() * this.getCurrentDisplay().size() + (i - this.currentCraftReference)).method_7673(craftReferences.get(i));
        }
    }

    public List<RecipeTransferData> getTransferData() {
        return this.transferData;
    }

    private RecipeTransferData checkMatchingContent(int displayId) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null) {
            return RecipeTransferData.EMPTY;
        }
        IEivViewRecipe currentLooking = this.getCurrentDisplay().get(displayId);
        SlotFillContext context = new SlotFillContext();
        currentLooking.bindSlots(context);
        class_746 player = minecraft.field_1724;
        class_2371 playerInvCache = class_2371.method_10213((int)player.method_31548().method_67533().size(), (Object)class_1799.field_8037);
        for (int slot2 = 0; slot2 < playerInvCache.size(); ++slot2) {
            playerInvCache.set(slot2, (Object)player.method_31548().method_5438(slot2).method_7972());
        }
        RecipeTransferData.Builder dataBuilder = new RecipeTransferData.Builder();
        context.getContents().keySet().stream().filter(slot -> context.getContents().get(slot).getType() != SlotContent.Type.RESULT).forEach(dataBuilder::noticeSlot);
        HashMap<Integer, List<class_1799>> validAndAvailableContent = new HashMap<Integer, List<class_1799>>();
        for (int slot3 : context.getContents().keySet()) {
            SlotContent content = context.getContents().get(slot3);
            if (content.getType() == SlotContent.Type.RESULT) continue;
            if (content.isEmpty()) {
                dataBuilder.findContent(slot3, new HashMap<Integer, class_1799>());
                continue;
            }
            ArrayList availableItems = new ArrayList();
            content.getValidContents().forEach(stack -> {
                StackValidator stackValidator = context.getStackValidators().getOrDefault(slot3, null);
                if (playerInvCache.stream().anyMatch(stack1 -> stack1.method_31574(stack.method_7909())) && (stackValidator == null || stackValidator.validate((class_1799)stack))) {
                    availableItems.add(stack);
                }
            });
            validAndAvailableContent.put(slot3, availableItems);
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        context.getContents().forEach((slot, slotContent) -> {
            if (slotContent.getType() != SlotContent.Type.RESULT) {
                slots.add((Integer)slot);
            }
        });
        HashMap<Integer, HashMap<Integer, class_1799>> bestMatch = new HashMap<Integer, HashMap<Integer, class_1799>>();
        this.check(slots, 0, validAndAvailableContent, new HashMap<Integer, HashMap<Integer, class_1799>>(), bestMatch, (class_2371<class_1799>)playerInvCache);
        bestMatch.forEach(dataBuilder::findContent);
        RecipeTransferData transferData = dataBuilder.build();
        if (transferData.isSuccess() && !transferData.getUsedPlayerSlots().isEmpty()) {
            class_1799 required;
            HashMap<Integer, class_1799> requiredStacks = new HashMap<Integer, class_1799>();
            for (int recipeSlot2 : transferData.getUsedPlayerSlots().keySet()) {
                HashMap<Integer, class_1799> usedSlots = transferData.getUsedPlayerSlots().get(recipeSlot2);
                required = usedSlots.values().stream().findFirst().orElseGet(() -> class_1799.field_8037).method_7972();
                int amount = 0;
                for (class_1799 stack2 : usedSlots.values()) {
                    amount += stack2.method_7947();
                }
                if (required.method_7960()) continue;
                requiredStacks.put(recipeSlot2, required.method_46651(amount));
            }
            boolean checking = true;
            HashMap<Integer, HashMap> stackable = new HashMap<Integer, HashMap>();
            int runs = 0;
            while (checking) {
                required = requiredStacks.keySet().iterator();
                while (required.hasNext()) {
                    int recipeSlot3 = (Integer)required.next();
                    if ((runs + 1) * ((class_1799)requiredStacks.get(recipeSlot3)).method_7947() <= ((class_1799)requiredStacks.get(recipeSlot3)).method_7914() - ((class_1799)requiredStacks.get(recipeSlot3)).method_7947()) continue;
                    checking = false;
                    break;
                }
                if (!checking) break;
                HashMap<Integer, HashMap> currentStackable = new HashMap<Integer, HashMap>();
                Iterator recipeSlot3 = requiredStacks.keySet().iterator();
                while (recipeSlot3.hasNext()) {
                    int recipeSlot4 = (Integer)recipeSlot3.next();
                    class_1799 requiredStack = (class_1799)requiredStacks.get(recipeSlot4);
                    HashMap<Integer, class_1799> found = this.invCheckAndFind((class_2371<class_1799>)playerInvCache, requiredStack, true);
                    if (found.isEmpty()) {
                        checking = false;
                        break;
                    }
                    currentStackable.put(recipeSlot4, found);
                }
                if (!checking) continue;
                currentStackable.forEach((recipeSlot, usedPlayerSlots) -> {
                    HashMap presentStackable = stackable.getOrDefault(recipeSlot, new HashMap());
                    usedPlayerSlots.forEach((playerSlot, stack) -> {
                        if (presentStackable.containsKey(playerSlot)) {
                            presentStackable.put(playerSlot, stack.method_46651(((class_1799)presentStackable.get(playerSlot)).method_7947() + stack.method_7947()));
                        } else {
                            presentStackable.put(playerSlot, stack);
                        }
                    });
                    stackable.put((Integer)recipeSlot, presentStackable);
                });
                ++runs;
            }
            HashMap<Integer, HashMap> stackedMatch = new HashMap<Integer, HashMap>();
            bestMatch.forEach((recipeSlot, usedPlayerSlots) -> {
                HashMap playerSlots = new HashMap();
                usedPlayerSlots.forEach((playerSlot, stack) -> playerSlots.put(playerSlot, stack.method_7972()));
                stackedMatch.put((Integer)recipeSlot, playerSlots);
            });
            stackable.forEach((recipeSlot, usedPlayerSlots) -> usedPlayerSlots.forEach((playerSlot, stack) -> {
                if (((HashMap)stackedMatch.get(recipeSlot)).containsKey(playerSlot)) {
                    ((HashMap)stackedMatch.get(recipeSlot)).put(playerSlot, stack.method_46651(((class_1799)((HashMap)stackedMatch.get(recipeSlot)).get(playerSlot)).method_7947() + stack.method_7947()));
                } else {
                    ((HashMap)stackedMatch.get(recipeSlot)).put(playerSlot, stack);
                }
            }));
            RecipeTransferData.Builder stackedBuilder = dataBuilder.duplicate();
            stackedMatch.forEach(stackedBuilder::findContent);
            transferData.setStackedData(stackedBuilder.build());
        }
        return transferData;
    }

    private void check(List<Integer> slots, int currentSlotIndex, HashMap<Integer, List<class_1799>> validAndAvailableContent, HashMap<Integer, HashMap<Integer, class_1799>> usedPlayerSlots, HashMap<Integer, HashMap<Integer, class_1799>> bestMatch, class_2371<class_1799> playerInvCache) {
        if (currentSlotIndex >= slots.size() || bestMatch.size() == slots.size()) {
            return;
        }
        List validStacks = validAndAvailableContent.getOrDefault(slots.get(currentSlotIndex), new ArrayList());
        for (class_1799 requiredStack : validStacks) {
            HashMap<Integer, class_1799> found = this.invCheckAndFind(playerInvCache, requiredStack, false);
            if (found.isEmpty()) continue;
            usedPlayerSlots.put(slots.get(currentSlotIndex), found);
            if (usedPlayerSlots.size() > bestMatch.size()) {
                bestMatch.putAll(usedPlayerSlots);
            }
            this.check(slots, currentSlotIndex + 1, validAndAvailableContent, usedPlayerSlots, bestMatch, playerInvCache);
        }
        this.check(slots, currentSlotIndex + 1, validAndAvailableContent, usedPlayerSlots, bestMatch, playerInvCache);
    }

    private HashMap<Integer, class_1799> invCheckAndFind(class_2371<class_1799> playerInvCache, class_1799 requiredStack, boolean checkComponents) {
        HashMap<Integer, class_1799> usedPlayerSlots = new HashMap<Integer, class_1799>();
        int requiredAmount = requiredStack.method_7947();
        class_1799 firstFound = class_1799.field_8037;
        for (int playerSlot = 0; playerSlot < playerInvCache.size() && requiredAmount > 0; ++playerSlot) {
            class_1799 playerStack = (class_1799)playerInvCache.get(playerSlot);
            class_1799 foundStack = playerStack.method_7972();
            if (!(checkComponents ? class_1799.method_31577((class_1799)playerStack, (class_1799)requiredStack) : class_1799.method_7984((class_1799)playerStack, (class_1799)requiredStack))) continue;
            if (firstFound.method_7960()) {
                firstFound = foundStack.method_7972();
            }
            if (!class_1799.method_31577((class_1799)foundStack, (class_1799)firstFound)) continue;
            int prevReq = requiredAmount;
            requiredAmount -= Math.min(requiredAmount, playerStack.method_7947());
            playerStack.method_7939(playerStack.method_7947() - (prevReq - requiredAmount));
            if (playerStack.method_7947() <= 0) {
                playerInvCache.set(playerSlot, (Object)class_1799.field_8037);
            }
            foundStack.method_7939(prevReq - requiredAmount);
            usedPlayerSlots.put(playerSlot, foundStack);
        }
        if (requiredAmount == 0) {
            return usedPlayerSlots;
        }
        this.returnToCache(usedPlayerSlots, playerInvCache);
        return new HashMap<Integer, class_1799>();
    }

    private void returnToCache(HashMap<Integer, class_1799> usedPlayerSlots, class_2371<class_1799> playerInvCache) {
        usedPlayerSlots.forEach((playerSlot, stack) -> {
            if (((class_1799)playerInvCache.get(playerSlot.intValue())).method_7960()) {
                playerInvCache.set(playerSlot.intValue(), stack);
            } else {
                ((class_1799)playerInvCache.get(playerSlot.intValue())).method_7939(((class_1799)playerInvCache.get(playerSlot.intValue())).method_7947() + stack.method_7947());
            }
        });
    }

    private void resetContentPointers() {
        this.recipes.forEach(iEivRecipe -> {
            iEivRecipe.getIngredients().forEach(SlotContent::resetPointer);
            iEivRecipe.getResults().forEach(SlotContent::resetPointer);
        });
    }

    protected void updateByViewType() {
        this.currentPage = 0;
        this.recipes = this.sortedByType.getOrDefault(this.viewTypeOrder.get(this.currentTypeIndex), new ArrayList());
        this.resetContentPointers();
        Optional optional = this.recipes.stream().findFirst();
        if (optional.isPresent()) {
            this.viewType = ((IEivViewRecipe)optional.get()).getViewType();
            this.maxPossiblePerPage = this.calculateRecipesPerPage();
            int i = this.getRecipes().size() / this.maxPossiblePerPage;
            if (this.getRecipes().size() % this.maxPossiblePerPage != 0) {
                ++i;
            }
            this.maxPageIndex = i - 1;
            this.setMenuSizes();
            this.viewContainer = new ViewContainer(this.viewType.getSlotCount() * this.maxPossiblePerPage + this.getDisplayableCraftReferences());
            this.updateByPage();
        }
    }

    private void setMenuSizes() {
        this.menuHeight = 24 + this.getRecipeDisplay().size() * this.getViewType().getDisplayHeight() + this.getRecipeDisplay().size() * 16 + 8;
        this.menuWidth = 176;
    }

    public int getHeight() {
        return this.menuHeight;
    }

    public int getWidth() {
        return this.menuWidth;
    }

    protected int guiOffsetLeft() {
        return (this.menuWidth - this.getViewType().getDisplayWidth()) / 2;
    }

    protected int guiOffsetTop(int displayIndex) {
        return 24 + displayIndex * (this.getViewType().getDisplayHeight() + 16);
    }

    protected void tickContents() {
        for (int i = 0; i < this.currentDisplay.size(); ++i) {
            IEivViewRecipe recipe = this.currentDisplay.get(i);
            SlotFillContext slotFillContext = new SlotFillContext();
            recipe.bindSlots(slotFillContext);
            for (int j = 0; j < this.getViewType().getSlotCount(); ++j) {
                if (slotFillContext.contentDependencies.containsKey(j)) continue;
                this.viewContainer.method_5447(j + i * this.getViewType().getSlotCount(), slotFillContext.contentBySlot(j).next());
            }
        }
        this.updateDependencies();
    }

    protected void updateDependencies() {
        for (int i = 0; i < this.currentDisplay.size(); ++i) {
            IEivViewRecipe recipe = this.currentDisplay.get(i);
            SlotFillContext slotFillContext = new SlotFillContext();
            recipe.bindSlots(slotFillContext);
            for (int j = 0; j < this.getViewType().getSlotCount(); ++j) {
                if (!slotFillContext.contentDependencies.containsKey(j)) continue;
                this.viewContainer.method_5447(j + i * this.getViewType().getSlotCount(), slotFillContext.contentBySlot(j).getByIndex(Math.min(slotFillContext.contentDependencies.get(j).get(), slotFillContext.contentBySlot(j).size() - 1)));
            }
        }
    }

    public List<? extends IEivViewRecipe> getRecipes() {
        return this.recipes;
    }

    public IEivRecipeViewType getViewType() {
        return this.viewType;
    }

    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    private int calculateRecipesPerPage() {
        if (this.getRecipes().isEmpty()) {
            return 0;
        }
        int recipeHeight = this.getViewType().getDisplayHeight();
        int technicallyFitting = Math.min(this.getRecipes().size(), 224 / recipeHeight);
        int imageheightRequired = technicallyFitting * recipeHeight + (technicallyFitting * 16 + 24 + 24);
        while (imageheightRequired > 224) {
            imageheightRequired = --technicallyFitting * recipeHeight + (technicallyFitting * 16 + 24 + 24);
        }
        return technicallyFitting;
    }

    public void updateTransferCache() {
        this.transferData.clear();
        for (int i = 0; i < this.getCurrentDisplay().size(); ++i) {
            this.transferData.add(this.checkMatchingContent(i));
        }
        this.viewScreen.checkGui();
    }

    public static interface AdditionalStackModifier {
        public static final AdditionalStackModifier NONE = (stack, tooltip) -> {};

        public void addTooltip(class_1799 var1, List<class_2561> var2);
    }

    public static interface OptionalSlotRenderer {
        public static final OptionalSlotRenderer DEFAULT = (guiGraphics, mouseX, mouseY, partialTicks) -> guiGraphics.method_25290(class_10799.field_56883, BuiltInEivIntegration.DEFAULT_SLOT_TEXTURE, 0, 0, 0.0f, 0.0f, 18, 18, 18, 18);

        public void render(class_332 var1, int var2, int var3, float var4);
    }

    public class SlotDefinition {
        private final HashMap<Integer, class_1735> itemSlots = new HashMap();

        private SlotDefinition() {
        }

        public void addItemSlot(int slotId, int x, int y) {
            this.itemSlots.put(slotId, new class_1735((class_1263)RecipeViewMenu.this.viewContainer, slotId, x, y));
        }

        private List<class_1735> getItemSlots() {
            return this.itemSlots.values().stream().toList();
        }
    }

    public static class SlotFillContext {
        private final HashMap<Integer, SlotContent> contents = new HashMap();
        private final HashMap<Integer, Supplier<Integer>> contentDependencies = new HashMap();
        private final HashMap<Integer, AdditionalStackModifier> additionalTooltips = new HashMap();
        private final HashMap<Integer, StackValidator> stackValidators = new HashMap();
        private final HashMap<Integer, OptionalSlotRenderer> optionalSlotRenderers = new HashMap();

        protected SlotFillContext() {
        }

        public void bindSlot(int slotId, SlotContent slotContent) {
            this.contents.put(slotId, slotContent);
        }

        public void bindDepedantSlot(int slotId, Supplier<Integer> dependantIndex, SlotContent slotContent) {
            this.contents.put(slotId, slotContent);
            this.contentDependencies.put(slotId, dependantIndex);
        }

        public void bindOptionalSlot(int slotId, SlotContent slotContent, OptionalSlotRenderer optionalSlotRenderer) {
            this.contents.put(slotId, slotContent);
            this.optionalSlotRenderers.put(slotId, optionalSlotRenderer);
        }

        public HashMap<Integer, Supplier<Integer>> contentDependencies() {
            return this.contentDependencies;
        }

        public void addAdditionalStackModifier(int slotId, AdditionalStackModifier tooltipProvider) {
            this.additionalTooltips.put(slotId, tooltipProvider);
        }

        public void addStackValidator(int slotId, StackValidator stackValidator) {
            this.stackValidators.put(slotId, stackValidator);
        }

        protected HashMap<Integer, SlotContent> getContents() {
            return this.contents;
        }

        protected HashMap<Integer, OptionalSlotRenderer> getOptionalSlotRenderers() {
            return this.optionalSlotRenderers;
        }

        protected SlotContent contentBySlot(int slotId) {
            return this.contents.getOrDefault(slotId, SlotContent.of(List.of()));
        }

        private HashMap<Integer, AdditionalStackModifier> getAdditionalTooltips() {
            return this.additionalTooltips;
        }

        private HashMap<Integer, StackValidator> getStackValidators() {
            return this.stackValidators;
        }
    }

    public static interface StackValidator {
        public boolean validate(class_1799 var1);
    }
}

