/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.smithing;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.Nullable;

public class SmithingServerRecipe
implements IEivServerRecipe {
    public static final EivRecipeType<SmithingServerRecipe> TYPE = EivRecipeType.register(ResourceLocation.withDefaultNamespace((String)"smithing"), () -> new SmithingServerRecipe(false, null, null, null, null, null));
    private boolean isTrim;
    private Ingredient base;
    private Ingredient template;
    private Ingredient addition;
    private TrimPattern pattern;
    private TransmuteResult upgradeResult;

    public SmithingServerRecipe(boolean isTrim, Ingredient base, Ingredient template, Ingredient addition, TrimPattern pattern, @Nullable TransmuteResult upgradeResult) {
        this.isTrim = isTrim;
        this.base = base;
        this.template = template;
        this.addition = addition;
        this.pattern = pattern;
        this.upgradeResult = upgradeResult;
    }

    public boolean isTrim() {
        return this.isTrim;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public Ingredient getTemplate() {
        return this.template;
    }

    public Ingredient getAddition() {
        return this.addition;
    }

    public TrimPattern getPattern() {
        return this.pattern;
    }

    @Nullable
    public TransmuteResult getUpgradeResult() {
        return this.upgradeResult;
    }

    @Override
    public void writeToTag(CompoundTag tag) {
        tag.putBoolean("isTrim", this.isTrim);
        tag.put("base", (Tag)EivTagUtil.writeIngredient(this.base));
        tag.put("template", (Tag)EivTagUtil.writeIngredient(this.template));
        tag.put("addition", (Tag)EivTagUtil.writeIngredient(this.addition));
        if (this.pattern != null) {
            tag.put("pattern", (Tag)TrimPattern.DIRECT_CODEC.encode((Object)this.pattern, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
        }
        if (this.upgradeResult != null) {
            tag.put("upgradeResult", (Tag)TransmuteResult.CODEC.encode((Object)this.upgradeResult, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
        }
    }

    @Override
    public void loadFromTag(CompoundTag tag) {
        this.isTrim = tag.getBooleanOr("isTrim", false);
        this.base = EivTagUtil.readIngredient(tag.getCompound("base").orElseGet(CompoundTag::new));
        this.template = EivTagUtil.readIngredient(tag.getCompound("template").orElseGet(CompoundTag::new));
        this.addition = EivTagUtil.readIngredient(tag.getCompound("addition").orElseGet(CompoundTag::new));
        this.pattern = (TrimPattern)TrimPattern.DIRECT_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)((Tag)tag.getCompound("pattern").orElseGet(CompoundTag::new))).mapOrElse(Pair::getFirst, pairError -> null);
        this.upgradeResult = (TransmuteResult)TransmuteResult.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)((Tag)tag.getCompound("upgradeResult").orElseGet(CompoundTag::new))).mapOrElse(Pair::getFirst, pairError -> null);
    }

    @Override
    public EivRecipeType<? extends IEivServerRecipe> getRecipeType() {
        return TYPE;
    }
}

