/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.overlay.itemlist;

import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.config.Configs;
import de.crafty.eiv.common.overlay.AbstractEivOverlay;
import de.crafty.eiv.common.overlay.ItemSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractEivItemListOverlay
extends AbstractEivOverlay {
    protected static final int ITEM_ENTRY_SIZE = 20;
    protected int itemStartX;
    protected int itemStartY;
    protected int itemEndX;
    protected int itemEndY;
    protected int startIndex = 0;
    private int fittingPerPage = 0;
    protected List<ItemStack> availableItems = new ArrayList<ItemStack>();

    protected AbstractEivItemListOverlay(int defaultX, int defaultY, int defaultWidth, int defaultHeight) {
        super(defaultX, defaultY, defaultWidth, defaultHeight);
    }

    @Override
    public void updateEffectiveDimensions(AbstractEivOverlay.InventoryPositionInfo info) {
        super.updateEffectiveDimensions(info);
        this.effectiveWidth -= (this.effectiveWidth - 4) % 20;
        this.effectiveX = this.effectiveX <= info.screenWidth() / 2 ? this.effectiveX : info.screenWidth() - this.effectiveWidth;
    }

    @Override
    protected boolean scrollMouse(double mouseX, double mouseY, double scrolledX, double scrolledY) {
        int fittingPerPage;
        if (CommonEIVClient.isCheatmodeActive()) {
            for (ItemSlot slot : this.itemSlots()) {
                if (!slot.isHovered()) continue;
                slot.changeCheatmodeCount(scrolledY < 0.0 ? -1 : 1);
                return true;
            }
        }
        if ((fittingPerPage = this.fittingPerPage()) == 0) {
            return true;
        }
        if (scrolledY < 0.0 && this.startIndex + fittingPerPage < this.availableItems().size()) {
            this.startIndex += fittingPerPage;
        }
        if (scrolledY > 0.0) {
            this.startIndex = Math.max(0, this.startIndex - fittingPerPage);
        }
        if (scrolledY != 0.0) {
            this.updateSlots();
        }
        return true;
    }

    @Override
    protected boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (ItemSlot itemSlot : this.itemSlots()) {
            if (!itemSlot.isHovered()) continue;
            itemSlot.onClicked((int)mouseX, (int)mouseY, mouseButton);
            return true;
        }
        return true;
    }

    public void updateSlots() {
        this.itemSlots().clear();
        int currentStackPos = this.startIndex;
        for (int y = this.itemStartY; y <= this.itemEndY - 20; y += 20) {
            for (int x = this.itemStartX; x <= this.itemEndX - 20; x += 20) {
                if (Configs.CLIENT_SETTINGS.isItemWrapMode()) {
                    if (this.isPositionBlocked(x, y, 20, 20)) continue;
                    if (currentStackPos < this.availableItems().size()) {
                        this.itemSlots().add(new ItemSlot(this.availableItems().get(currentStackPos), x, y));
                    }
                    ++currentStackPos;
                    continue;
                }
                if (x < this.effectiveX || x > this.effectiveX + this.effectiveWidth - 20 || y < this.effectiveY || y > this.effectiveY + this.effectiveHeight - 20) continue;
                if (currentStackPos < this.availableItems().size()) {
                    this.itemSlots().add(new ItemSlot(this.availableItems().get(currentStackPos), x, y));
                }
                ++currentStackPos;
            }
        }
        this.fittingPerPage = currentStackPos - this.startIndex;
    }

    public int fittingPerPage() {
        return this.fittingPerPage;
    }

    protected void drawScaledString(Font font, GuiGraphics guiGraphics, Component comp, int x, int y, int color) {
        float scaleFactor = Math.min(1.0f, 1.0f / ((float)font.width((FormattedText)comp) / ((float)(Configs.CLIENT_SETTINGS.isItemWrapMode() ? this.width : this.effectiveWidth) - 4.0f)));
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)x, (float)y);
        guiGraphics.pose().scale(scaleFactor, scaleFactor);
        guiGraphics.drawCenteredString(font, comp, 0, 0, color);
        guiGraphics.pose().popMatrix();
    }

    protected int getPage() {
        int page;
        int fittingPerPage = this.fittingPerPage();
        int n = page = fittingPerPage > 0 ? this.startIndex / fittingPerPage : 0;
        if (page * fittingPerPage < this.startIndex) {
            ++page;
        }
        return page;
    }

    protected int getMaxPageIndex() {
        int maxPageIndex = (this.availableItems().size() - 1) / this.fittingPerPage();
        if (this.startIndex % this.fittingPerPage() != 0 && this.startIndex % this.fittingPerPage() < this.availableItems().size() % this.fittingPerPage()) {
            ++maxPageIndex;
        }
        return maxPageIndex;
    }

    public List<ItemStack> availableItems() {
        return this.availableItems;
    }
}

