/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.forge.mixin.registries;

import de.crafty.eiv.common.recipe.ItemViewRecipes;
import de.crafty.eiv.common.recipe.item.FluidItem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IdMappingEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameData.class}, remap=false)
public class MixinGameData {
    @Shadow
    @Final
    private static Logger LOGGER;

    @Inject(method={"loadPersistentDataToStagingRegistry"}, at={@At(value="HEAD")})
    private static void excludeFluidItems(RegistryManager pool, RegistryManager _to, Map<ResourceLocation, IdMappingEvent.IdRemapping> remaps, Object2IntMap<ResourceLocation> missing, ResourceLocation name, ForgeRegistry.Snapshot snap, CallbackInfo ci) {
        if (!name.equals((Object)Registries.ITEM.location())) {
            return;
        }
        BuiltInRegistries.FLUID.forEach(fluid -> {
            Item fluidItem = ItemViewRecipes.INSTANCE.itemForFluid((Fluid)fluid);
            if (fluidItem == Items.AIR) {
                return;
            }
            if (!snap.ids.containsKey((Object)BuiltInRegistries.FLUID.getKey(fluid))) {
                snap.ids.put((Object)BuiltInRegistries.FLUID.getKey(fluid), Item.getId((Item)fluidItem));
            }
        });
    }

    @Redirect(method={"postRegisterEvents"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/ModLoader;postEventWrapContainerInModOrder(Lnet/minecraftforge/fml/event/IModBusEvent;)V"))
    private static <T extends IModBusEvent> void injectFluidItems(ModLoader instance, T e) {
        instance.postEventWrapContainerInModOrder(e);
        RegisterEvent event = (RegisterEvent)e;
        if (!event.getRegistryKey().location().equals((Object)Registries.ITEM.location())) {
            return;
        }
        HashMap<Fluid, Item> fluidItemMap = new HashMap<Fluid, Item>();
        ForgeRegistries.FLUIDS.forEach(fluid -> {
            if (fluid == Fluids.EMPTY || !fluid.isSource(fluid.defaultFluidState())) {
                return;
            }
            ResourceLocation fluidLocation = ForgeRegistries.FLUIDS.getKey(fluid);
            if (fluidLocation == null) {
                return;
            }
            if (event.getForgeRegistry() != null && event.getForgeRegistry().containsKey(fluidLocation)) {
                fluidItemMap.put((Fluid)fluid, (Item)event.getForgeRegistry().getValue(fluidLocation));
                return;
            }
            if (event.getVanillaRegistry() != null && event.getVanillaRegistry().containsKey(fluidLocation)) {
                fluidItemMap.put((Fluid)fluid, (Item)event.getVanillaRegistry().getValue(fluidLocation));
                return;
            }
            event.register(Registries.ITEM, itemRegisterHelper -> itemRegisterHelper.register(fluidLocation, (Object)new FluidItem(fluid.defaultFluidState().createLegacyBlock().getBlock(), new FluidItem.FluidItemProperties().fluid((Fluid)fluid).setItemId((ResourceKey<Item>)ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)fluidLocation)))));
        });
        ItemViewRecipes.INSTANCE.setFluidItemMap(fluidItemMap);
    }
}

