/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.villager;

import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.mixin.world.entity.npc.DyedArmorForEmeraldsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.EmeraldForItemsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.EmeraldsForVillagerTypeItemAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.EnchantBookForEmeraldsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.EnchantedItemForEmeraldsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.ItemsAndEmeraldsToItemsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.ItemsForEmeraldsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.SuspiciousStewForEmeraldAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.TippedArrowForItemsAndEmeraldsAccessor;
import de.crafty.eiv.common.mixin.world.entity.npc.TreasureMapForEmeraldsAccessor;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.EnchantmentsByCost;
import net.minecraft.world.item.enchantment.providers.EnchantmentsByCostWithDifficulty;
import net.minecraft.world.item.enchantment.providers.SingleEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.jetbrains.annotations.Nullable;

public class VillagerServerRecipe
implements IEivServerRecipe {
    public static final EivRecipeType<VillagerServerRecipe> TYPE = EivRecipeType.register(ResourceLocation.withDefaultNamespace((String)"villager_trading"), () -> new VillagerServerRecipe(null, 0, null));
    private ResourceKey<VillagerProfession> profession;
    private int professionLevel;
    private final VillagerDataObject<?> dataObject;
    private List<VillagerOffer> clientSideVillagerOffers = new ArrayList<VillagerOffer>();

    public VillagerServerRecipe(ResourceKey<VillagerProfession> profession, int professionLevel, VillagerDataObject<?> dataObject) {
        this.profession = profession;
        this.professionLevel = professionLevel;
        this.dataObject = dataObject;
    }

    public List<VillagerOffer> getOffers() {
        return this.clientSideVillagerOffers;
    }

    public ResourceKey<VillagerProfession> getProfession() {
        return this.profession;
    }

    public int getProfessionLevel() {
        return this.professionLevel;
    }

    @Override
    public void writeToTag(CompoundTag tag) {
        tag.putString("profession", this.profession.location().toString());
        tag.putInt("professionLevel", this.professionLevel);
        tag.putString("type", this.dataObject.type().id().toString());
        CompoundTag data = new CompoundTag();
        this.dataObject.type().encoder().encode(VillagerServerRecipe.castListing(this.dataObject.listing), data);
        tag.put("data", (Tag)data);
    }

    @Override
    public void loadFromTag(CompoundTag tag) {
        if (tag.contains("profession")) {
            this.profession = ((Holder.Reference)BuiltInRegistries.VILLAGER_PROFESSION.get(ResourceLocation.parse((String)((String)tag.getString("profession").orElseThrow()))).orElseThrow()).key();
        }
        this.professionLevel = tag.getIntOr("professionLevel", 0);
        VillagerOfferType type = VillagerOfferType.byId(ResourceLocation.parse((String)((String)tag.getString("type").orElseThrow())));
        this.clientSideVillagerOffers = type.decoder().decode(this.profession, this.professionLevel, tag.getCompoundOrEmpty("data"));
    }

    public static <T extends VillagerTrades.ItemListing> T castListing(VillagerTrades.ItemListing listing) {
        return (T)listing;
    }

    @Override
    public EivRecipeType<? extends IEivServerRecipe> getRecipeType() {
        return TYPE;
    }

    private static List<ItemStack> createOfferStacksFromEnchantmentProvider(EnchantmentProvider provider, ItemStack stack) {
        ArrayList<ItemStack> offerStacks = new ArrayList<ItemStack>();
        Enchantable enchantable = (Enchantable)stack.get(DataComponents.ENCHANTABLE);
        EnchantmentProvider enchantmentProvider = provider;
        Objects.requireNonNull(enchantmentProvider);
        EnchantmentProvider enchantmentProvider2 = enchantmentProvider;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleEnchantment.class, EnchantmentsByCost.class, EnchantmentsByCostWithDifficulty.class}, (Object)enchantmentProvider2, n)) {
            case 0: {
                SingleEnchantment singleEnchantment = (SingleEnchantment)enchantmentProvider2;
                for (int i = singleEnchantment.level().getMinValue(); i <= singleEnchantment.level().getMaxValue(); ++i) {
                    ItemStack offerStack = stack.copy();
                    offerStack.enchant(singleEnchantment.enchantment(), i);
                    offerStacks.add(offerStack);
                }
                break;
            }
            case 1: {
                EnchantmentsByCost byCost = (EnchantmentsByCost)enchantmentProvider2;
                if (enchantable == null) {
                    return List.of();
                }
                float f = 0.15f;
                float f1 = -0.15f;
                int byCostMin = byCost.cost().getMinValue();
                int byCostMax = byCost.cost().getMaxValue();
                ++byCostMin;
                byCostMin = Mth.clamp((int)Math.round((float)byCostMin + (float)byCostMin * f1), (int)1, (int)Integer.MAX_VALUE);
                byCostMax += 1 + enchantable.value() / 4 + enchantable.value() / 4;
                byCostMax = Mth.clamp((int)Math.round((float)byCostMax + (float)byCostMax * f), (int)1, (int)Integer.MAX_VALUE);
                for (int i = byCostMin; i <= byCostMax; ++i) {
                    EnchantmentHelper.getAvailableEnchantmentResults((int)i, (ItemStack)stack.copy(), (Stream)byCost.enchantments().stream()).forEach(enchantmentInstance -> {
                        ItemStack offerStack = stack.copy();
                        offerStack.enchant(enchantmentInstance.enchantment(), enchantmentInstance.level());
                        offerStacks.add(offerStack);
                    });
                }
                break;
            }
            case 2: {
                EnchantmentsByCostWithDifficulty byCostWithDifficulty = (EnchantmentsByCostWithDifficulty)enchantmentProvider2;
                if (enchantable == null) {
                    return List.of();
                }
                float f = 0.15f;
                float f1 = -0.15f;
                int byCostMin = byCostWithDifficulty.minCost();
                int byCostMax = byCostWithDifficulty.minCost() + byCostWithDifficulty.maxCostSpan();
                ++byCostMin;
                byCostMin = Mth.clamp((int)Math.round((float)byCostMin + (float)byCostMin * f1), (int)1, (int)Integer.MAX_VALUE);
                byCostMax += 1 + enchantable.value() / 4 + enchantable.value() / 4;
                byCostMax = Mth.clamp((int)Math.round((float)byCostMax + (float)byCostMax * f), (int)1, (int)Integer.MAX_VALUE);
                for (int i = byCostMin; i < byCostMax; ++i) {
                    EnchantmentHelper.getAvailableEnchantmentResults((int)i, (ItemStack)stack.copy(), (Stream)byCostWithDifficulty.enchantments().stream()).forEach(enchantmentInstance -> {
                        ItemStack offerStack = stack.copy();
                        offerStack.enchant(enchantmentInstance.enchantment(), enchantmentInstance.level());
                        offerStacks.add(offerStack);
                    });
                }
                break;
            }
            default: {
                offerStacks.add(stack.copy());
            }
        }
        return offerStacks;
    }

    public record VillagerDataObject<T extends VillagerTrades.ItemListing>(VillagerOfferType<T> type, T listing) {
    }

    public record VillagerOfferType<T extends VillagerTrades.ItemListing>(ResourceLocation id, Encoder<T> encoder, Decoder decoder) {
        private static final HashMap<ResourceLocation, VillagerOfferType<?>> TYPES = new HashMap();
        private static final HashMap<Class<?>, ResourceLocation> ID_BY_CLASS = new HashMap();
        public static final VillagerOfferType<VillagerTrades.EmeraldForItems> EMERALD_FOR_ITEMS = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"emerald_for_items"), VillagerTrades.EmeraldForItems.class, (listing, out) -> {
            EmeraldForItemsAccessor accessor = (EmeraldForItemsAccessor)listing;
            out.put("cost", (Tag)EivTagUtil.encodeItemStackOnServer(accessor.getItemStack().itemStack()));
            out.putInt("emeraldCount", accessor.getEmeraldAmount());
            out.putInt("villagerXp", accessor.getVillagerXp());
            out.putInt("maxUses", accessor.getMaxUses());
        }, (profession, professionLevel, in) -> {
            ItemStack cost = EivTagUtil.decodeItemStackOnClient(in.getCompoundOrEmpty("cost"));
            int emeraldCount = in.getIntOr("emeraldCount", 0);
            int villagerXp = in.getIntOr("villagerXp", 0);
            int maxUses = in.getIntOr("maxUses", 0);
            ResourceKey villagerType = !in.contains("requiredType") ? null : ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)((String)in.getString("requiredType").orElseThrow()))).orElseThrow()).key();
            return List.of(new VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerType, List.of(new ItemStack((ItemLike)Items.EMERALD, emeraldCount)), List.of(cost), List.of(), villagerXp, maxUses));
        });
        public static final VillagerOfferType<VillagerTrades.ItemsForEmeralds> ITEMS_FOR_EMERALDS = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"items_for_emeralds"), VillagerTrades.ItemsForEmeralds.class, (listing, out) -> {
            ItemsForEmeraldsAccessor accessor = (ItemsForEmeraldsAccessor)listing;
            ArrayList<ItemStack> offerStacks = new ArrayList<ItemStack>();
            if (accessor.enchantmentProvider().isPresent()) {
                EnchantmentProvider provider = (EnchantmentProvider)((Holder.Reference)ServerRecipeManager.INSTANCE.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT_PROVIDER).get(accessor.enchantmentProvider().get()).orElseThrow()).value();
                offerStacks.addAll(VillagerServerRecipe.createOfferStacksFromEnchantmentProvider(provider, accessor.itemStack()));
            } else {
                offerStacks.add(accessor.itemStack().copy());
            }
            out.put("offers", (Tag)EivTagUtil.writeList(offerStacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
            out.putInt("emeraldCost", accessor.emeraldCost());
            out.putInt("villagerXp", accessor.villagerXp());
            out.putInt("maxUses", accessor.maxUses());
        }, (profession, professionLevel, in) -> {
            List<ItemStack> offers = EivTagUtil.readList(in, "offers", EivTagUtil::decodeItemStackOnClient);
            int emeraldCost = in.getIntOr("emeraldCost", 0);
            int villagerXp = in.getIntOr("villagerXp", 0);
            int maxUses = in.getIntOr("maxUses", 0);
            ResourceKey villagerType = !in.contains("requiredType") ? null : ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)((String)in.getString("requiredType").orElseThrow()))).orElseThrow()).key();
            return List.of(new VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerType, offers, List.of(new ItemStack((ItemLike)Items.EMERALD, emeraldCost)), List.of(), villagerXp, maxUses));
        });
        public static final VillagerOfferType<VillagerTrades.SuspiciousStewForEmerald> SUSPICIOUS_STEW = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"suspicious_stew"), VillagerTrades.SuspiciousStewForEmerald.class, (listing, out) -> {
            SuspiciousStewForEmeraldAccessor accessor = (SuspiciousStewForEmeraldAccessor)listing;
            ItemStack stewStack = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW, 1);
            stewStack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)accessor.effects());
            out.put("stew", (Tag)EivTagUtil.encodeItemStackOnServer(stewStack));
            out.putInt("emeraldCost", 1);
            out.putInt("villagerXp", accessor.xp());
            out.putInt("maxUses", 12);
        }, (profession, professionLevel, in) -> {
            ItemStack stew = EivTagUtil.decodeItemStackOnClient(in.getCompoundOrEmpty("stew"));
            int emeraldCost = in.getIntOr("emeraldCost", 0);
            int villagerXp = in.getIntOr("villagerXp", 0);
            int maxUses = in.getIntOr("maxUses", 0);
            ResourceKey villagerType = !in.contains("requiredType") ? null : ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)((String)in.getString("requiredType").orElseThrow()))).orElseThrow()).key();
            return List.of(new VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerType, List.of(stew), List.of(new ItemStack((ItemLike)Items.EMERALD, emeraldCost)), List.of(), villagerXp, maxUses));
        });
        public static final VillagerOfferType<VillagerTrades.EnchantBookForEmeralds> ENCHANT_BOOK = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"enchant_book"), VillagerTrades.EnchantBookForEmeralds.class, (listing, out) -> {
            EnchantBookForEmeraldsAccessor accessor = (EnchantBookForEmeraldsAccessor)listing;
            HashMap<ResourceKey, List> offers = new HashMap<ResourceKey, List>();
            HashMap costs = new HashMap();
            Registry enchantmentRegistry = ServerRecipeManager.INSTANCE.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            enchantmentRegistry.get(accessor.tradeableEnchantments()).ifPresent(holders -> holders.stream().forEach(enchantment -> {
                ArrayList<ItemStack> offerStacks = new ArrayList<ItemStack>();
                ArrayList<ItemStack> costStacks = new ArrayList<ItemStack>();
                for (int i = Math.max(accessor.minLevel(), ((Enchantment)enchantment.value()).getMinLevel()); i <= accessor.maxLevel() && i <= ((Enchantment)enchantment.value()).getMaxLevel(); ++i) {
                    ItemStack enchantedBook = EnchantmentHelper.createBook((EnchantmentInstance)new EnchantmentInstance(enchantment, i));
                    offerStacks.add(enchantedBook);
                    int emeraldCostsMin = 2 + 3 * i;
                    int emeraldCostsMax = 5 + i * 10 - 1 + 3 * i;
                    if (enchantment.is(EnchantmentTags.DOUBLE_TRADE_PRICE)) {
                        emeraldCostsMin *= 2;
                        emeraldCostsMax *= 2;
                    }
                    if (emeraldCostsMin > 64) {
                        emeraldCostsMin = 64;
                    }
                    if (emeraldCostsMax > 64) {
                        emeraldCostsMax = 64;
                    }
                    ItemStack costStack = new ItemStack((ItemLike)Items.EMERALD, emeraldCostsMin + (emeraldCostsMax - emeraldCostsMin) / 2);
                    ItemLore lore = (ItemLore)costStack.getOrDefault(DataComponents.LORE, (Object)ItemLore.EMPTY);
                    lore = lore.withLineAdded((Component)Component.literal((String)(emeraldCostsMin + " - " + emeraldCostsMax)).withStyle(ChatFormatting.GRAY));
                    costStack.set(DataComponents.LORE, (Object)lore);
                    costStacks.add(costStack);
                }
                offers.put((ResourceKey)enchantment.unwrapKey().get(), offerStacks);
                costs.put((ResourceKey)enchantment.unwrapKey().get(), costStacks);
            }));
            CompoundTag offersTag = new CompoundTag();
            offers.forEach((enchantment, stacks) -> {
                List costStacks = (List)costs.get(enchantment);
                CompoundTag offerTag = new CompoundTag();
                offerTag.put("offerStacks", (Tag)EivTagUtil.writeList(stacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
                offerTag.put("costStacks", (Tag)EivTagUtil.writeList(costStacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
                offersTag.put(enchantment.location().toDebugFileName(), (Tag)offerTag);
            });
            out.put("offers", (Tag)offersTag);
            out.putInt("villagerXp", accessor.villagerXp());
            out.putInt("maxUses", 12);
        }, (profession, professionLevel, in) -> {
            ResourceKey villagerType = !in.contains("requiredType") ? null : ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)((String)in.getString("requiredType").orElseThrow()))).orElseThrow()).key();
            ArrayList villagerOffers = new ArrayList();
            int villagerXp = in.getIntOr("villagerXp", 0);
            int maxUses = in.getIntOr("maxUses", 0);
            CompoundTag offersTag = in.getCompoundOrEmpty("offers");
            offersTag.values().stream().map(tag -> tag.asCompound().orElseGet(CompoundTag::new)).forEach(offerTag -> {
                List<ItemStack> offerStacks = EivTagUtil.readList(offerTag, "offerStacks", EivTagUtil::decodeItemStackOnClient);
                List<ItemStack> costStacks = EivTagUtil.readList(offerTag, "costStacks", EivTagUtil::decodeItemStackOnClient);
                VillagerOffer offer = new VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerType, offerStacks, costStacks, List.of(new ItemStack((ItemLike)Items.BOOK)), villagerXp, maxUses);
                villagerOffers.add(offer);
            });
            return villagerOffers;
        });
        public static final VillagerOfferType<VillagerTrades.TreasureMapForEmeralds> TREASURE_MAP = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"treasure_map"), VillagerTrades.TreasureMapForEmeralds.class, (listing, out) -> {
            TreasureMapForEmeraldsAccessor accessor = (TreasureMapForEmeraldsAccessor)listing;
            out.putString("decoration", ((ResourceKey)accessor.destinationType().unwrapKey().orElseThrow()).location().toString());
            out.putString("displayName", accessor.displayName());
            out.putInt("emeraldCost", accessor.emeraldCost());
            out.putInt("villagerXp", accessor.villagerXp());
            out.putInt("maxUses", accessor.maxUses());
        }, (profession, professionLevel, in) -> {
            MapDecorationType decorationType = (MapDecorationType)BuiltInRegistries.MAP_DECORATION_TYPE.getOptional(ResourceLocation.parse((String)((String)in.getString("decoration").orElseThrow()))).orElseThrow();
            String displayName = in.getStringOr("displayName", "");
            int emeraldCost = in.getIntOr("emeraldCost", 0);
            int villagerXp = in.getIntOr("villagerXp", 0);
            int maxUses = in.getIntOr("maxUses", 0);
            ItemStack offerStack = new ItemStack((ItemLike)Items.FILLED_MAP);
            offerStack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)displayName));
            if (decorationType.hasMapColor()) {
                offerStack.set(DataComponents.MAP_COLOR, (Object)new MapItemColor(decorationType.mapColor()));
            }
            ItemStack costStack1 = new ItemStack((ItemLike)Items.EMERALD, emeraldCost);
            ItemStack costStack2 = new ItemStack((ItemLike)Items.COMPASS);
            ResourceKey villagerType = !in.contains("requiredType") ? null : ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)((String)in.getString("requiredType").orElseThrow()))).orElseThrow()).key();
            return List.of(new VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerType, List.of(offerStack), List.of(costStack1), List.of(costStack2), villagerXp, maxUses));
        });
        public static final VillagerOfferType<VillagerTrades.TippedArrowForItemsAndEmeralds> TIPPED_ARROW = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"tipped_arrow"), VillagerTrades.TippedArrowForItemsAndEmeralds.class, (listing, out) -> {
            TippedArrowForItemsAndEmeraldsAccessor accessor = (TippedArrowForItemsAndEmeraldsAccessor)listing;
            ArrayList offerStacks = new ArrayList();
            List<Holder> potions = BuiltInRegistries.POTION.listElements().filter(potionReference -> !((Potion)potionReference.value()).getEffects().isEmpty() && ServerRecipeManager.INSTANCE.getServer().potionBrewing().isBrewablePotion((Holder)potionReference)).collect(Collectors.toList());
            potions.forEach(holder -> {
                ItemStack offerStack = new ItemStack((ItemLike)accessor.toItem().getItem(), accessor.toCount());
                offerStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(holder));
                offerStacks.add(offerStack);
            });
            out.put("offers", (Tag)EivTagUtil.writeList(offerStacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
            out.putString("fromItem", EivTagUtil.itemToString(accessor.fromItem()));
            out.putInt("fromCount", accessor.fromCount());
            out.putInt("emeraldCost", accessor.emeraldCost());
            out.putInt("villagerXp", accessor.villagerXp());
            out.putInt("maxUses", accessor.maxUses());
        }, (profession, professionLevel, in) -> {
            List<ItemStack> offers = EivTagUtil.readList(in, "offers", EivTagUtil::decodeItemStackOnClient);
            Item fromItem = EivTagUtil.itemFromString(in.getStringOr("fromItem", ""));
            int fromCount = in.getIntOr("fromCount", 0);
            int emeraldCost = in.getIntOr("emeraldCost", 0);
            int villagerXp = in.getIntOr("villagerXp", 0);
            int maxUses = in.getIntOr("maxUses", 0);
            ResourceKey villagerType = !in.contains("requiredType") ? null : ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)((String)in.getString("requiredType").orElseThrow()))).orElseThrow()).key();
            return List.of(new VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerType, offers, List.of(new ItemStack((ItemLike)Items.EMERALD, emeraldCost)), List.of(new ItemStack((ItemLike)fromItem, fromCount)), villagerXp, maxUses));
        });
        public static final VillagerOfferType<VillagerTrades.EnchantedItemForEmeralds> ENCHANTED_ITEM_FOR_EMERALDS = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"enchanted_item_for_emeralds"), VillagerTrades.EnchantedItemForEmeralds.class, (listing, out) -> {
            EnchantedItemForEmeraldsAccessor accessor = (EnchantedItemForEmeraldsAccessor)listing;
            ArrayList offerStacks = new ArrayList();
            int bonusCostMin = 0;
            int bonusCostMax = 19;
            int totalCostsMin = Math.min(accessor.baseEmeraldCost() + bonusCostMin, 64);
            int totalCostsMax = Math.min(accessor.baseEmeraldCost() + bonusCostMax, 64);
            RegistryAccess.Frozen registryAccess = ServerRecipeManager.INSTANCE.getServer().registryAccess();
            Optional optional = registryAccess.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.ON_TRADED_EQUIPMENT);
            Enchantable enchantable = (Enchantable)accessor.itemStack().get(DataComponents.ENCHANTABLE);
            if (optional.isEmpty()) {
                return;
            }
            if (enchantable == null) {
                return;
            }
            float f = 0.15f;
            float f1 = -0.15f;
            ++bonusCostMin;
            bonusCostMin = Mth.clamp((int)Math.round((float)bonusCostMin + (float)bonusCostMin * f1), (int)1, (int)Integer.MAX_VALUE);
            bonusCostMax += 1 + enchantable.value() / 4 + enchantable.value() / 4;
            bonusCostMax = Mth.clamp((int)Math.round((float)bonusCostMax + (float)bonusCostMax * f), (int)1, (int)Integer.MAX_VALUE);
            for (int i = bonusCostMin; i <= bonusCostMax; ++i) {
                List list = EnchantmentHelper.getAvailableEnchantmentResults((int)i, (ItemStack)accessor.itemStack(), (Stream)((HolderSet.Named)optional.get()).stream());
                list.forEach(enchantmentInstance -> {
                    ItemStack stack = accessor.itemStack().copy();
                    stack.enchant(enchantmentInstance.enchantment(), enchantmentInstance.level());
                    if (offerStacks.stream().noneMatch(stack1 -> stack1.getEnchantments().equals((Object)stack.getEnchantments()))) {
                        offerStacks.add(stack);
                    }
                });
            }
            ItemStack costStack = new ItemStack((ItemLike)Items.EMERALD, totalCostsMin + (totalCostsMax - totalCostsMin) / 2);
            ItemLore lore = (ItemLore)costStack.getOrDefault(DataComponents.LORE, (Object)ItemLore.EMPTY);
            lore.withLineAdded((Component)Component.literal((String)(totalCostsMin + " - " + totalCostsMax)).withStyle(ChatFormatting.GRAY));
            costStack.set(DataComponents.LORE, (Object)lore);
            out.put("offers", (Tag)EivTagUtil.writeList(offerStacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
            out.put("costStack", (Tag)EivTagUtil.encodeItemStackOnServer(costStack));
            out.putInt("villagerXp", accessor.villagerXp());
            out.putInt("maxUses", accessor.maxUses());
        }, (profession, professionLevel, in) -> {
            List<ItemStack> offerStacks = EivTagUtil.readList(in, "offers", EivTagUtil::decodeItemStackOnClient);
            ItemStack costStack = EivTagUtil.decodeItemStackOnClient(in.getCompoundOrEmpty("costStack"));
            int villagerXp = in.getIntOr("villagerXp", 0);
            int maxUses = in.getIntOr("maxUses", 0);
            ResourceKey villagerType = !in.contains("requiredType") ? null : ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)((String)in.getString("requiredType").orElseThrow()))).orElseThrow()).key();
            return List.of(new VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerType, offerStacks, List.of(costStack), List.of(), villagerXp, maxUses));
        });
        public static final VillagerOfferType<VillagerTrades.DyedArmorForEmeralds> DYED_ARMOR = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"dyed_armor"), VillagerTrades.DyedArmorForEmeralds.class, (listing, out) -> {
            DyedArmorForEmeraldsAccessor accessor = (DyedArmorForEmeraldsAccessor)listing;
            ItemStack offerStack = new ItemStack((ItemLike)accessor.getItem());
            out.put("offerStack", (Tag)EivTagUtil.encodeItemStackOnServer(offerStack));
            out.putInt("emeraldCost", accessor.getValue());
            out.putInt("villagerXp", accessor.getVillagerXp());
            out.putInt("maxUses", accessor.getMaxUses());
        }, (profession, professionLevel, in) -> {
            ItemStack offerStack = EivTagUtil.decodeItemStackOnClient(in.getCompoundOrEmpty("offerStack"));
            int emeraldCost = in.getIntOr("emeraldCost", 0);
            int villagerXp = in.getIntOr("villagerXp", 0);
            int maxUses = in.getIntOr("maxUses", 0);
            ArrayList<ItemStack> offerStacks = new ArrayList<ItemStack>();
            if (offerStack.is(ItemTags.DYEABLE)) {
                for (DyeColor color1 : DyeColor.values()) {
                    offerStacks.add(DyedItemColor.applyDyes((ItemStack)offerStack.copy(), List.of(DyeItem.byColor((DyeColor)color1))));
                }
            } else {
                offerStacks.add(offerStack);
            }
            ResourceKey villagerType = !in.contains("requiredType") ? null : ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)((String)in.getString("requiredType").orElseThrow()))).orElseThrow()).key();
            return List.of(new VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerType, offerStacks, List.of(new ItemStack((ItemLike)Items.EMERALD, emeraldCost)), List.of(), villagerXp, maxUses));
        });
        public static final VillagerOfferType<VillagerTrades.ItemsAndEmeraldsToItems> ITEMS_AND_EMERALDS_TO_ITEMS = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"items_and_emeralds_to_items"), VillagerTrades.ItemsAndEmeraldsToItems.class, (listing, out) -> {
            ItemsAndEmeraldsToItemsAccessor accessor = (ItemsAndEmeraldsToItemsAccessor)listing;
            ItemStack costStack = accessor.fromItem().itemStack().copy();
            ArrayList<ItemStack> offerStacks = new ArrayList<ItemStack>();
            if (accessor.enchantmentProvider().isPresent()) {
                EnchantmentProvider provider = (EnchantmentProvider)((Holder.Reference)ServerRecipeManager.INSTANCE.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT_PROVIDER).get(accessor.enchantmentProvider().get()).orElseThrow()).value();
                offerStacks.addAll(VillagerServerRecipe.createOfferStacksFromEnchantmentProvider(provider, accessor.toItem()));
            } else {
                offerStacks.add(accessor.toItem().copy());
            }
            out.put("offerStacks", (Tag)EivTagUtil.writeList(offerStacks, (origin, tag) -> EivTagUtil.encodeItemStackOnServer(origin)));
            out.put("costStack", (Tag)EivTagUtil.encodeItemStackOnServer(costStack));
            out.putInt("emeraldCost", accessor.emeraldCost());
            out.putInt("villagerXp", accessor.getVillagerXp());
            out.putInt("maxUses", accessor.getMaxUses());
        }, (profession, professionLevel, in) -> {
            List<ItemStack> offerStacks = EivTagUtil.readList(in, "offerStacks", EivTagUtil::decodeItemStackOnClient);
            ItemStack costStack = EivTagUtil.decodeItemStackOnClient(in.getCompoundOrEmpty("costStack"));
            int emeraldCost = in.getIntOr("emeraldCost", 0);
            int villagerXp = in.getIntOr("villagerXp", 0);
            int maxUses = in.getIntOr("maxUses", 0);
            ResourceKey villagerType = !in.contains("requiredType") ? null : ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)((String)in.getString("requiredType").orElseThrow()))).orElseThrow()).key();
            return List.of(new VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerType, offerStacks, List.of(new ItemStack((ItemLike)Items.EMERALD, emeraldCost)), List.of(costStack), villagerXp, maxUses));
        });
        public static final VillagerOfferType<VillagerTrades.EmeraldsForVillagerTypeItem> EMERALDS_FOR_VILLAGER_TYPE = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"emeralds_for_villager_type"), VillagerTrades.EmeraldsForVillagerTypeItem.class, (listing, out) -> {
            EmeraldsForVillagerTypeItemAccessor accessor = (EmeraldsForVillagerTypeItemAccessor)listing;
            out.putInt("cost", accessor.getCost());
            out.putInt("villagerXp", accessor.getVillagerXp());
            out.putInt("maxUses", accessor.getMaxUses());
            CompoundTag tradesTag = new CompoundTag();
            accessor.getTrades().forEach((villagerType, item) -> tradesTag.putString(villagerType.location().toString(), EivTagUtil.itemToString(item)));
            out.put("trades", (Tag)tradesTag);
        }, (profession, professionLevel, in) -> {
            int cost = in.getIntOr("cost", 0);
            int villagerXp = in.getIntOr("villagerXp", 0);
            int maxUses = in.getIntOr("maxUses", 0);
            HashMap<ResourceKey, Item> trades = new HashMap<ResourceKey, Item>();
            CompoundTag tradesTag = in.getCompoundOrEmpty("trades");
            tradesTag.forEach((s, tag) -> {
                ResourceKey villagerType = ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)s)).orElseThrow()).key();
                Item item = EivTagUtil.itemFromString((String)tag.asString().orElseThrow());
                trades.put(villagerType, item);
            });
            ArrayList villagerOffers = new ArrayList();
            trades.forEach((villagerTypeResourceKey, item) -> villagerOffers.add(new VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerTypeResourceKey, List.of(new ItemStack((ItemLike)Items.EMERALD)), List.of(new ItemStack((ItemLike)item, cost)), List.of(), villagerXp, maxUses)));
            return villagerOffers;
        });
        public static final VillagerOfferType<VillagerTrades.TypeSpecificTrade> TYPE_SPECIFIC = VillagerOfferType.register(ResourceLocation.withDefaultNamespace((String)"type_specific"), VillagerTrades.TypeSpecificTrade.class, (listing, out) -> listing.trades().forEach((villagerType, itemListing) -> {
            VillagerOfferType offerType = VillagerOfferType.byClass(itemListing.getClass());
            if (offerType == null) {
                return;
            }
            CompoundTag encodedListing = new CompoundTag();
            offerType.encoder().encode(VillagerServerRecipe.castListing(itemListing), encodedListing);
            encodedListing.putString("requiredType", villagerType.location().toString());
            encodedListing.putString("listingType", offerType.id().toString());
            out.put(villagerType.location().toString(), (Tag)encodedListing);
        }), (profession, professionLevel, in) -> {
            ArrayList villagerOffers = new ArrayList();
            in.forEach((villagerType, tag) -> {
                CompoundTag listingTag = (CompoundTag)tag.asCompound().orElseThrow();
                ResourceLocation listingId = ResourceLocation.parse((String)((String)listingTag.getString("listingType").orElseThrow()));
                VillagerOfferType offerType = VillagerOfferType.byId(listingId);
                villagerOffers.addAll(offerType.decoder().decode((ResourceKey<VillagerProfession>)profession, professionLevel, listingTag));
            });
            return villagerOffers;
        });

        public static <T extends VillagerTrades.ItemListing> VillagerOfferType<T> register(ResourceLocation id, Class<T> clazz, Encoder<T> encoder, Decoder decoder) {
            VillagerOfferType<T> type = new VillagerOfferType<T>(id, encoder, decoder);
            TYPES.put(id, type);
            ID_BY_CLASS.put(clazz, id);
            return type;
        }

        public static <T extends VillagerTrades.ItemListing> VillagerOfferType<T> byId(ResourceLocation id) {
            return TYPES.get(id);
        }

        public static <T extends VillagerTrades.ItemListing> VillagerOfferType<T> byClass(Class<T> clazz) {
            if (ID_BY_CLASS.containsKey(clazz)) {
                return VillagerOfferType.byId(ID_BY_CLASS.get(clazz));
            }
            return null;
        }

        public static interface Encoder<T extends VillagerTrades.ItemListing> {
            public void encode(T var1, CompoundTag var2);
        }

        public static interface Decoder {
            public List<VillagerOffer> decode(ResourceKey<VillagerProfession> var1, int var2, CompoundTag var3);
        }
    }

    public record VillagerOffer(ResourceKey<VillagerProfession> profession, int professionLevel, @Nullable ResourceKey<VillagerType> requiredtype, List<ItemStack> offerStacks, List<ItemStack> cost1, List<ItemStack> cost2, int villagerXp, int maxUses) {
    }
}

