/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.villager;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.villager.VillagerServerRecipe;
import de.crafty.eiv.common.builtin.villager.VillagerViewType;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.rendering.EivGuiRenderHelper;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class VillagerViewRecipe
implements IEivViewRecipe {
    private final SlotContent offer;
    private final SlotContent cost1;
    private final SlotContent cost2;
    protected VillagerServerRecipe.VillagerOffer villagerOffer;
    private Villager previewVillager = null;
    private boolean prevVillagerLookLeft;
    private boolean villagerLookLeft = false;
    private int lastHeadChange;
    private int currentTick = 0;
    private final Random random;

    public VillagerViewRecipe(VillagerServerRecipe.VillagerOffer villagerOffer) {
        this.offer = SlotContent.of(villagerOffer.offerStacks());
        this.cost1 = SlotContent.of(villagerOffer.cost1());
        this.cost2 = SlotContent.of(villagerOffer.cost2());
        this.villagerOffer = villagerOffer;
        this.random = new Random();
        if (Minecraft.getInstance().level != null) {
            this.prevVillagerLookLeft = this.villagerLookLeft = this.random.nextBoolean();
        }
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return VillagerViewType.INSTANCE;
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindDepedantSlot(0, this.offer::index, this.cost1);
        slotFillContext.bindSlot(1, this.cost2);
        slotFillContext.bindSlot(2, this.offer);
    }

    @Override
    public List<SlotContent> getIngredients() {
        return List.of(this.cost1, this.cost2);
    }

    @Override
    public List<SlotContent> getResults() {
        return List.of(this.offer);
    }

    @Override
    public void tick() {
        ++this.currentTick;
        if (Minecraft.getInstance().level == null) {
            return;
        }
        if (this.currentTick - this.lastHeadChange < 60) {
            return;
        }
        this.prevVillagerLookLeft = this.villagerLookLeft;
        this.villagerLookLeft = this.random.nextBoolean();
        this.lastHeadChange = this.currentTick;
    }

    @Override
    public void initRecipe() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        this.previewVillager = (Villager)EntityType.VILLAGER.create((Level)level, EntitySpawnReason.LOAD);
        if (this.previewVillager == null) {
            return;
        }
        this.previewVillager.setVillagerData(this.previewVillager.getVillagerData().withLevel(this.villagerOffer.professionLevel()).withType((HolderGetter.Provider)level.registryAccess(), VillagerType.PLAINS).withProfession((HolderGetter.Provider)level.registryAccess(), this.villagerOffer.profession()));
        this.previewVillager.setNoAi(true);
        this.previewVillager.setYHeadRot((this.villagerLookLeft ? -1.0f : 1.0f) * 15.0f);
        if (this.villagerOffer.requiredtype() != null) {
            this.previewVillager.setVillagerData(this.previewVillager.getVillagerData().withType((Holder)level.registryAccess().lookupOrThrow(Registries.VILLAGER_TYPE).getOrThrow(this.villagerOffer.requiredtype())));
        }
    }

    @Override
    public void fadeRecipe() {
        if (this.previewVillager != null) {
            this.previewVillager.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition recipePosition, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.getInstance().font;
        ResourceKey<VillagerProfession> profession = this.villagerOffer.profession();
        String namespace = profession.location().getNamespace();
        String path = profession.location().getPath();
        float scale = 0.75f;
        MutableComponent professionComp = Component.translatable((String)("entity." + namespace + ".villager." + path)).append(" - ").append((Component)Component.translatable((String)("merchant.level." + this.villagerOffer.professionLevel()))).withStyle(ChatFormatting.DARK_GRAY);
        guiGraphics.pose().pushMatrix();
        Matrix3x2fStack matrix3x2fStack = guiGraphics.pose();
        Objects.requireNonNull(font);
        matrix3x2fStack.translate(0.0f, (float)(-9) * scale);
        guiGraphics.pose().scale(scale, scale);
        guiGraphics.drawString(font, (Component)professionComp, 0, 0, -1, false);
        guiGraphics.pose().popMatrix();
        if (this.villagerLookLeft != this.prevVillagerLookLeft && (float)(this.currentTick - this.lastHeadChange) <= 5.0f) {
            float pastTime = (float)(this.currentTick - this.lastHeadChange) + partialTicks;
            float headRotationProgress = pastTime / 5.0f;
            this.previewVillager.setYHeadRot((this.villagerLookLeft ? -1.0f : 1.0f) * (15.0f * headRotationProgress));
        }
        this.renderVillager(guiGraphics, recipePosition, mouseX, mouseY, partialTicks);
        if (this.villagerOffer.requiredtype() == null) {
            return;
        }
        if (mouseX >= 0 && mouseX <= 24 && mouseY >= 0 && mouseY <= 36) {
            ResourceLocation typeLocation = this.villagerOffer.requiredtype().location();
            MutableComponent typeComponent = Component.translatable((String)("view.eiv.type.trading." + typeLocation.getNamespace() + "." + typeLocation.getPath())).withStyle(ChatFormatting.GOLD);
            guiGraphics.setComponentTooltipForNextFrame(font, List.of(typeComponent), recipePosition.left() + mouseX, recipePosition.top() + mouseY);
        }
    }

    private void renderVillager(GuiGraphics guiGraphics, IEivViewRecipe.RecipePosition recipePosition, int mouseX, int mouseY, float partialTicks) {
        if (this.previewVillager == null) {
            return;
        }
        EivGuiRenderHelper.renderEntityOnScreen(guiGraphics, (LivingEntity)this.previewVillager, recipePosition.left() + 2, recipePosition.top() + 2, recipePosition.left() + 2 + 20, recipePosition.top() + 2 + 32, 15.0f, new Vector3f(0.0f, 1.0666667f, 0.0f), new Quaternionf().rotationXYZ((float)Math.toRadians(180.0), 0.0f, 0.0f), null);
    }
}

