/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.api.recipe;

import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;

public interface EivRecipeType<T extends IEivServerRecipe> {
    public static final HashMap<ResourceLocation, EivRecipeType<?>> EIV_RECIPE_TYPES = new HashMap();

    public ResourceLocation getId();

    public EmptyRecipeConstructor<T> getEmptyConstructor();

    public static <S extends IEivServerRecipe> EivRecipeType<S> register(final ResourceLocation id, final EmptyRecipeConstructor<S> emptyRecipeConstructor) {
        EivRecipeType type = new EivRecipeType<S>(){

            @Override
            public ResourceLocation getId() {
                return id;
            }

            @Override
            public EmptyRecipeConstructor<S> getEmptyConstructor() {
                return emptyRecipeConstructor;
            }
        };
        EIV_RECIPE_TYPES.put(id, type);
        return type;
    }

    public static EivRecipeType<?> byId(ResourceLocation id) {
        return EIV_RECIPE_TYPES.getOrDefault(id, null);
    }

    public static ResourceLocation idFromType(EivRecipeType<?> recipeType) {
        return recipeType.getId();
    }

    public static interface EmptyRecipeConstructor<T extends IEivServerRecipe> {
        public T construct();
    }
}

