/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.neoforge.builtin;

import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.builtin.BuiltInEivIntegration;
import de.crafty.eiv.common.builtin.villager.VillagerServerRecipe;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import de.crafty.eiv.neoforge.mixin.neoforge.common.BasicItemListingAccessor;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.BasicItemListing;

public class NeoForgeBuiltinEivIntegration
extends BuiltInEivIntegration {
    public static final VillagerServerRecipe.VillagerOfferType<BasicItemListing> NEOFORGE_BASIC = VillagerServerRecipe.VillagerOfferType.register(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"basic"), BasicItemListing.class, (listing, out) -> {
        BasicItemListingAccessor accessor = (BasicItemListingAccessor)listing;
        out.put("offerStack", (Tag)EivTagUtil.encodeItemStackOnServer(accessor.offer()));
        out.put("price", (Tag)EivTagUtil.encodeItemStackOnServer(accessor.price1()));
        out.put("price2", (Tag)EivTagUtil.encodeItemStackOnServer(accessor.price2()));
        out.putInt("villagerXp", accessor.villagerxp());
        out.putInt("maxUses", accessor.maxUses());
    }, (profession, professionLevel, in) -> {
        ItemStack offerStack = EivTagUtil.decodeItemStackOnClient(in.getCompoundOrEmpty("offerStack"));
        ItemStack price = EivTagUtil.decodeItemStackOnClient(in.getCompoundOrEmpty("price"));
        ItemStack price2 = EivTagUtil.decodeItemStackOnClient(in.getCompoundOrEmpty("price2"));
        int villagerXp = in.getIntOr("villagerXp", 0);
        int maxUses = in.getIntOr("maxUses", 0);
        ResourceKey villagerType = !in.contains("requiredType") ? null : ((Holder.Reference)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)((String)in.getString("requiredType").orElseThrow()))).orElseThrow()).key();
        return List.of(new VillagerServerRecipe.VillagerOffer((ResourceKey<VillagerProfession>)profession, professionLevel, (ResourceKey<VillagerType>)villagerType, List.of(offerStack), List.of(price), List.of(price2), villagerXp, maxUses));
    });

    @Override
    public void onIntegrationInitialize() {
        super.onIntegrationInitialize();
        ItemView.addRecipeProvider(recipeList -> VillagerTrades.TRADES.forEach((profession, byProfessionLevel) -> byProfessionLevel.forEach((professionLevel, itemListings) -> Arrays.asList(itemListings).forEach(listing -> {
            if (listing instanceof BasicItemListing) {
                BasicItemListing basicItemListing = (BasicItemListing)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<BasicItemListing>(NEOFORGE_BASIC, basicItemListing)));
            }
        }))));
    }
}

