/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.overlay;

import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.config.Configs;
import de.crafty.eiv.common.overlay.AbstractEivOverlay;
import de.crafty.eiv.common.overlay.BlockingGuiComponent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;

public class OverlayManager {
    public static final OverlayManager INSTANCE = new OverlayManager();
    private AbstractEivOverlay.InventoryPositionInfo currentInvInfo = null;
    private final List<class_364> oldWidgets = new ArrayList<class_364>();
    private final HashMap<AbstractEivOverlay, AbstractEivOverlay.ScreenContext> screenContextMap = new HashMap();
    private boolean queuedWidgetUpdate = false;
    private final List<BlockingGuiComponent> guiBlockings = new ArrayList<BlockingGuiComponent>();
    private static final List<AbstractEivOverlay> PRESENT_OVERLAYS = new ArrayList<AbstractEivOverlay>();

    public boolean hasQueuedWidgetUpdate() {
        return this.queuedWidgetUpdate;
    }

    public void setQueuedWidgetUpdate(boolean queuedWidgetUpdate) {
        this.queuedWidgetUpdate = queuedWidgetUpdate;
    }

    public void setCurrentInvInfo(AbstractEivOverlay.InventoryPositionInfo info) {
        this.currentInvInfo = info;
    }

    public boolean checkForScreenChange(AbstractEivOverlay.InventoryPositionInfo newInfo) {
        if (newInfo != null && !newInfo.matches(this.currentInvInfo)) {
            this.setCurrentInvInfo(newInfo);
            return true;
        }
        return false;
    }

    public void onScreenChanged() {
        PRESENT_OVERLAYS.forEach(overlay -> overlay.onScreenChanged(this.currentInfo()));
        PRESENT_OVERLAYS.forEach(present -> {
            AbstractEivOverlay.ScreenContext screenContext = new AbstractEivOverlay.ScreenContext();
            present.placeWidgets(screenContext);
            this.screenContextMap.put((AbstractEivOverlay)present, screenContext);
        });
    }

    public void updateOverlaysAndWidgets() {
        if (this.currentInfo() == null) {
            return;
        }
        this.screenContextMap.forEach((overlay, screenContext) -> {
            screenContext.renderables().stream().filter(guiEventListener -> !this.oldWidgets.contains(guiEventListener)).forEach(this.oldWidgets::add);
            screenContext.nonRenderables().stream().filter(guiEventListener -> !this.oldWidgets.contains(guiEventListener)).forEach(this.oldWidgets::add);
        });
        this.screenContextMap.clear();
        INSTANCE.onScreenChanged();
        this.setQueuedWidgetUpdate(true);
    }

    public AbstractEivOverlay.InventoryPositionInfo currentInfo() {
        return this.currentInvInfo;
    }

    public boolean isTextWidgetFocused() {
        if (this.currentInvInfo.screen().method_25399() == null) {
            return false;
        }
        if (!this.currentInvInfo.screen().method_25399().method_25370()) {
            return false;
        }
        class_364 class_3642 = this.currentInvInfo.screen().method_25399();
        if (!(class_3642 instanceof class_342)) {
            return false;
        }
        class_342 box = (class_342)class_3642;
        if (this.screenContextMap.values().stream().anyMatch(screenContext -> screenContext.renderables().stream().filter(eventListener -> eventListener instanceof class_342).anyMatch(eventListener -> ((class_342)eventListener).method_25369().equals((Object)box.method_25369())))) {
            return true;
        }
        return this.screenContextMap.values().stream().anyMatch(screenContext -> screenContext.nonRenderables().stream().filter(eventListener -> eventListener instanceof class_342).anyMatch(eventListener -> ((class_342)eventListener).method_25369().equals((Object)box.method_25369())));
    }

    public HashMap<AbstractEivOverlay, AbstractEivOverlay.ScreenContext> screenContextMap() {
        return this.screenContextMap;
    }

    public List<class_364> oldWidgets() {
        return this.oldWidgets;
    }

    public boolean keyPressed(int i, int j, int k) {
        boolean b = false;
        if (CommonEIVClient.TOGGLE_OVERLAY_KEYBIND.method_1417(i, j)) {
            PRESENT_OVERLAYS.forEach(abstractEivOverlay -> abstractEivOverlay.setEnabled(!abstractEivOverlay.isEnabled()));
            return true;
        }
        for (AbstractEivOverlay overlay : PRESENT_OVERLAYS) {
            if (!overlay.isEnabled() || !overlay.isEnoughSpaceToRender() || !overlay.keyPressed(i, j, k)) continue;
            b = true;
        }
        return b;
    }

    public boolean charTyped(char c, int i) {
        boolean b = false;
        for (AbstractEivOverlay overlay : PRESENT_OVERLAYS) {
            if (!overlay.isEnabled() || !overlay.isEnoughSpaceToRender() || !overlay.charTyped(c, i)) continue;
            b = true;
        }
        return b;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean b = false;
        this.screenContextMap.forEach((abstractEivOverlay, screenContext) -> screenContext.renderables().forEach(guiEventListener -> {
            if (guiEventListener.method_25370() && !guiEventListener.method_25405(mouseX, mouseY)) {
                guiEventListener.method_25365(false);
            }
        }));
        for (AbstractEivOverlay overlay : PRESENT_OVERLAYS) {
            if (!overlay.isEnabled() || !overlay.isEnoughSpaceToRender() || !(mouseX >= (double)overlay.getX()) || !(mouseX <= (double)(overlay.getX() + overlay.getWidth())) || !(mouseY >= (double)overlay.getY()) || !(mouseY <= (double)(overlay.getY() + overlay.getHeight())) || !overlay.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            b = true;
        }
        return b;
    }

    public boolean scrollMouse(double mouseX, double mouseY, double scrolledX, double scrolledY) {
        boolean b = false;
        for (AbstractEivOverlay overlay : PRESENT_OVERLAYS) {
            if (!overlay.isEnabled() || !overlay.isEnoughSpaceToRender() || !(mouseX >= (double)overlay.getX()) || !(mouseX <= (double)(overlay.getX() + overlay.getWidth())) || !(mouseY >= (double)overlay.getY()) || !(mouseY <= (double)(overlay.getY() + overlay.getHeight())) || !overlay.scrollMouse(mouseX, mouseY, scrolledX, scrolledY)) continue;
            b = true;
        }
        return b;
    }

    public void renderAllBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (Configs.CLIENT_SETTINGS.drawBackground()) {
            PRESENT_OVERLAYS.stream().filter(AbstractEivOverlay::isEnabled).filter(AbstractEivOverlay::isEnoughSpaceToRender).forEach(overlay -> overlay.renderBackground(guiGraphics, mouseX, mouseY, partialTicks));
        }
    }

    public void renderAll(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PRESENT_OVERLAYS.stream().filter(AbstractEivOverlay::isEnabled).filter(AbstractEivOverlay::isEnoughSpaceToRender).forEach(overlay -> overlay.render(guiGraphics, mouseX, mouseY, partialTicks));
        if (class_310.method_1551().field_1705.method_53531().method_53536()) {
            this.renderDebug(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderDebug(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.guiBlockings.forEach(blockingGuiComponent -> {
            Random rand = new Random(blockingGuiComponent.id().toString().chars().sum());
            int debugColor = new Color(rand.nextInt(256), rand.nextInt(256), rand.nextInt(256)).getRGB();
            guiGraphics.method_51738(blockingGuiComponent.x(), blockingGuiComponent.x() + blockingGuiComponent.width(), blockingGuiComponent.y(), debugColor);
            guiGraphics.method_51738(blockingGuiComponent.x(), blockingGuiComponent.x() + blockingGuiComponent.width(), blockingGuiComponent.y() + blockingGuiComponent.height(), debugColor);
            guiGraphics.method_51742(blockingGuiComponent.x(), blockingGuiComponent.y(), blockingGuiComponent.y() + blockingGuiComponent.height(), debugColor);
            guiGraphics.method_51742(blockingGuiComponent.x() + blockingGuiComponent.width(), blockingGuiComponent.y(), blockingGuiComponent.y() + blockingGuiComponent.height(), debugColor);
        });
    }

    public void removeGuiBlocking(class_2960 id, boolean updateOverlays) {
        this.guiBlockings.removeIf(blockingGuiComponent -> blockingGuiComponent.id().equals((Object)id));
        if (updateOverlays) {
            this.updateOverlaysAndWidgets();
        }
    }

    public void removeGuiBlocking(Predicate<class_2960> filter, boolean updateOverlays) {
        this.guiBlockings.removeIf(blockingGuiComponent -> filter.test(blockingGuiComponent.id()));
        if (updateOverlays) {
            this.updateOverlaysAndWidgets();
        }
    }

    public void setGuiBlocking(BlockingGuiComponent comp) {
        ArrayList<BlockingGuiComponent> old = new ArrayList<BlockingGuiComponent>(this.guiBlockings);
        this.removeGuiBlocking(comp.id(), false);
        this.guiBlockings.add(comp);
        if (!new HashSet<BlockingGuiComponent>(old).containsAll(this.guiBlockings) || old.size() != this.guiBlockings.size()) {
            this.updateOverlaysAndWidgets();
        }
    }

    public List<BlockingGuiComponent> allGuiBlockings() {
        return this.guiBlockings;
    }

    public static void registerOverlay(AbstractEivOverlay overlay) {
        PRESENT_OVERLAYS.add(overlay);
    }
}

