/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe;

import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.network.payload.recipe.ClientboundCacheStartPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundFinishUpdatesPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundStartUpdatesPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdateEndPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdatePayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdateStartPayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundFinishStackSensitivesPayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundStackSensitivePayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundStartStackSensitivesPayload;
import de.crafty.eiv.common.recipe.ItemViewRecipes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class ServerRecipeManager {
    public static final ServerRecipeManager INSTANCE = new ServerRecipeManager();
    private static final HashMap<EivRecipeType<?>, List<ServerRecipeEntry>> PRESENT_RECIPES = new LinkedHashMap();
    private MinecraftServer server;
    private class_1863 recipeManager;

    private ServerRecipeManager() {
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
        this.reload();
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void setRecipeManager(class_1863 recipeManager) {
        this.recipeManager = recipeManager;
    }

    public class_1863 getVanillaRecipeManager() {
        return this.recipeManager;
    }

    public <T extends class_1860<?>> List<T> getRecipesForType(class_3956<T> recipeType) {
        return this.recipeManager.method_8126().stream().filter(holder -> holder.comp_1933().method_17716().equals((Object)recipeType)).map(class_8786::comp_1933).toList();
    }

    public void reload() {
        if (this.server == null || this.recipeManager == null) {
            return;
        }
        CommonEIV.LOGGER.info("Reloading all Recipes...");
        ItemView.getStackSensitive().clear();
        ItemView.getReloadCallbacks().forEach(ItemView.ReloadCallback::onReload);
        this.informAboutStackSensitives();
        this.reloadRecipes();
        this.broadcastAllRecipes();
    }

    public void informAboutStackSensitives() {
        if (this.server == null) {
            return;
        }
        ArrayList collected = new ArrayList();
        ItemView.getStackSensitive().forEach((item, stackSensitives) -> collected.addAll(stackSensitives));
        CommonEIV.LOGGER.info("Broadcasting Stack-Sensitives...");
        CommonEIV.LOGGER.info("Updating {} players...", (Object)this.server.method_3760().method_14571().size());
        this.server.method_3760().method_14571().forEach(player -> {
            CommonEIV.networkManager().sendPacket((class_3222)player, new ClientboundStartStackSensitivesPayload(collected.size()));
            collected.forEach(stackSensitive -> CommonEIV.networkManager().sendPacket((class_3222)player, new ClientboundStackSensitivePayload((ItemView.StackSensitive)stackSensitive)));
            CommonEIV.networkManager().sendPacket((class_3222)player, new ClientboundFinishStackSensitivesPayload());
        });
    }

    public void reloadRecipes() {
        PRESENT_RECIPES.clear();
        ArrayList serverRecipes = new ArrayList();
        ItemViewRecipes.INSTANCE.getRecipeProviders().forEach(serverModRecipeProvider -> {
            ArrayList<IEivServerRecipe> recipes = new ArrayList<IEivServerRecipe>();
            serverModRecipeProvider.provide(recipes);
            serverRecipes.addAll(recipes);
        });
        serverRecipes.forEach(iEivServerModRecipe -> {
            class_2960 typeId = iEivServerModRecipe.getRecipeType().getId();
            List list = PRESENT_RECIPES.getOrDefault(iEivServerModRecipe.getRecipeType(), new ArrayList());
            list.add(new ServerRecipeEntry(class_2960.method_60655((String)typeId.method_12836(), (String)(typeId.method_12832() + "/" + String.valueOf(UUID.randomUUID()))), (IEivServerRecipe)iEivServerModRecipe));
            PRESENT_RECIPES.put(iEivServerModRecipe.getRecipeType(), list);
        });
    }

    public void broadcastAllRecipes() {
        if (this.server == null) {
            return;
        }
        CommonEIV.LOGGER.info("Broadcasting recipes...");
        this.server.method_3760().method_14571().forEach(this::informAboutRecipes);
    }

    public void informAboutRecipes(class_3222 serverPlayer) {
        if (PRESENT_RECIPES.isEmpty()) {
            return;
        }
        CommonEIV.LOGGER.info("Informing {} about {} recipe types", (Object)serverPlayer.method_5477(), (Object)PRESENT_RECIPES.size());
        CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundStartUpdatesPayload());
        CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundCacheStartPayload(PRESENT_RECIPES.size()));
        PRESENT_RECIPES.forEach((type, entries) -> {
            CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundTypeUpdateStartPayload((EivRecipeType<?>)type, entries.size()));
            entries.forEach(recipe -> CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundTypeUpdatePayload((ServerRecipeEntry)recipe)));
            CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundTypeUpdateEndPayload((EivRecipeType<?>)type));
        });
        CommonEIV.networkManager().sendPacket(serverPlayer, new ClientboundFinishUpdatesPayload());
    }

    public void performRecipeTransfer(class_3222 player, HashMap<Integer, Integer> transferMap, HashMap<Integer, HashMap<Integer, class_1799>> usedPlayerSlots) {
        transferMap.forEach((recipeSlot, destSlot) -> {
            HashMap<Integer, class_1799> usedSlots = usedPlayerSlots.getOrDefault(recipeSlot, new HashMap());
            usedSlots.forEach((playerSlot, stack) -> {
                class_1799 currentInDest = player.field_7512.method_7611(destSlot.intValue()).method_7677();
                if (currentInDest.method_7960()) {
                    player.field_7512.method_7611(destSlot.intValue()).method_7673(player.method_31548().method_5434(playerSlot.intValue(), stack.method_7947()));
                } else {
                    player.field_7512.method_7611(destSlot.intValue()).method_7673(currentInDest.method_46651(currentInDest.method_7947() + player.method_31548().method_5434(playerSlot.intValue(), stack.method_7947()).method_7947()));
                }
            });
        });
    }

    public record ServerRecipeEntry(class_2960 modRecipeId, IEivServerRecipe recipe) {
        public static final class_9139<class_2540, ServerRecipeEntry> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, entry -> entry.modRecipeId().toString(), (class_9139)class_9135.field_48556, ServerRecipeEntry::createFullTag, (s, compoundTag) -> new ServerRecipeEntry(class_2960.method_12829((String)s), ServerRecipeEntry.fromTag(compoundTag)));

        public <T extends IEivServerRecipe> T asWrapped() {
            return (T)this.recipe;
        }

        private class_2487 createFullTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("recipeType", this.recipe().getRecipeType().getId().toString());
            class_2487 dataTag = new class_2487();
            this.recipe().writeToTag(dataTag);
            tag.method_10566("recipeData", (class_2520)dataTag);
            return tag;
        }

        private static IEivServerRecipe fromTag(class_2487 tag) {
            if (!tag.method_10545("recipeType")) {
                return null;
            }
            EivRecipeType<?> recipeType = EivRecipeType.byId(class_2960.method_60654((String)((String)tag.method_10558("recipeType").orElseThrow())));
            if (recipeType == null) {
                return null;
            }
            Object modRecipe = recipeType.getEmptyConstructor().construct();
            modRecipe.loadFromTag(tag.method_10562("recipeData").orElseGet(class_2487::new));
            return modRecipe;
        }
    }
}

