/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe;

import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.material.Fluid;

public class ItemViewRecipes {
    public static final ItemViewRecipes INSTANCE = new ItemViewRecipes();
    private final HashMap<EivRecipeType<?>, ClientRecipeWrapper<?>> recipeWrappers = new HashMap();
    private final List<ServerRecipeProvider> recipeProviders = new ArrayList<ServerRecipeProvider>();
    private final HashMap<Fluid, Item> fluidItemMap = new HashMap();

    private ItemViewRecipes() {
    }

    @Deprecated
    public <T extends IEivServerRecipe> void registerRecipeWrapper(EivRecipeType<T> recipeType, ClientRecipeWrapper<T> wrapper) {
        this.recipeWrappers.put(recipeType, wrapper);
    }

    @Deprecated
    public void addRecipeProvider(ServerRecipeProvider provider) {
        this.recipeProviders.add(provider);
    }

    public HashMap<EivRecipeType<?>, ClientRecipeWrapper<?>> wrapperMap() {
        return this.recipeWrappers;
    }

    public List<ServerRecipeProvider> getRecipeProviders() {
        return this.recipeProviders;
    }

    public void setFluidItemMap(HashMap<Fluid, Item> fluidItemMap) {
        this.fluidItemMap.clear();
        this.fluidItemMap.putAll(fluidItemMap);
    }

    public Item itemForFluid(Fluid fluid) {
        return this.fluidItemMap.getOrDefault(fluid, Items.AIR);
    }

    public static boolean makePotionRedirectCheck(ItemStack stack, List<SlotContent> slotContents) {
        if (!stack.has(DataComponents.POTION_CONTENTS)) {
            return true;
        }
        for (SlotContent slotContent : slotContents) {
            for (ItemStack validStack : slotContent.getValidContents()) {
                if (!stack.is(validStack.getItem()) || !ItemViewRecipes.makePotionCheck(stack, validStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean makeEnchantedRedirectCheck(ItemStack stack, List<SlotContent> slotContents) {
        if (!stack.has(DataComponents.ENCHANTMENTS)) {
            return true;
        }
        for (SlotContent slotContent : slotContents) {
            for (ItemStack validStack : slotContent.getValidContents()) {
                if (!stack.is(validStack.getItem()) || !ItemViewRecipes.makeEnchantmentCheck(stack, validStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean makePotionCheck(ItemStack stack1, ItemStack stack2) {
        if (!stack1.has(DataComponents.POTION_CONTENTS) || !stack2.has(DataComponents.POTION_CONTENTS)) {
            return true;
        }
        PotionContents contents = (PotionContents)stack1.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        PotionContents stackContents = (PotionContents)stack2.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return contents.potion().isPresent() && stackContents.potion().isPresent() && contents.is((Holder)stackContents.potion().orElseThrow());
    }

    public static boolean makeEnchantmentCheck(ItemStack stack1, ItemStack stack2) {
        if (!stack1.has(DataComponents.ENCHANTMENTS) || !stack2.has(DataComponents.ENCHANTMENTS)) {
            return true;
        }
        ItemEnchantments enchantments = (ItemEnchantments)stack1.getOrDefault(stack1.is(Items.ENCHANTED_BOOK) ? DataComponents.STORED_ENCHANTMENTS : DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments stackEnchantments = (ItemEnchantments)stack2.getOrDefault(stack2.is(Items.ENCHANTED_BOOK) ? DataComponents.STORED_ENCHANTMENTS : DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        return enchantments.keySet().stream().allMatch(enchantment -> stackEnchantments.getLevel(enchantment) == enchantments.getLevel(enchantment)) && stackEnchantments.size() == enchantments.size();
    }

    public static interface ServerRecipeProvider {
        public void provide(List<IEivServerRecipe> var1);
    }

    public static interface ClientRecipeWrapper<T extends IEivServerRecipe> {
        public List<? extends IEivViewRecipe> wrap(T var1);
    }
}

