/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe.util;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import de.crafty.eiv.common.mixin.world.item.crafting.IngredientAccessor;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class EivTagUtil {
    private static <T> class_2499 createRegistryList(List<T> objects, class_7922<T> registry) {
        class_2499 list = new class_2499();
        objects.stream().map(t -> class_2519.method_23256((String)EivTagUtil.registryToString(t, registry))).forEach(arg_0 -> list.add(arg_0));
        return list;
    }

    private static <T> List<T> reconstructRegistryList(class_2487 srcTag, String key, class_7922<T> registry) {
        return srcTag.method_68569(key).stream().map(class_2520::method_68658).map(s -> EivTagUtil.stringToRegistry((String)s.orElseThrow(), registry)).toList();
    }

    public static class_1799 decodeItemStackOnClient(class_2487 tag) {
        return class_1799.field_24671.parse((DynamicOps)class_310.method_1551().field_1724.method_37908().method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)tag).result().orElse(class_1799.field_8037);
    }

    public static class_2487 encodeItemStackOnClient(class_1799 stack) {
        return (class_2487)class_1799.field_24671.encode((Object)stack, (DynamicOps)class_310.method_1551().field_1724.method_37908().method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)new class_2487()).mapOrElse(tag -> tag.method_68571().orElseGet(class_2487::new), tagError -> new class_2487());
    }

    public static class_2487 encodeItemStackOnServer(class_1799 stack) {
        return (class_2487)class_1799.field_24671.encode((Object)stack, (DynamicOps)ServerRecipeManager.INSTANCE.getServer().method_30611().method_57093((DynamicOps)class_2509.field_11560), (Object)new class_2487()).mapOrElse(tag -> tag.method_68571().orElseGet(class_2487::new), tagError -> new class_2487());
    }

    public static class_1799 decodeItemStackOnServer(class_2487 tag) {
        return class_1799.field_24671.parse((DynamicOps)ServerRecipeManager.INSTANCE.getServer().method_30611().method_57093((DynamicOps)class_2509.field_11560), (Object)tag).result().orElse(class_1799.field_8037);
    }

    public static class_2487 writeIngredient(class_1856 ingredient) {
        if (ingredient == null) {
            return new class_2487();
        }
        Either ingredientContent = ((IngredientAccessor)ingredient).getValues().method_40248();
        class_2487 tag = new class_2487();
        if (ingredientContent.left().isPresent()) {
            tag.method_10582("tag", ((class_6862)ingredientContent.left().get()).comp_327().toString());
            return tag;
        }
        tag.method_10566("items", (class_2520)EivTagUtil.createItemList(ingredient.method_8105().map(class_6880::comp_349).toList()));
        return tag;
    }

    public static class_1856 readIngredient(class_2487 tag) {
        if (tag.method_33133()) {
            return null;
        }
        if (tag.method_10545("tag")) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)tag.method_68564("tag", "")));
            return class_1856.method_8106((class_6885)((class_6885)Objects.requireNonNull(class_7923.field_41178.method_46733(tagKey).orElse(null))));
        }
        List<class_6880> itemList = EivTagUtil.reconstructItemList(tag, "items").stream().map(class_6880::method_40223).toList();
        return class_1856.method_8106((class_6885)class_6885.method_40242(itemList));
    }

    public static class_2499 createItemList(List<class_1792> items) {
        return EivTagUtil.createRegistryList(items, class_7923.field_41178);
    }

    public static List<class_1792> reconstructItemList(class_2487 srcTag, String key) {
        return EivTagUtil.reconstructRegistryList(srcTag, key, class_7923.field_41178);
    }

    public static class_2499 createBlockList(List<class_2248> items) {
        return EivTagUtil.createRegistryList(items, class_7923.field_41175);
    }

    public static List<class_2248> reconstructBlockList(class_2487 srcTag, String key) {
        return EivTagUtil.reconstructRegistryList(srcTag, key, class_7923.field_41175);
    }

    public static class_2499 createFluidList(List<class_3611> items) {
        return EivTagUtil.createRegistryList(items, class_7923.field_41173);
    }

    public static List<class_3611> reconstructFluidList(class_2487 srcTag, String key) {
        return EivTagUtil.reconstructRegistryList(srcTag, key, class_7923.field_41173);
    }

    public static <T> class_2499 writeList(List<T> list, CompoundBuilder<T> builder) {
        class_2499 tagList = new class_2499();
        list.stream().map(t -> builder.buildSingle(t, new class_2487())).forEach(arg_0 -> tagList.add(arg_0));
        return tagList;
    }

    public static <T> List<T> readList(class_2487 srcTag, String key, CompoundReconstructor<T> builder) {
        return srcTag.method_68569(key).stream().map(class_2520::method_68571).map(compoundTag -> builder.reconstructSingle(compoundTag.orElseGet(class_2487::new))).toList();
    }

    private static <T> String registryToString(T object, class_7922<T> registry) {
        return registry.method_10221(object).toString();
    }

    private static <T> T stringToRegistry(String string, class_7922<T> registry) {
        return (T)registry.method_63535(class_2960.method_60654((String)string));
    }

    public static String itemToString(class_1792 item) {
        return EivTagUtil.registryToString(item, class_7923.field_41178);
    }

    public static class_1792 itemFromString(String s) {
        return (class_1792)EivTagUtil.stringToRegistry(s, class_7923.field_41178);
    }

    public static String blockToString(class_2248 block) {
        return EivTagUtil.registryToString(block, class_7923.field_41175);
    }

    public static class_2248 blockFromString(String s) {
        return (class_2248)EivTagUtil.stringToRegistry(s, class_7923.field_41175);
    }

    public static String fluidToString(class_3611 fluid) {
        return EivTagUtil.registryToString(fluid, class_7923.field_41173);
    }

    public static class_3611 fluidFromString(String s) {
        return (class_3611)EivTagUtil.stringToRegistry(s, class_7923.field_41173);
    }

    public static interface CompoundBuilder<T> {
        public class_2487 buildSingle(T var1, class_2487 var2);
    }

    public static interface CompoundReconstructor<T> {
        public T reconstructSingle(class_2487 var1);
    }
}

