/*
 * Decompiled with CFR 0.152.
 */
package org.hendrix.bettercopperage.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_10710;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7430;
import net.minecraft.class_7444;
import net.minecraft.class_7445;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import org.hendrix.bettercopperage.core.BCAInstruments;
import org.hendrix.bettercopperage.core.BCATags;
import org.hendrix.bettercopperage.utils.RegistryUtils;

public final class CopperHornItem
extends class_7430 {
    private static final Supplier<BiMap<class_5321<class_7444>, class_5321<class_7444>>> UPGRADABLE_INSTRUMENTS = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)class_7445.field_39126, BCAInstruments.GREAT_SKY_FALLING_COPPER_HORN).put((Object)class_7445.field_39127, BCAInstruments.OLD_HYMN_RESTING_COPPER_HORN).put((Object)class_7445.field_39128, BCAInstruments.PURE_WATER_DESIRE_COPPER_HORN).put((Object)class_7445.field_39129, BCAInstruments.MUMBLE_FIRE_MEMORY_COPPER_HORN).put((Object)class_7445.field_39130, BCAInstruments.DRY_URGE_ANGER_COPPER_HORN).put((Object)class_7445.field_39131, BCAInstruments.CLEAR_TEMPER_JOURNEY_COPPER_HORN).put((Object)class_7445.field_39132, BCAInstruments.FRESH_NEST_THOUGHT_COPPER_HORN).put((Object)class_7445.field_39133, BCAInstruments.SECRET_LAKE_TEAR_COPPER_HORN).put(BCAInstruments.FLY_GOAT_HORN, BCAInstruments.FEARLESS_RIVER_GIFT_COPPER_HORN).put(BCAInstruments.RESIST_GOAT_HORN, BCAInstruments.SWEET_MOON_LOVE_COPPER_HORN).build());
    private static final Supplier<BiMap<class_5321<class_7444>, class_5321<class_7444>>> INSTRUMENT_TO_BASS_INSTRUMENT = Suppliers.memoize(() -> ImmutableBiMap.builder().put(BCAInstruments.GREAT_SKY_FALLING_COPPER_HORN, BCAInstruments.GREAT_SKY_FALLING_COPPER_HORN_BASS).put(BCAInstruments.OLD_HYMN_RESTING_COPPER_HORN, BCAInstruments.OLD_HYMN_RESTING_COPPER_HORN_BASS).put(BCAInstruments.PURE_WATER_DESIRE_COPPER_HORN, BCAInstruments.PURE_WATER_DESIRE_COPPER_HORN_BASS).put(BCAInstruments.MUMBLE_FIRE_MEMORY_COPPER_HORN, BCAInstruments.MUMBLE_FIRE_MEMORY_COPPER_HORN_BASS).put(BCAInstruments.DRY_URGE_ANGER_COPPER_HORN, BCAInstruments.DRY_URGE_ANGER_COPPER_HORN_BASS).put(BCAInstruments.CLEAR_TEMPER_JOURNEY_COPPER_HORN, BCAInstruments.CLEAR_TEMPER_JOURNEY_COPPER_HORN_BASS).put(BCAInstruments.FRESH_NEST_THOUGHT_COPPER_HORN, BCAInstruments.FRESH_NEST_THOUGHT_COPPER_HORN_BASS).put(BCAInstruments.SECRET_LAKE_TEAR_COPPER_HORN, BCAInstruments.SECRET_LAKE_TEAR_COPPER_HORN_BASS).put(BCAInstruments.FEARLESS_RIVER_GIFT_COPPER_HORN, BCAInstruments.FEARLESS_RIVER_GIFT_COPPER_HORN_BASS).put(BCAInstruments.SWEET_MOON_LOVE_COPPER_HORN, BCAInstruments.SWEET_MOON_LOVE_COPPER_HORN_BASS).build());
    private static final Supplier<BiMap<class_5321<class_7444>, class_5321<class_7444>>> INSTRUMENT_TO_HARMONY_INSTRUMENT = Suppliers.memoize(() -> ImmutableBiMap.builder().put(BCAInstruments.GREAT_SKY_FALLING_COPPER_HORN, BCAInstruments.GREAT_SKY_FALLING_COPPER_HORN_HARMONY).put(BCAInstruments.OLD_HYMN_RESTING_COPPER_HORN, BCAInstruments.OLD_HYMN_RESTING_COPPER_HORN_HARMONY).put(BCAInstruments.PURE_WATER_DESIRE_COPPER_HORN, BCAInstruments.PURE_WATER_DESIRE_COPPER_HORN_HARMONY).put(BCAInstruments.MUMBLE_FIRE_MEMORY_COPPER_HORN, BCAInstruments.MUMBLE_FIRE_MEMORY_COPPER_HORN_HARMONY).put(BCAInstruments.DRY_URGE_ANGER_COPPER_HORN, BCAInstruments.DRY_URGE_ANGER_COPPER_HORN_HARMONY).put(BCAInstruments.CLEAR_TEMPER_JOURNEY_COPPER_HORN, BCAInstruments.CLEAR_TEMPER_JOURNEY_COPPER_HORN_HARMONY).put(BCAInstruments.FRESH_NEST_THOUGHT_COPPER_HORN, BCAInstruments.FRESH_NEST_THOUGHT_COPPER_HORN_HARMONY).put(BCAInstruments.SECRET_LAKE_TEAR_COPPER_HORN, BCAInstruments.SECRET_LAKE_TEAR_COPPER_HORN_HARMONY).put(BCAInstruments.FEARLESS_RIVER_GIFT_COPPER_HORN, BCAInstruments.FEARLESS_RIVER_GIFT_COPPER_HORN_HARMONY).put(BCAInstruments.SWEET_MOON_LOVE_COPPER_HORN, BCAInstruments.SWEET_MOON_LOVE_COPPER_HORN_HARMONY).build());

    public CopperHornItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        Optional<class_6880<class_7444>> optionalInstrument = this.getInstrument(itemStack, (class_7225.class_7874)player.method_56673(), this.getInstrumentTagKey(player));
        if (optionalInstrument.isPresent()) {
            class_7444 instrument = (class_7444)optionalInstrument.get().comp_349();
            player.method_6019(hand);
            CopperHornItem.playSound(world, player, instrument);
            player.method_7357().method_62835(itemStack, class_3532.method_15375((float)(instrument.comp_773() * 20.0f)));
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1269.field_21466;
        }
        return class_1269.field_5814;
    }

    private Optional<class_6880<class_7444>> getInstrument(class_1799 stack, class_7225.class_7874 registryWrapperLookup, class_6862<class_7444> instrumentTagKey) {
        Optional<class_7444> instrument;
        Optional<class_5321<class_7444>> optionalInstrumentKey;
        class_10710 instrumentComponent = (class_10710)stack.method_58694(class_9334.field_49612);
        class_6880 registryEntry = null;
        if (instrumentComponent != null && (registryEntry = (class_6880)instrumentComponent.method_67211(registryWrapperLookup).orElse(null)) != null && (optionalInstrumentKey = this.getInstrumentRegistryKey((class_6880<class_7444>)registryEntry, instrumentTagKey)).isPresent() && (instrument = RegistryUtils.getValue(registryWrapperLookup, class_7924.field_41275, optionalInstrumentKey.get())).isPresent()) {
            return Optional.of(class_6880.method_40223((Object)instrument.get()));
        }
        return Optional.ofNullable(registryEntry);
    }

    private Optional<class_5321<class_7444>> getInstrumentRegistryKey(class_6880<class_7444> baseInstrument, class_6862<class_7444> instrumentTagKey) {
        return baseInstrument.method_40230().flatMap(instrument -> {
            if (instrumentTagKey.equals(BCATags.InstrumentTags.BASS_COPPER_HORNS)) {
                return Optional.ofNullable((class_5321)INSTRUMENT_TO_BASS_INSTRUMENT.get().get(instrument));
            }
            if (instrumentTagKey.equals(BCATags.InstrumentTags.HARMONY_COPPER_HORNS)) {
                return Optional.ofNullable((class_5321)INSTRUMENT_TO_HARMONY_INSTRUMENT.get().get(instrument));
            }
            return Optional.of(instrument);
        });
    }

    private class_6862<class_7444> getInstrumentTagKey(class_1657 player) {
        return player.method_5715() ? BCATags.InstrumentTags.BASS_COPPER_HORNS : (player.method_36455() <= -85.0f && player.method_36455() >= -90.0f ? BCATags.InstrumentTags.HARMONY_COPPER_HORNS : BCATags.InstrumentTags.MELODY_COPPER_HORNS);
    }

    private static void playSound(class_1937 world, class_1657 player, class_7444 instrument) {
        world.method_43129((class_1297)player, (class_1297)player, (class_3414)instrument.comp_772().comp_349(), class_3419.field_15247, instrument.comp_774() / 16.0f, 1.0f);
        world.method_43276((class_6880)class_5712.field_39415, player.method_24515(), class_5712.class_7397.method_43285((class_1297)player));
    }

    public static void upgradeInstrument(class_1799 stack, class_7225.class_7874 registryWrapperLookup, class_10710 baseInstrument) {
        baseInstrument.comp_3598().method_67385().ifPresent(baseInstrumentKey -> {
            class_5321<class_7444> instrument = CopperHornItem.getUpgradedInstrument((class_5321<class_7444>)baseInstrumentKey).orElse(BCAInstruments.GREAT_SKY_FALLING_COPPER_HORN);
            CopperHornItem.getInstrumentRegistry(registryWrapperLookup).method_46746(instrument).ifPresent(upgradedInstrument -> stack.method_57379(class_9334.field_49612, (Object)new class_10710(class_6880.method_40223((Object)((class_7444)upgradedInstrument.comp_349())))));
        });
    }

    private static Optional<class_5321<class_7444>> getUpgradedInstrument(class_5321<class_7444> baseInstrument) {
        return Optional.ofNullable((class_5321)UPGRADABLE_INSTRUMENTS.get().get(baseInstrument));
    }

    private static class_7225.class_7226<class_7444> getInstrumentRegistry(class_7225.class_7874 registryWrapperLookup) {
        return RegistryUtils.getRegistry(registryWrapperLookup, class_7924.field_41275);
    }
}

