/*
 * Decompiled with CFR 0.152.
 */
package org.hendrix.bettercopperage.core;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2378;
import net.minecraft.class_2389;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3749;
import net.minecraft.class_4970;
import net.minecraft.class_5172;
import net.minecraft.class_5955;
import net.minecraft.class_7923;
import net.minecraft.class_8177;
import net.minecraft.class_9009;
import org.hendrix.bettercopperage.block.CopperButtonBlock;
import org.hendrix.bettercopperage.block.CopperCampfireBlock;
import org.hendrix.bettercopperage.block.CopperFireBlock;
import org.hendrix.bettercopperage.block.CopperRailBlock;
import org.hendrix.bettercopperage.block.MediumWeightedPressurePlateBlock;
import org.hendrix.bettercopperage.block.OxidizableCopperButtonBlock;
import org.hendrix.bettercopperage.block.OxidizableCopperRailBlock;
import org.hendrix.bettercopperage.block.OxidizableMediumWeightedPressurePlateBlock;
import org.hendrix.bettercopperage.core.BCAItems;
import org.hendrix.bettercopperage.utils.BlockUtils;
import org.hendrix.bettercopperage.utils.IdentifierUtils;
import org.hendrix.bettercopperage.utils.RegistryKeyUtils;

public final class BCABlocks {
    public static final class_2248 COPPER_BUTTON = BCABlocks.registerCopperButton(class_5955.class_5811.field_28704, false);
    public static final class_2248 EXPOSED_COPPER_BUTTON = BCABlocks.registerCopperButton(class_5955.class_5811.field_28705, false);
    public static final class_2248 WEATHERED_COPPER_BUTTON = BCABlocks.registerCopperButton(class_5955.class_5811.field_28706, false);
    public static final class_2248 OXIDIZED_COPPER_BUTTON = BCABlocks.registerCopperButton(class_5955.class_5811.field_28707, false);
    public static final class_2248 WAXED_COPPER_BUTTON = BCABlocks.registerCopperButton(class_5955.class_5811.field_28704, true);
    public static final class_2248 WAXED_EXPOSED_COPPER_BUTTON = BCABlocks.registerCopperButton(class_5955.class_5811.field_28705, true);
    public static final class_2248 WAXED_WEATHERED_COPPER_BUTTON = BCABlocks.registerCopperButton(class_5955.class_5811.field_28706, true);
    public static final class_2248 WAXED_OXIDIZED_COPPER_BUTTON = BCABlocks.registerCopperButton(class_5955.class_5811.field_28707, true);
    public static final class_2248 MEDIUM_WEIGHTED_PRESSURE_PLATE = BCABlocks.registerCopperPressurePlate(class_5955.class_5811.field_28704, false);
    public static final class_2248 EXPOSED_MEDIUM_WEIGHTED_PRESSURE_PLATE = BCABlocks.registerCopperPressurePlate(class_5955.class_5811.field_28705, false);
    public static final class_2248 WEATHERED_MEDIUM_WEIGHTED_PRESSURE_PLATE = BCABlocks.registerCopperPressurePlate(class_5955.class_5811.field_28706, false);
    public static final class_2248 OXIDIZED_MEDIUM_WEIGHTED_PRESSURE_PLATE = BCABlocks.registerCopperPressurePlate(class_5955.class_5811.field_28707, false);
    public static final class_2248 WAXED_MEDIUM_WEIGHTED_PRESSURE_PLATE = BCABlocks.registerCopperPressurePlate(class_5955.class_5811.field_28704, true);
    public static final class_2248 WAXED_EXPOSED_MEDIUM_WEIGHTED_PRESSURE_PLATE = BCABlocks.registerCopperPressurePlate(class_5955.class_5811.field_28705, true);
    public static final class_2248 WAXED_WEATHERED_MEDIUM_WEIGHTED_PRESSURE_PLATE = BCABlocks.registerCopperPressurePlate(class_5955.class_5811.field_28706, true);
    public static final class_2248 WAXED_OXIDIZED_MEDIUM_WEIGHTED_PRESSURE_PLATE = BCABlocks.registerCopperPressurePlate(class_5955.class_5811.field_28707, true);
    public static final class_2248 COPPER_RAIL = BCABlocks.registerCopperRail(class_5955.class_5811.field_28704, false);
    public static final class_2248 EXPOSED_COPPER_RAIL = BCABlocks.registerCopperRail(class_5955.class_5811.field_28705, false);
    public static final class_2248 WEATHERED_COPPER_RAIL = BCABlocks.registerCopperRail(class_5955.class_5811.field_28706, false);
    public static final class_2248 OXIDIZED_COPPER_RAIL = BCABlocks.registerCopperRail(class_5955.class_5811.field_28707, false);
    public static final class_2248 WAXED_COPPER_RAIL = BCABlocks.registerCopperRail(class_5955.class_5811.field_28704, true);
    public static final class_2248 WAXED_EXPOSED_COPPER_RAIL = BCABlocks.registerCopperRail(class_5955.class_5811.field_28705, true);
    public static final class_2248 WAXED_WEATHERED_COPPER_RAIL = BCABlocks.registerCopperRail(class_5955.class_5811.field_28706, true);
    public static final class_2248 WAXED_OXIDIZED_COPPER_RAIL = BCABlocks.registerCopperRail(class_5955.class_5811.field_28707, true);
    public static final class_2248 COPPER_FIRE = BCABlocks.registerCopperFire();
    public static final class_2248 COPPER_CAMPFIRE = BCABlocks.registerCopperCampfire();
    public static final class_2248 CHISELED_IRON = BCABlocks.registerChiseledBlock("iron", class_2246.field_10085);
    public static final class_2248 IRON_GRATE = BCABlocks.registerGrate("iron", class_3620.field_16005, class_2498.field_55794);
    public static final class_2248 CUT_IRON = BCABlocks.registerCutBlock("iron", class_2246.field_10085);
    public static final class_2248 CUT_IRON_SLAB = BCABlocks.registerCutSlab("iron", (Supplier<class_2248>)Suppliers.memoize(() -> CUT_IRON));
    public static final class_2248 CUT_IRON_STAIRS = BCABlocks.registerCutStairs("iron", (Supplier<class_2248>)Suppliers.memoize(() -> CUT_IRON));
    public static final class_2248 IRON_BUTTON = BCABlocks.registerButton("iron", class_8177.field_42819, 15);
    public static final class_2248 CHISELED_GOLD = BCABlocks.registerChiseledBlock("gold", class_2246.field_10205);
    public static final class_2248 GOLDEN_GRATE = BCABlocks.registerGrate("golden", class_3620.field_15994, class_2498.field_11533);
    public static final class_2248 CUT_GOLD = BCABlocks.registerCutBlock("gold", class_2246.field_10205);
    public static final class_2248 CUT_GOLDEN_SLAB = BCABlocks.registerCutSlab("golden", (Supplier<class_2248>)Suppliers.memoize(() -> CUT_GOLD));
    public static final class_2248 CUT_GOLDEN_STAIRS = BCABlocks.registerCutStairs("golden", (Supplier<class_2248>)Suppliers.memoize(() -> CUT_GOLD));
    public static final class_2248 GOLDEN_BARS = BCABlocks.registerGoldenBars();
    public static final class_2248 GOLDEN_CHAIN = BCABlocks.registerGoldenChain();
    public static final class_2248 GOLD_BUTTON = BCABlocks.registerButton("gold", class_8177.field_42820, 5);
    public static final class_2248 GOLDEN_DOOR = BCABlocks.registerGoldenDoor();
    public static final class_2248 GOLDEN_TRAPDOOR = BCABlocks.registerGoldenTrapdoor();
    public static final class_2248 GOLDEN_LANTERN = BCABlocks.registerGoldenLantern();

    private static class_2248 registerCopperButton(class_5955.class_5811 oxidationLevel, boolean isWaxed) {
        String name = BlockUtils.copperBlockName(oxidationLevel, isWaxed, "button");
        class_4970.class_2251 settings = BCABlocks.buttonSettings(name);
        return BCABlocks.registerBlock(name, (Supplier<class_2248>)Suppliers.memoize(() -> isWaxed ? new CopperButtonBlock(oxidationLevel, settings) : new OxidizableCopperButtonBlock(oxidationLevel, settings)));
    }

    private static class_2248 registerCopperPressurePlate(class_5955.class_5811 oxidationLevel, boolean isWaxed) {
        String name = BlockUtils.oxidizableBlockName(oxidationLevel, isWaxed, "medium_weighted", "pressure_plate");
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_31710(BlockUtils.oxidizableMapColor(oxidationLevel)).method_51369().method_9634().method_9632(0.5f).method_50012(class_3619.field_15971).method_63500(RegistryKeyUtils.block(name));
        return BCABlocks.registerBlock(name, (Supplier<class_2248>)Suppliers.memoize(() -> isWaxed ? new MediumWeightedPressurePlateBlock(oxidationLevel, settings) : new OxidizableMediumWeightedPressurePlateBlock(oxidationLevel, settings)));
    }

    private static class_2248 registerCopperRail(class_5955.class_5811 oxidationLevel, boolean isWaxed) {
        String name = BlockUtils.copperBlockName(oxidationLevel, isWaxed, "rail");
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_9634().method_9632(0.7f).method_9626(class_2498.field_11533).method_63500(RegistryKeyUtils.block(name));
        return BCABlocks.registerBlock(name, (Supplier<class_2248>)Suppliers.memoize(() -> isWaxed ? new CopperRailBlock(oxidationLevel, settings) : new OxidizableCopperRailBlock(oxidationLevel, settings)));
    }

    private static class_2248 registerCopperFire() {
        String name = "copper_fire";
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16001).method_51371().method_9634().method_9618().method_9631(state -> 13).method_9626(class_2498.field_11543).method_50012(class_3619.field_15971).method_63500(RegistryKeyUtils.block("copper_fire"));
        return BCABlocks.registerBlockWithoutBlockItem("copper_fire", (Supplier<class_2248>)Suppliers.memoize(() -> new CopperFireBlock(settings)));
    }

    private static class_2248 registerCopperCampfire() {
        String name = "copper_campfire";
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16017).method_51368(class_2766.field_12651).method_9632(2.0f).method_9626(class_2498.field_11547).method_9631(class_2246.method_26107((int)13)).method_22488().method_50013().method_63500(RegistryKeyUtils.block("copper_campfire"));
        return BCABlocks.registerBlock("copper_campfire", (Supplier<class_2248>)Suppliers.memoize(() -> new CopperCampfireBlock(settings)));
    }

    private static class_2248 registerButton(String materialName, class_8177 blockSetType, int pressTicks) {
        String name = materialName + "_button";
        class_4970.class_2251 settings = BCABlocks.buttonSettings(name);
        return BCABlocks.registerBlock(name, (Supplier<class_2248>)Suppliers.memoize(() -> new class_2269(blockSetType, pressTicks, settings)));
    }

    private static class_2248 registerGrate(String materialName, class_3620 mapColor, class_2498 soundGroup) {
        String name = materialName + "_grate";
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_9629(3.0f, 6.0f).method_9626(soundGroup).method_31710(mapColor).method_22488().method_29292().method_26235(class_2246::method_26114).method_26236(class_2246::method_26122).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_63500(RegistryKeyUtils.block(name));
        return BCABlocks.registerBlock(name, (Supplier<class_2248>)Suppliers.memoize(() -> new class_9009(settings)));
    }

    private static class_2248 registerCutBlock(String materialName, class_2248 sourceBlock) {
        String name = "cut_" + materialName;
        class_4970.class_2251 settings = class_4970.class_2251.method_9630((class_4970)sourceBlock).method_63500(RegistryKeyUtils.block(name));
        return BCABlocks.registerBlock(name, (Supplier<class_2248>)Suppliers.memoize(() -> new class_2248(settings)));
    }

    private static class_2248 registerChiseledBlock(String materialName, class_2248 sourceBlock) {
        String name = "chiseled_" + materialName;
        class_4970.class_2251 settings = class_4970.class_2251.method_9630((class_4970)sourceBlock).method_63500(RegistryKeyUtils.block(name));
        return BCABlocks.registerBlock(name, (Supplier<class_2248>)Suppliers.memoize(() -> new class_2248(settings)));
    }

    private static class_2248 registerCutSlab(String materialName, Supplier<class_2248> sourceBlockSupplier) {
        String name = "cut_" + materialName + "_slab";
        class_4970.class_2251 settings = class_4970.class_2251.method_9630((class_4970)((class_4970)sourceBlockSupplier.get())).method_63500(RegistryKeyUtils.block(name));
        return BCABlocks.registerBlock(name, (Supplier<class_2248>)Suppliers.memoize(() -> new class_2482(settings)));
    }

    private static class_2248 registerCutStairs(String materialName, Supplier<class_2248> sourceBlockSupplier) {
        String name = "cut_" + materialName + "_stairs";
        class_4970.class_2251 settings = class_4970.class_2251.method_9630((class_4970)((class_4970)sourceBlockSupplier.get())).method_63500(RegistryKeyUtils.block(name));
        return BCABlocks.registerBlock(name, (Supplier<class_2248>)Suppliers.memoize(() -> new class_2510(((class_2248)sourceBlockSupplier.get()).method_9564(), settings)));
    }

    private static class_2248 registerGoldenBars() {
        String name = "golden_bars";
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_29292().method_9629(5.0f, 6.0f).method_9626(class_2498.field_11533).method_22488().method_63500(RegistryKeyUtils.block("golden_bars"));
        return BCABlocks.registerBlock("golden_bars", (Supplier<class_2248>)Suppliers.memoize(() -> new class_2389(settings)));
    }

    private static class_2248 registerGoldenChain() {
        String name = "golden_chain";
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_51369().method_29292().method_9629(5.0f, 6.0f).method_9626(class_2498.field_24119).method_22488().method_63500(RegistryKeyUtils.block("golden_chain"));
        return BCABlocks.registerBlock("golden_chain", (Supplier<class_2248>)Suppliers.memoize(() -> new class_5172(settings)));
    }

    private static class_2248 registerGoldenDoor() {
        String name = "golden_door";
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15994).method_9632(5.0f).method_22488().method_50012(class_3619.field_15971).method_63500(RegistryKeyUtils.block("golden_door"));
        return BCABlocks.registerBlock("golden_door", (Supplier<class_2248>)Suppliers.memoize(() -> new class_2323(class_8177.field_42820, settings)));
    }

    private static class_2248 registerGoldenTrapdoor() {
        String name = "golden_trapdoor";
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15994).method_29292().method_9632(5.0f).method_22488().method_26235(class_2246::method_26114).method_63500(RegistryKeyUtils.block("golden_trapdoor"));
        return BCABlocks.registerBlock("golden_trapdoor", (Supplier<class_2248>)Suppliers.memoize(() -> new class_2533(class_8177.field_42820, settings)));
    }

    private static class_2248 registerGoldenLantern() {
        String name = "golden_lantern";
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15994).method_51369().method_9632(5.0f).method_9626(class_2498.field_17734).method_9631(state -> 15).method_22488().method_50012(class_3619.field_15971).method_63500(RegistryKeyUtils.block("golden_lantern"));
        return BCABlocks.registerBlock("golden_lantern", (Supplier<class_2248>)Suppliers.memoize(() -> new class_3749(settings)));
    }

    private static class_4970.class_2251 buttonSettings(String name) {
        return class_4970.class_2251.method_9637().method_9634().method_9632(0.5f).method_50012(class_3619.field_15971).method_63500(RegistryKeyUtils.block(name));
    }

    private static class_2248 registerBlock(String name, Supplier<class_2248> blockSupplier) {
        class_2248 block = BCABlocks.registerBlockWithoutBlockItem(name, blockSupplier);
        BCAItems.registerBlockItem(IdentifierUtils.modIdentifier(name), blockSupplier);
        return block;
    }

    private static class_2248 registerBlockWithoutBlockItem(String name, Supplier<class_2248> blockSupplier) {
        class_2960 identifier = IdentifierUtils.modIdentifier(name);
        return (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)identifier, (Object)blockSupplier.get());
    }

    public static void register() {
        BCABlocks.registerOxidizableBlocks();
        BCABlocks.registerWaxableBlocks();
    }

    private static void registerOxidizableBlocks() {
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)COPPER_BUTTON, (class_2248)EXPOSED_COPPER_BUTTON);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)EXPOSED_COPPER_BUTTON, (class_2248)WEATHERED_COPPER_BUTTON);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)WEATHERED_COPPER_BUTTON, (class_2248)OXIDIZED_COPPER_BUTTON);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)MEDIUM_WEIGHTED_PRESSURE_PLATE, (class_2248)EXPOSED_MEDIUM_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)EXPOSED_MEDIUM_WEIGHTED_PRESSURE_PLATE, (class_2248)WEATHERED_MEDIUM_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)WEATHERED_MEDIUM_WEIGHTED_PRESSURE_PLATE, (class_2248)OXIDIZED_MEDIUM_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)COPPER_RAIL, (class_2248)EXPOSED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)EXPOSED_COPPER_RAIL, (class_2248)WEATHERED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)WEATHERED_COPPER_RAIL, (class_2248)OXIDIZED_COPPER_RAIL);
    }

    private static void registerWaxableBlocks() {
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)MEDIUM_WEIGHTED_PRESSURE_PLATE, (class_2248)WAXED_MEDIUM_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)EXPOSED_MEDIUM_WEIGHTED_PRESSURE_PLATE, (class_2248)WAXED_EXPOSED_MEDIUM_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)WEATHERED_MEDIUM_WEIGHTED_PRESSURE_PLATE, (class_2248)WAXED_WEATHERED_MEDIUM_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)OXIDIZED_MEDIUM_WEIGHTED_PRESSURE_PLATE, (class_2248)WAXED_OXIDIZED_MEDIUM_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)COPPER_BUTTON, (class_2248)WAXED_COPPER_BUTTON);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)EXPOSED_COPPER_BUTTON, (class_2248)WAXED_EXPOSED_COPPER_BUTTON);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)WEATHERED_COPPER_BUTTON, (class_2248)WAXED_WEATHERED_COPPER_BUTTON);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)OXIDIZED_COPPER_BUTTON, (class_2248)WAXED_OXIDIZED_COPPER_BUTTON);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)COPPER_RAIL, (class_2248)WAXED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)EXPOSED_COPPER_RAIL, (class_2248)WAXED_EXPOSED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)WEATHERED_COPPER_RAIL, (class_2248)WAXED_WEATHERED_COPPER_RAIL);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)OXIDIZED_COPPER_RAIL, (class_2248)WAXED_OXIDIZED_COPPER_RAIL);
    }
}

