/*
 * Decompiled with CFR 0.152.
 */
package org.hendrix.bettercopperage.mixin;

import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3218;
import net.minecraft.class_5955;
import net.minecraft.class_9883;
import org.hendrix.bettercopperage.block.CopperRailBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_9883.class})
public final class DefaultMinecartControllerMixin {
    @Inject(method={"moveOnRail"}, at={@At(value="TAIL")})
    private void moveOnRail(class_3218 world, CallbackInfo callbackInfo) {
        class_9883 controller = (class_9883)this;
        class_2338 blockPos = controller.field_52520.method_62825();
        class_2680 blockState = controller.method_61588().method_8320(blockPos);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof CopperRailBlock) {
            CopperRailBlock copperRailBlock = (CopperRailBlock)class_22482;
            class_2768 railShape = (class_2768)blockState.method_11654(((class_2241)blockState.method_26204()).method_9474());
            class_5955.class_5811 oxidationLevel = copperRailBlock.getDegradationLevel();
            class_243 velocity = controller.method_61590();
            double horizontalLength = velocity.method_37267();
            if (horizontalLength > 0.01) {
                double velocityModifier = this.getHorizontalVelocityModifier(oxidationLevel);
                controller.method_61576(velocity.method_1031(velocity.field_1352 / horizontalLength * velocityModifier, 0.0, velocity.field_1350 / horizontalLength * velocityModifier));
            } else {
                double speedMultiplier = this.getSlopeVelocityMultiplier(oxidationLevel);
                double velocityX = velocity.field_1352;
                double velocityZ = velocity.field_1350;
                if (railShape == class_2768.field_12674) {
                    if (controller.field_52520.method_18803(blockPos.method_10067())) {
                        velocityX = speedMultiplier;
                    } else if (controller.field_52520.method_18803(blockPos.method_10078())) {
                        velocityX = -speedMultiplier;
                    }
                } else {
                    if (railShape != class_2768.field_12665) {
                        return;
                    }
                    if (controller.field_52520.method_18803(blockPos.method_10095())) {
                        velocityZ = speedMultiplier;
                    } else if (controller.field_52520.method_18803(blockPos.method_10072())) {
                        velocityZ = -speedMultiplier;
                    }
                }
                controller.method_61579(velocityX, velocity.field_1351, velocityZ);
            }
        }
    }

    @Unique
    private double getHorizontalVelocityModifier(class_5955.class_5811 oxidationLevel) {
        return switch (oxidationLevel) {
            default -> throw new MatchException(null, null);
            case class_5955.class_5811.field_28704 -> 0.04;
            case class_5955.class_5811.field_28705 -> 0.03;
            case class_5955.class_5811.field_28706 -> 0.02;
            case class_5955.class_5811.field_28707 -> 0.01;
        };
    }

    @Unique
    private double getSlopeVelocityMultiplier(class_5955.class_5811 oxidationLevel) {
        return switch (oxidationLevel) {
            default -> throw new MatchException(null, null);
            case class_5955.class_5811.field_28704 -> 0.015;
            case class_5955.class_5811.field_28705 -> 0.01;
            case class_5955.class_5811.field_28706 -> 0.005;
            case class_5955.class_5811.field_28707 -> 0.001;
        };
    }
}

