/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.crop_marker.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.tristankechlo.crop_marker.FullGrownCropMarker;
import com.tristankechlo.crop_marker.config.FullGrownCropMarkerConfig;
import com.tristankechlo.crop_marker.platform.Services;
import com.tristankechlo.crop_marker.types.MarkerOptions;
import com.tristankechlo.crop_marker.util.ResourceLocationSerializer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public final class ConfigManager {
    private static final File CONFIG_DIR = Services.PLATFORM.getConfigDirectory().toFile();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().registerTypeAdapter(MarkerOptions.class, (Object)new MarkerOptions.Serializer()).registerTypeAdapter(class_2960.class, (Object)new ResourceLocationSerializer()).create();
    public static final String FILE_NAME = "crop_marker.json";

    public static void loadAndVerifyConfig() {
        ConfigManager.createConfigFolder();
        FullGrownCropMarkerConfig.setToDefault();
        File configFile = new File(CONFIG_DIR, FILE_NAME);
        if (configFile.exists()) {
            ConfigManager.loadConfigFromFile(configFile);
            ConfigManager.writeConfigToFile(configFile);
            FullGrownCropMarker.LOGGER.info("Saved the checked/corrected config '{}'", (Object)FILE_NAME);
        } else {
            ConfigManager.writeConfigToFile(configFile);
            FullGrownCropMarker.LOGGER.warn("No config '{}' was found, created a new one.", (Object)FILE_NAME);
        }
    }

    private static void writeConfigToFile(File file) {
        JsonObject jsonObject = FullGrownCropMarkerConfig.serialize(new JsonObject());
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("\t");
            GSON.toJson((JsonElement)jsonObject, writer);
            writer.close();
        }
        catch (Exception e) {
            FullGrownCropMarker.LOGGER.error("There was an error writing the config to file '{}'", (Object)FILE_NAME);
            e.printStackTrace();
        }
    }

    private static void loadConfigFromFile(File file) {
        JsonObject json = null;
        try {
            JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)new FileReader(file), JsonElement.class);
            json = jsonElement.getAsJsonObject();
        }
        catch (Exception e) {
            FullGrownCropMarker.LOGGER.error("There was an error loading the config file '{}'", (Object)FILE_NAME);
            e.printStackTrace();
        }
        if (json != null) {
            FullGrownCropMarkerConfig.deserialize(json);
            FullGrownCropMarker.LOGGER.info("Config '{}' was successfully loaded.", (Object)FILE_NAME);
        } else {
            FullGrownCropMarker.LOGGER.error("Error loading config '{}', config hasn't been loaded.", (Object)FILE_NAME);
        }
    }

    public static void resetConfig() {
        FullGrownCropMarkerConfig.setToDefault();
        File configFile = new File(CONFIG_DIR, FILE_NAME);
        ConfigManager.writeConfigToFile(configFile);
        FullGrownCropMarker.LOGGER.info("Config '{}' was set to default.", (Object)FILE_NAME);
    }

    public static void reloadConfig() {
        File configFile = new File(CONFIG_DIR, FILE_NAME);
        if (configFile.exists()) {
            ConfigManager.loadConfigFromFile(configFile);
            ConfigManager.writeConfigToFile(configFile);
            FullGrownCropMarker.LOGGER.info("Saved the checked/corrected config crop_marker.json");
        } else {
            ConfigManager.writeConfigToFile(configFile);
            FullGrownCropMarker.LOGGER.warn("No config '{}' was found, created a new one", (Object)FILE_NAME);
        }
    }

    public static String getConfigPath() {
        File configFile = new File(CONFIG_DIR, FILE_NAME);
        return configFile.getAbsolutePath();
    }

    private static void createConfigFolder() {
        if (!CONFIG_DIR.exists() && !CONFIG_DIR.mkdirs()) {
            throw new RuntimeException("Could not create config folder " + CONFIG_DIR.getAbsolutePath());
        }
    }
}

