/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.crop_marker.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.tristankechlo.crop_marker.FullGrownCropMarker;
import com.tristankechlo.crop_marker.config.FullGrownCropMarkerConfig;
import com.tristankechlo.crop_marker.platform.IPlatformHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;

public final class ConfigManager {
    private static final File CONFIG_DIR = IPlatformHelper.INSTANCE.getConfigDirectory().toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    public static final String FILE_NAME = "crop_marker.json";
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "crop_marker.json");

    public static void loadAndVerifyConfig() {
        ConfigManager.createConfigFolder();
        if (!CONFIG_FILE.exists()) {
            FullGrownCropMarkerConfig.setToDefault();
            ConfigManager.writeConfigToFile();
            FullGrownCropMarker.LOGGER.warn("No config '{}' was found, created a new one.", (Object)FILE_NAME);
            return;
        }
        try {
            ConfigManager.loadConfigFromFile();
            FullGrownCropMarker.LOGGER.info("Config '{}' was loaded.", (Object)FILE_NAME);
        }
        catch (Exception e) {
            FullGrownCropMarker.LOGGER.error(e.getMessage());
            FullGrownCropMarker.LOGGER.error("Error loading config '{}', config hasn't been loaded. Using default config.", (Object)FILE_NAME);
            FullGrownCropMarkerConfig.setToDefault();
        }
    }

    private static void loadConfigFromFile() throws FileNotFoundException {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse((Reader)new FileReader(CONFIG_FILE));
        JsonObject json = jsonElement.getAsJsonObject();
        FullGrownCropMarkerConfig.deserialize((JsonElement)json);
    }

    private static void writeConfigToFile() {
        try {
            JsonElement jsonObject = FullGrownCropMarkerConfig.serialize();
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(CONFIG_FILE));
            writer.setIndent("\t");
            GSON.toJson(jsonObject, writer);
            writer.close();
        }
        catch (Exception e) {
            FullGrownCropMarker.LOGGER.error("There was an error writing the config to file: '{}'", (Object)FILE_NAME);
            FullGrownCropMarker.LOGGER.error(e.getMessage());
        }
    }

    public static void resetConfig() {
        FullGrownCropMarkerConfig.setToDefault();
        ConfigManager.writeConfigToFile();
        FullGrownCropMarker.LOGGER.info("Config '{}' was set to default.", (Object)FILE_NAME);
    }

    public static void reloadConfig() throws FileNotFoundException {
        File configFile = new File(CONFIG_DIR, FILE_NAME);
        if (configFile.exists()) {
            ConfigManager.loadConfigFromFile();
            ConfigManager.writeConfigToFile();
            FullGrownCropMarker.LOGGER.info("Saved the checked/corrected config crop_marker.json");
        } else {
            ConfigManager.writeConfigToFile();
            FullGrownCropMarker.LOGGER.warn("No config '{}' was found, created a new one", (Object)FILE_NAME);
        }
    }

    public static String getConfigPath() {
        File configFile = new File(CONFIG_DIR, FILE_NAME);
        return configFile.getAbsolutePath();
    }

    private static void createConfigFolder() {
        if (!CONFIG_DIR.exists() && !CONFIG_DIR.mkdirs()) {
            throw new RuntimeException("Could not create config folder " + CONFIG_DIR.getAbsolutePath());
        }
    }
}

