/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.crop_marker.config;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.crop_marker.FullGrownCropMarker;
import com.tristankechlo.crop_marker.types.MarkerColor;
import com.tristankechlo.crop_marker.types.MarkerOptions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public record FullGrownCropMarkerConfig(MarkerOptions defaultOptions, Map<ResourceLocation, MarkerOptions> options) {
    private static FullGrownCropMarkerConfig INSTANCE = new FullGrownCropMarkerConfig(MarkerOptions.DEFAULT, FullGrownCropMarkerConfig.createOptions());
    public static final Codec<FullGrownCropMarkerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MarkerOptions.CODEC.fieldOf("defaultOptions").forGetter(FullGrownCropMarkerConfig::defaultOptions), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, MarkerOptions.CODEC).fieldOf("overrides").forGetter(FullGrownCropMarkerConfig::options)).apply((Applicative)instance, FullGrownCropMarkerConfig::new));

    public static MarkerOptions getOptions(ResourceLocation id) {
        return INSTANCE.options().getOrDefault(id, INSTANCE.defaultOptions());
    }

    public static void setToDefault() {
        INSTANCE = new FullGrownCropMarkerConfig(MarkerOptions.DEFAULT, FullGrownCropMarkerConfig.createOptions());
    }

    public static JsonElement serialize() {
        DataResult result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)INSTANCE);
        result.error().ifPresent(partial -> FullGrownCropMarker.LOGGER.error(partial.message()));
        return (JsonElement)result.result().orElseThrow();
    }

    public static void deserialize(JsonElement json) {
        DataResult result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        result.error().ifPresent(partial -> FullGrownCropMarker.LOGGER.error(partial.message()));
        INSTANCE = (FullGrownCropMarkerConfig)result.result().orElseThrow();
    }

    private static Map<ResourceLocation, MarkerOptions> createOptions() {
        HashMap<ResourceLocation, MarkerOptions> options = new HashMap<ResourceLocation, MarkerOptions>();
        options.put(FullGrownCropMarkerConfig.getID("wheat_stage7"), new MarkerOptions(1, false, true, MarkerColor.YELLOW));
        options.put(FullGrownCropMarkerConfig.getID("carrots_stage3"), new MarkerOptions(-2, false, true, MarkerColor.ORANGE));
        options.put(FullGrownCropMarkerConfig.getID("beetroots_stage3"), new MarkerOptions(-4, false, true, MarkerColor.RED));
        options.put(FullGrownCropMarkerConfig.getID("potatoes_stage3"), new MarkerOptions(1, false, true, MarkerColor.GREEN));
        options.put(FullGrownCropMarkerConfig.getID("nether_wart_stage2"), new MarkerOptions(-1, false, true, MarkerColor.RED));
        options.put(FullGrownCropMarkerConfig.getID("sweet_berry_bush_stage2"), new MarkerOptions(2, false, true, MarkerColor.YELLOW));
        options.put(FullGrownCropMarkerConfig.getID("sweet_berry_bush_stage3"), new MarkerOptions(2, false, true, MarkerColor.GREEN));
        return options;
    }

    private static ResourceLocation getID(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("block/" + path));
    }
}

