/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.crop_marker.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tristankechlo.crop_marker.FullGrownCropMarker;
import com.tristankechlo.crop_marker.commands.ResponseHelper;
import com.tristankechlo.crop_marker.config.ConfigManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class CropMarkerCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"crop_marker").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"config").requires(source -> source.method_9259(3))).then(ClientCommandManager.literal((String)"reload").executes(CropMarkerCommand::configReload))).then(ClientCommandManager.literal((String)"show").executes(CropMarkerCommand::configShow))).then(ClientCommandManager.literal((String)"reset").executes(CropMarkerCommand::configReset)))).then(ClientCommandManager.literal((String)"github").executes(CropMarkerCommand::github))).then(ClientCommandManager.literal((String)"issue").executes(CropMarkerCommand::issue))).then(ClientCommandManager.literal((String)"wiki").executes(CropMarkerCommand::wiki))).then(ClientCommandManager.literal((String)"discord").executes(CropMarkerCommand::discord))).then(ClientCommandManager.literal((String)"curseforge").executes(CropMarkerCommand::curseforge))).then(ClientCommandManager.literal((String)"modrinth").executes(CropMarkerCommand::modrinth));
        dispatcher.register(command);
        FullGrownCropMarker.LOGGER.info("Command '/{}' registered", (Object)"crop_marker");
    }

    private static int configReload(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        try {
            ConfigManager.reloadConfig();
        }
        catch (Exception e) {
            class_5250 start = ResponseHelper.start();
            class_5250 message = class_2561.method_43470((String)"Error reloading the config! Check the logs for more information.");
            message.method_27692(class_124.field_1068);
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)start.method_10852((class_2561)message));
            return 0;
        }
        ResponseHelper.sendMessageConfigReload(source);
        return 1;
    }

    private static int configShow(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        ResponseHelper.sendMessageConfigShow(source);
        return 1;
    }

    private static int configReset(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        ConfigManager.resetConfig();
        ResponseHelper.sendMessageConfigReset(source);
        return 1;
    }

    private static int github(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_5250 link = ResponseHelper.clickableLink("https://github.com/tristankechlo/FullGrownCropMarker");
        class_5250 message = class_2561.method_43470((String)"Check out the source code on GitHub: ").method_27692(class_124.field_1068).method_10852((class_2561)link);
        ResponseHelper.sendMessage(source, (class_2561)message);
        return 1;
    }

    private static int issue(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_5250 link = ResponseHelper.clickableLink("https://github.com/tristankechlo/FullGrownCropMarker/issues");
        class_5250 message = class_2561.method_43470((String)"If you found an issue, submit it here: ").method_27692(class_124.field_1068).method_10852((class_2561)link);
        ResponseHelper.sendMessage(source, (class_2561)message);
        return 1;
    }

    private static int wiki(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_5250 link = ResponseHelper.clickableLink("https://github.com/tristankechlo/FullGrownCropMarker/wiki");
        class_5250 message = class_2561.method_43470((String)"The wiki can be found here: ").method_27692(class_124.field_1068).method_10852((class_2561)link);
        ResponseHelper.sendMessage(source, (class_2561)message);
        return 1;
    }

    private static int discord(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_5250 link = ResponseHelper.clickableLink("https://discord.gg/bhUaWhq");
        class_5250 message = class_2561.method_43470((String)"Join the Discord here: ").method_27692(class_124.field_1068).method_10852((class_2561)link);
        ResponseHelper.sendMessage(source, (class_2561)message);
        return 1;
    }

    private static int curseforge(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_5250 link = ResponseHelper.clickableLink("https://curseforge.com/minecraft/mc-mods/full-grown-crop-marker");
        class_5250 message = class_2561.method_43470((String)"Check out the CurseForge page here: ").method_27692(class_124.field_1068).method_10852((class_2561)link);
        ResponseHelper.sendMessage(source, (class_2561)message);
        return 1;
    }

    private static int modrinth(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_5250 link = ResponseHelper.clickableLink("https://modrinth.com/mod/full-grown-crop-marker");
        class_5250 message = class_2561.method_43470((String)"Check out the Modrinth page here: ").method_27692(class_124.field_1068).method_10852((class_2561)link);
        ResponseHelper.sendMessage(source, (class_2561)message);
        return 1;
    }
}

