/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.crop_marker.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.tristankechlo.crop_marker.FullGrownCropMarker;
import com.tristankechlo.crop_marker.config.ConfigManager;
import com.tristankechlo.crop_marker.types.MarkerColor;
import com.tristankechlo.crop_marker.types.MarkerOptions;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public final class FullGrownCropMarkerConfig {
    private static MarkerOptions defaultOptions = MarkerOptions.DEFAULT;
    private static Map<ResourceLocation, MarkerOptions> options = FullGrownCropMarkerConfig.createOptions();
    private static final Type MAP_TYPE = new TypeToken<Map<ResourceLocation, MarkerOptions>>(){}.getType();

    public static MarkerOptions getOptions(ResourceLocation id) {
        return options.getOrDefault(id, defaultOptions);
    }

    public static void setToDefault() {
        defaultOptions = MarkerOptions.DEFAULT;
        options = FullGrownCropMarkerConfig.createOptions();
    }

    public static JsonObject serialize(JsonObject jsonObject) {
        jsonObject.add("defaultOptions", defaultOptions.toJson());
        JsonElement overrides = ConfigManager.GSON.toJsonTree(options, MAP_TYPE);
        jsonObject.add("overrides", overrides);
        return jsonObject;
    }

    public static void deserialize(JsonObject jsonObject) {
        defaultOptions = MarkerOptions.fromJson(jsonObject, "defaultOptions", MarkerOptions.DEFAULT);
        try {
            JsonObject overrides = GsonHelper.m_13841_((JsonObject)jsonObject, (String)"overrides", null);
            options = (Map)ConfigManager.GSON.fromJson((JsonElement)overrides, MAP_TYPE);
        }
        catch (Exception e) {
            FullGrownCropMarker.LOGGER.error("Error while deserializing config: {}", (Object)e.getMessage());
            options = FullGrownCropMarkerConfig.createOptions();
        }
    }

    private static Map<ResourceLocation, MarkerOptions> createOptions() {
        HashMap<ResourceLocation, MarkerOptions> options = new HashMap<ResourceLocation, MarkerOptions>();
        options.put(FullGrownCropMarkerConfig.getID("wheat_stage7"), new MarkerOptions(1, false, true, MarkerColor.YELLOW));
        options.put(FullGrownCropMarkerConfig.getID("carrots_stage3"), new MarkerOptions(-2, false, true, MarkerColor.ORANGE));
        options.put(FullGrownCropMarkerConfig.getID("beetroots_stage3"), new MarkerOptions(-4, false, true, MarkerColor.RED));
        options.put(FullGrownCropMarkerConfig.getID("potatoes_stage3"), new MarkerOptions(1, false, true, MarkerColor.GREEN));
        options.put(FullGrownCropMarkerConfig.getID("nether_wart_stage2"), new MarkerOptions(-1, false, true, MarkerColor.RED));
        options.put(FullGrownCropMarkerConfig.getID("sweet_berry_bush_stage2"), new MarkerOptions(2, false, true, MarkerColor.YELLOW));
        options.put(FullGrownCropMarkerConfig.getID("sweet_berry_bush_stage3"), new MarkerOptions(2, false, true, MarkerColor.GREEN));
        return options;
    }

    private static ResourceLocation getID(String path) {
        return new ResourceLocation("minecraft", "block/" + path);
    }
}

