/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.crop_marker.types;

import net.minecraft.util.StringRepresentable;

public enum MarkerColor implements StringRepresentable
{
    RED("red", 2.0f, 10.0f, 0.0f, 10.0f),
    GREEN("green", 2.0f, 0.0f, 0.0f, 0.0f),
    BLUE("blue", 2.0f, 5.0f, 0.0f, 5.0f),
    YELLOW("yellow", 10.0f, 0.0f, 8.0f, 0.0f),
    ORANGE("orange", 10.0f, 10.0f, 8.0f, 10.0f),
    PURPLE("purple", 10.0f, 5.0f, 8.0f, 5.0f);

    private final String name;
    private final float[] uvsSmall;
    private final float[] uvsLarge;
    private final float[] uvsSmallAnimated;
    private final float[] uvsLargeAnimated;
    public static final StringRepresentable.EnumCodec<MarkerColor> CODEC;

    private MarkerColor(String name, float x1, float y1, float x2, float y2) {
        this.name = name;
        this.uvsSmall = new float[]{x1, y1, x1 + 2.0f, y1 + 2.0f};
        this.uvsLarge = new float[]{x2, y2, x2 + 2.0f, y2 + 5.0f};
        this.uvsSmallAnimated = new float[]{x1 + 4.0f, y1, x1 + 6.0f, y1 + 2.0f};
        this.uvsLargeAnimated = new float[]{x2 + 4.0f, y2, x2 + 6.0f, y2 + 5.0f};
    }

    public float[] getUvsSmall() {
        return this.uvsSmall;
    }

    public float[] getUvsLarge() {
        return this.uvsLarge;
    }

    public float[] getUvsSmallAnimated() {
        return this.uvsSmallAnimated;
    }

    public float[] getUvsLargeAnimated() {
        return this.uvsLargeAnimated;
    }

    public String toString() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public static MarkerColor fromString(String string) {
        return (MarkerColor)CODEC.byName(string, (Enum)GREEN);
    }

    static {
        CODEC = StringRepresentable.fromEnum(MarkerColor::values);
    }
}

