/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.crop_marker.commands;

import com.tristankechlo.crop_marker.config.ConfigManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class ResponseHelper {
    public static void sendMessageConfigShow(CommandSourceStack source) {
        MutableComponent clickableFile = ResponseHelper.clickableConfig();
        MutableComponent message = Component.literal((String)"Config-file can be found here: ").append((Component)clickableFile);
        ResponseHelper.sendMessage(source, (Component)message.withStyle(ChatFormatting.WHITE));
    }

    public static void sendMessageConfigReload(CommandSourceStack source) {
        MutableComponent message = Component.literal((String)"Config was successfully reloaded.");
        ResponseHelper.sendMessage(source, (Component)message.withStyle(ChatFormatting.WHITE));
        ResponseHelper.sendMessageReloadAssets(source);
    }

    public static void sendMessageConfigReset(CommandSourceStack source) {
        MutableComponent message = Component.literal((String)"Config was successfully set to default.");
        ResponseHelper.sendMessage(source, (Component)message.withStyle(ChatFormatting.WHITE));
        ResponseHelper.sendMessageReloadAssets(source);
    }

    private static void sendMessageReloadAssets(CommandSourceStack source) {
        MutableComponent message = Component.literal((String)"You need to reload the game assets for the changes to take effect.");
        ResponseHelper.sendMessage(source, (Component)message.withStyle(ChatFormatting.WHITE));
        MutableComponent message2 = Component.literal((String)"You can do this by pressing F3 + T or by restarting the game.");
        ResponseHelper.sendMessage(source, (Component)message2.withStyle(ChatFormatting.WHITE));
    }

    public static MutableComponent start() {
        return Component.literal((String)"[FullGrownCropMarker] ").withStyle(ChatFormatting.GOLD);
    }

    public static void sendMessage(CommandSourceStack source, Component message) {
        MutableComponent start = ResponseHelper.start().append(message);
        source.sendSuccess(() -> start, false);
    }

    public static MutableComponent clickableConfig() {
        String fileName = "crop_marker.json";
        String filePath = ConfigManager.getConfigPath();
        MutableComponent mutableComponent = Component.literal((String)fileName);
        mutableComponent.withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE});
        mutableComponent.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, filePath)));
        return mutableComponent;
    }

    public static MutableComponent clickableLink(String url, String displayText) {
        MutableComponent mutableComponent = Component.literal((String)displayText);
        mutableComponent.withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE});
        mutableComponent.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
        return mutableComponent;
    }

    public static MutableComponent clickableLink(String url) {
        return ResponseHelper.clickableLink(url, url);
    }
}

