/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.crop_marker.mixin;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.tristankechlo.crop_marker.FullGrownCropMarker;
import com.tristankechlo.crop_marker.config.FullGrownCropMarkerConfig;
import com.tristankechlo.crop_marker.types.MarkerOptions;
import com.tristankechlo.crop_marker.util.ResourceLocationHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockModel.class})
public abstract class BlockModelMixin {
    private static final ResourceLocation FULL_GROWN_CROP_MARKER_TEXTURE = new ResourceLocation("crop_marker", "block/marker");
    private static final ResourceLocation FULL_GROWN_CROP_MARKER_TEXTURE_ANIMATED = new ResourceLocation("crop_marker", "block/marker_animated");
    private static final Either<Material, String> FULL_GROWN_CROP_MARKER_SPRITE = Either.left((Object)new Material(InventoryMenu.BLOCK_ATLAS, FULL_GROWN_CROP_MARKER_TEXTURE));
    private static final Either<Material, String> FULL_GROWN_CROP_MARKER_SPRITE_ANIMATED = Either.left((Object)new Material(InventoryMenu.BLOCK_ATLAS, FULL_GROWN_CROP_MARKER_TEXTURE_ANIMATED));
    private boolean FullGrownCropMarker$alreadyHasMarker = false;
    @Shadow
    @Final
    private List<BlockElement> elements;
    @Shadow
    @Final
    protected Map<String, Either<Material, String>> textureMap;

    @Inject(at={@At(value="HEAD")}, method={"bake(Lnet/minecraft/client/resources/model/ModelBaker;Lnet/minecraft/client/renderer/block/model/BlockModel;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Lnet/minecraft/resources/ResourceLocation;Z)Lnet/minecraft/client/resources/model/BakedModel;"})
    private void FullGrownCropMarker$bake(ModelBaker $$0, BlockModel $$1, Function<Material, TextureAtlasSprite> $$2, ModelState $$3, ResourceLocation id, boolean $$5, CallbackInfoReturnable<BakedModel> cir) {
        boolean shouldHaveMarker = ResourceLocationHelper.FullGrownCropMarker$shouldHaveMarker(id);
        if (shouldHaveMarker && !this.FullGrownCropMarker$alreadyHasMarker) {
            MarkerOptions options = FullGrownCropMarkerConfig.getOptions(id);
            if (!options.hasMarker()) {
                FullGrownCropMarker.LOGGER.info("Skipped adding the marker to '{}' with {}", (Object)id, (Object)options);
                return;
            }
            List<BlockElement> all = List.copyOf(this.getElements());
            this.elements.clear();
            this.elements.addAll(all);
            this.textureMap.put("marker", FULL_GROWN_CROP_MARKER_SPRITE);
            this.textureMap.put("animated_marker", FULL_GROWN_CROP_MARKER_SPRITE_ANIMATED);
            this.elements.addAll(BlockModelMixin.FullGrownCropMarker$createMarker(options));
            FullGrownCropMarker.LOGGER.info("Added the marker to '{}' with {}", (Object)id, (Object)options);
            this.FullGrownCropMarker$alreadyHasMarker = true;
        }
    }

    private static List<BlockElement> FullGrownCropMarker$createMarker(MarkerOptions options) {
        float[] uvsSmall = options.color().getUvsSmall();
        float[] uvsLarge = options.color().getUvsLarge();
        int yOffset = 16 + options.yOffset();
        String texture = options.animated() ? "#animated_marker" : "#marker";
        List<BlockElement> markerDefault = BlockModelMixin.FullGrownCropMarker$createMarker(texture, uvsSmall, uvsLarge, yOffset);
        if (!options.animated()) {
            return markerDefault;
        }
        float[] uvsSmallAnimated = options.color().getUvsSmallAnimated();
        float[] uvsLargeAnimated = options.color().getUvsLargeAnimated();
        List<BlockElement> markerAnimated = BlockModelMixin.FullGrownCropMarker$createMarker(texture, uvsSmallAnimated, uvsLargeAnimated, 1 + yOffset);
        return ImmutableList.builder().addAll(markerDefault).addAll(markerAnimated).build();
    }

    private static List<BlockElement> FullGrownCropMarker$createMarker(String texture, float[] uvsSmall, float[] uvsLarge, int yOffset) {
        BlockElementFace faceSmall = new BlockElementFace(Direction.UP, 0, texture, new BlockFaceUV(uvsSmall, 0));
        BlockElementFace faceLarge = new BlockElementFace(Direction.UP, 0, texture, new BlockFaceUV(uvsLarge, 0));
        BlockElementRotation rotationElement = new BlockElementRotation(new Vector3f(0.5f, 0.0f, 0.5f), Direction.Axis.Y, 0.0f, false);
        Map facesCube = Direction.stream().collect(HashMap::new, (map, dir) -> map.put(dir, faceSmall), HashMap::putAll);
        Vector3f fromSmall = new Vector3f(7.0f, (float)(1 + yOffset), 7.0f);
        Vector3f toSmall = new Vector3f(9.0f, (float)(3 + yOffset), 9.0f);
        BlockElement smallCube = new BlockElement(fromSmall, toSmall, facesCube, rotationElement, false);
        Map facesCuboidTop = Direction.stream().filter(dir -> dir.getAxis().isHorizontal()).collect(HashMap::new, (map, dir) -> map.put(dir, faceLarge), HashMap::putAll);
        facesCuboidTop.put(Direction.UP, faceSmall);
        facesCuboidTop.put(Direction.DOWN, faceSmall);
        Vector3f fromLarge = new Vector3f(7.0f, (float)(4 + yOffset), 7.0f);
        Vector3f toLarge = new Vector3f(9.0f, (float)(9 + yOffset), 9.0f);
        BlockElement cuboidTop = new BlockElement(fromLarge, toLarge, facesCuboidTop, rotationElement, false);
        return List.of(smallCube, cuboidTop);
    }

    @Shadow
    public abstract List<BlockElement> getElements();
}

