/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.crop_marker.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.tristankechlo.crop_marker.FullGrownCropMarker;
import com.tristankechlo.crop_marker.config.ConfigManager;
import com.tristankechlo.crop_marker.types.MarkerColor;
import java.lang.reflect.Type;
import net.minecraft.class_3518;

public record MarkerOptions(int yOffset, boolean animated, boolean hasMarker, MarkerColor color) {
    public static final MarkerOptions DEFAULT = new MarkerOptions(0, false, true, MarkerColor.GREEN);
    private static final String OFFSET = "offset";
    private static final String ANIMATED = "animated";
    private static final String HAS_MARKER = "hasMarker";
    private static final String COLOR = "color";

    public static MarkerOptions fromJson(JsonElement json) {
        return (MarkerOptions)ConfigManager.GSON.fromJson(json, MarkerOptions.class);
    }

    public static MarkerOptions fromJson(JsonObject json, String key, MarkerOptions defaultValue) {
        JsonObject element = class_3518.method_15281((JsonObject)json, (String)key, null);
        if (element == null) {
            FullGrownCropMarker.LOGGER.warn("Failed to deserialize {}, using default values", (Object)key);
            return defaultValue;
        }
        return MarkerOptions.fromJson((JsonElement)element);
    }

    public JsonElement toJson() {
        return ConfigManager.GSON.toJsonTree((Object)this, MarkerOptions.class);
    }

    @Override
    public String toString() {
        return "MarkerOptions{yOffset=" + this.yOffset + ", animated=" + this.animated + ", position=" + this.hasMarker + ", color=" + String.valueOf((Object)this.color) + "}";
    }

    public static class Serializer
    implements JsonSerializer<MarkerOptions>,
    JsonDeserializer<MarkerOptions> {
        public JsonElement serialize(MarkerOptions src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(MarkerOptions.OFFSET, (Number)src.yOffset());
            jsonObject.addProperty(MarkerOptions.ANIMATED, Boolean.valueOf(src.animated()));
            jsonObject.addProperty(MarkerOptions.HAS_MARKER, Boolean.valueOf(src.hasMarker()));
            jsonObject.addProperty(MarkerOptions.COLOR, src.color().method_15434());
            return jsonObject;
        }

        public MarkerOptions deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            int yOffset = class_3518.method_15282((JsonObject)json, (String)MarkerOptions.OFFSET, (int)0);
            boolean animatedMarker = class_3518.method_15258((JsonObject)json, (String)MarkerOptions.ANIMATED, (boolean)false);
            boolean hasMarker = class_3518.method_15258((JsonObject)json, (String)MarkerOptions.HAS_MARKER, (boolean)true);
            MarkerColor color = this.deserializeColor(json);
            return new MarkerOptions(yOffset, animatedMarker, hasMarker, color);
        }

        private MarkerColor deserializeColor(JsonObject object) {
            String color = class_3518.method_15253((JsonObject)object, (String)MarkerOptions.COLOR, (String)MarkerColor.GREEN.method_15434());
            return MarkerColor.fromString(color.toLowerCase());
        }
    }
}

