/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.crop_marker.mixin;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.tristankechlo.crop_marker.FullGrownCropMarker;
import com.tristankechlo.crop_marker.config.FullGrownCropMarkerConfig;
import com.tristankechlo.crop_marker.types.MarkerOptions;
import com.tristankechlo.crop_marker.util.ModelBakerAddon;
import com.tristankechlo.crop_marker.util.ResourceLocationHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_789;
import net.minecraft.class_793;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_793.class})
public abstract class BlockModelMixin {
    @Unique
    private static final class_2960 FULL_GROWN_CROP_MARKER_TEXTURE = class_2960.method_60655((String)"crop_marker", (String)"block/marker");
    @Unique
    private static final class_2960 FULL_GROWN_CROP_MARKER_TEXTURE_ANIMATED = class_2960.method_60655((String)"crop_marker", (String)"block/marker_animated");
    @Unique
    private static final Either<class_4730, String> FULL_GROWN_CROP_MARKER_SPRITE = Either.left((Object)new class_4730(class_1723.field_21668, FULL_GROWN_CROP_MARKER_TEXTURE));
    @Unique
    private static final Either<class_4730, String> FULL_GROWN_CROP_MARKER_SPRITE_ANIMATED = Either.left((Object)new class_4730(class_1723.field_21668, FULL_GROWN_CROP_MARKER_TEXTURE_ANIMATED));
    @Shadow
    @Final
    private List<class_785> field_4245;
    @Shadow
    @Final
    protected Map<String, Either<class_4730, String>> field_4251;
    @Shadow
    public String field_4252;

    @Inject(at={@At(value="HEAD")}, method={"bake(Lnet/minecraft/client/resources/model/ModelBaker;Lnet/minecraft/client/renderer/block/model/BlockModel;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Z)Lnet/minecraft/client/resources/model/BakedModel;"})
    private void FullGrownCropMarker$onBake(class_7775 baker, class_793 model, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, boolean $$4, CallbackInfoReturnable<class_1087> cir) {
        if (!(baker instanceof ModelBakerAddon)) {
            return;
        }
        boolean shouldHaveMarker = ((ResourceLocationHelper)((ModelBakerAddon)baker).FullGrownCropMarker$id()).FullGrownCropMarker$shouldHaveMarker();
        if (shouldHaveMarker) {
            this.FullGrownCropMarker$addMarker();
        }
    }

    @Unique
    private void FullGrownCropMarker$addMarker() {
        class_2960 id = class_2960.method_60654((String)this.field_4252);
        MarkerOptions options = FullGrownCropMarkerConfig.getOptions(id);
        if (!options.hasMarker()) {
            FullGrownCropMarker.LOGGER.info("Skipped adding the marker to '{}' with {}", (Object)id, (Object)options);
            return;
        }
        List<class_785> all = List.copyOf(this.method_3433());
        this.field_4245.clear();
        this.field_4245.addAll(all);
        this.field_4251.put("marker", FULL_GROWN_CROP_MARKER_SPRITE);
        this.field_4251.put("animated_marker", FULL_GROWN_CROP_MARKER_SPRITE_ANIMATED);
        this.field_4245.addAll(BlockModelMixin.FullGrownCropMarker$createMarker(options));
        FullGrownCropMarker.LOGGER.info("Added the marker to '{}' with {}", (Object)id, (Object)options);
    }

    @Unique
    private static List<class_785> FullGrownCropMarker$createMarker(MarkerOptions options) {
        float[] uvsSmall = options.color().getUvsSmall();
        float[] uvsLarge = options.color().getUvsLarge();
        int yOffset = 16 + options.yOffset();
        String texture = options.animated() ? "#animated_marker" : "#marker";
        List<class_785> markerDefault = BlockModelMixin.FullGrownCropMarker$createMarker(texture, uvsSmall, uvsLarge, yOffset);
        if (!options.animated()) {
            return markerDefault;
        }
        float[] uvsSmallAnimated = options.color().getUvsSmallAnimated();
        float[] uvsLargeAnimated = options.color().getUvsLargeAnimated();
        List<class_785> markerAnimated = BlockModelMixin.FullGrownCropMarker$createMarker(texture, uvsSmallAnimated, uvsLargeAnimated, 1 + yOffset);
        return ImmutableList.builder().addAll(markerDefault).addAll(markerAnimated).build();
    }

    @Unique
    private static List<class_785> FullGrownCropMarker$createMarker(String texture, float[] uvsSmall, float[] uvsLarge, int yOffset) {
        class_783 faceSmall = new class_783(class_2350.field_11036, 0, texture, new class_787(uvsSmall, 0));
        class_783 faceLarge = new class_783(class_2350.field_11036, 0, texture, new class_787(uvsLarge, 0));
        class_789 rotationElement = new class_789(new Vector3f(0.5f, 0.0f, 0.5f), class_2350.class_2351.field_11052, 0.0f, false);
        Map facesCube = class_2350.method_42013().collect(HashMap::new, (map, dir) -> map.put(dir, faceSmall), HashMap::putAll);
        Vector3f fromSmall = new Vector3f(7.0f, (float)(1 + yOffset), 7.0f);
        Vector3f toSmall = new Vector3f(9.0f, (float)(3 + yOffset), 9.0f);
        class_785 smallCube = new class_785(fromSmall, toSmall, facesCube, rotationElement, false);
        Map facesCuboidTop = class_2350.method_42013().filter(dir -> dir.method_10166().method_10179()).collect(HashMap::new, (map, dir) -> map.put(dir, faceLarge), HashMap::putAll);
        facesCuboidTop.put(class_2350.field_11036, faceSmall);
        facesCuboidTop.put(class_2350.field_11033, faceSmall);
        Vector3f fromLarge = new Vector3f(7.0f, (float)(4 + yOffset), 7.0f);
        Vector3f toLarge = new Vector3f(9.0f, (float)(9 + yOffset), 9.0f);
        class_785 cuboidTop = new class_785(fromLarge, toLarge, facesCuboidTop, rotationElement, false);
        return List.of(smallCube, cuboidTop);
    }

    @Shadow
    public abstract List<class_785> method_3433();
}

