/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.designer.block;

import com.ryu.minecraft.mod.neoforge.neovillagers.designer.helpers.DecorCauldronHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DecorWaterCauldronBlock
extends Block {
    public static final String BLOCK_NAME = "decoration_water_cauldron";
    private static final VoxelShape INSIDE = Block.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.ONLY_FIRST);

    public DecorWaterCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getInteractionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return INSIDE;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected InteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pStack.is(Items.BUCKET)) {
            DecorCauldronHelper.fillBucket(pLevel, pPos, pPlayer, pHand, pStack);
            return InteractionResult.SUCCESS;
        }
        if (pStack.is(Items.WATER_BUCKET)) {
            DecorCauldronHelper.fillCauldron(pLevel, pPos, pPlayer, pHand, pStack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

