/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.designer.villagers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.block.DecorBarrelBlock;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.block.DecorCauldronBlock;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.block.DecorChestBlock;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.setup.SetupBlocks;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.setup.SetupVillagers;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.villagers.Worker;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.villagers.trades.EmeraldForItemByVillagerTypeTradeOffer;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.villagers.trades.ItemForEmeraldTradeOffer;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.villagers.trades.RandomItemForEmeraldTradeOffer;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class Designer
extends Worker {
    public static final String ENTITY_NAME = "designer";
    public static final String ENTITY_POI_NAME = "designer_poi";
    private static final List<Item> RANDOM_COOPER_CHAINS = List.of(Items.COPPER_CHAIN.exposed(), Items.COPPER_CHAIN.oxidized(), Items.COPPER_CHAIN.unaffected(), Items.COPPER_CHAIN.weathered(), Items.COPPER_CHAIN.waxed(), Items.COPPER_CHAIN.waxedExposed(), Items.COPPER_CHAIN.waxedOxidized(), Items.COPPER_CHAIN.waxedWeathered());
    private static final List<Item> RANDOM_ITEMS = List.of(Items.WHITE_BANNER, Items.BLACK_BANNER, Items.BLUE_BANNER, Items.BROWN_BANNER, Items.CYAN_BANNER, Items.GRAY_BANNER, Items.GREEN_BANNER, Items.LIGHT_BLUE_BANNER, Items.LIGHT_GRAY_BANNER, Items.LIME_BANNER, Items.MAGENTA_BANNER, Items.ORANGE_BANNER, Items.PINK_BANNER, Items.PURPLE_BANNER, Items.RED_BANNER, Items.YELLOW_BANNER);
    private static final Map<ResourceKey<VillagerType>, Item> VILLAGE_PLANK_ITEMS = ImmutableMap.builder().put((Object)VillagerType.PLAINS, (Object)Items.OAK_PLANKS).put((Object)VillagerType.TAIGA, (Object)Items.SPRUCE_PLANKS).put((Object)VillagerType.SNOW, (Object)Items.SPRUCE_PLANKS).put((Object)VillagerType.DESERT, (Object)Items.PALE_OAK_PLANKS).put((Object)VillagerType.JUNGLE, (Object)Items.JUNGLE_PLANKS).put((Object)VillagerType.SAVANNA, (Object)Items.ACACIA_PLANKS).put((Object)VillagerType.SWAMP, (Object)Items.MANGROVE_PLANKS).build();

    public static VillagerProfession registerVillager() {
        ResourceLocation villagerResource = ResourceLocation.fromNamespaceAndPath((String)"neovillagersdesigner", (String)ENTITY_NAME);
        MutableComponent villager = Component.translatable((String)("entity." + villagerResource.getNamespace() + ".villager." + villagerResource.getPath()));
        return new VillagerProfession((Component)villager, x -> x.is(SetupVillagers.DESIGNER_POI.getKey()), x -> x.is(SetupVillagers.DESIGNER_POI.getKey()), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.VILLAGER_CELEBRATE);
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel1() {
        ItemForEmeraldTradeOffer option1 = new ItemForEmeraldTradeOffer((ItemLike)((DecorBarrelBlock)((Object)SetupBlocks.DECOR_BARREL_BLOCK.get())).asItem(), 2, 3, 8, 4);
        ItemForEmeraldTradeOffer option2 = new ItemForEmeraldTradeOffer((ItemLike)((Block)SetupBlocks.DECOR_COMPOSTER_BLOCK.get()).asItem(), 2, 3, 8, 4);
        EmeraldForItemByVillagerTypeTradeOffer option3 = new EmeraldForItemByVillagerTypeTradeOffer(6, 8, 4, VILLAGE_PLANK_ITEMS);
        return new VillagerTrades.ItemListing[]{option1, option2, option3};
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel2() {
        ItemForEmeraldTradeOffer option1 = new ItemForEmeraldTradeOffer((ItemLike)Items.ITEM_FRAME, 5, 1, 12, 6);
        ItemForEmeraldTradeOffer option2 = new ItemForEmeraldTradeOffer((ItemLike)Items.FLOWER_POT, 1, 3, 6, 4);
        ItemForEmeraldTradeOffer option3 = new ItemForEmeraldTradeOffer((ItemLike)Items.BOOKSHELF, 7, 1, 12, 2);
        ItemForEmeraldTradeOffer option4 = new ItemForEmeraldTradeOffer((ItemLike)((DecorChestBlock)((Object)SetupBlocks.DECOR_CHEST_BLOCK.get())).asItem(), 1, 2, 6, 4);
        return new VillagerTrades.ItemListing[]{option1, option2, option3, option4};
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel3() {
        ItemForEmeraldTradeOffer option1 = new ItemForEmeraldTradeOffer((ItemLike)((DecorCauldronBlock)((Object)SetupBlocks.DECOR_CAULDRON_BLOCK.get())).asItem(), 1, 1, 6, 4);
        ItemForEmeraldTradeOffer option2 = new ItemForEmeraldTradeOffer((ItemLike)Items.IRON_CHAIN, 1, 3, 8, 4);
        RandomItemForEmeraldTradeOffer option3 = new RandomItemForEmeraldTradeOffer(2, 8, 4, RANDOM_COOPER_CHAINS);
        RandomItemForEmeraldTradeOffer option4 = new RandomItemForEmeraldTradeOffer(6, 8, 4, RANDOM_ITEMS);
        return new VillagerTrades.ItemListing[]{option1, option2, option3, option4};
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel4() {
        ItemForEmeraldTradeOffer option1 = new ItemForEmeraldTradeOffer((ItemLike)((Block)SetupBlocks.DECOR_BOX_BLOCK.get()).asItem(), 3, 2, 8, 6);
        ItemForEmeraldTradeOffer option2 = new ItemForEmeraldTradeOffer((ItemLike)((Block)SetupBlocks.DECOR_BOX_CROSS_BLOCK.get()).asItem(), 3, 2, 8, 6);
        ItemForEmeraldTradeOffer option3 = new ItemForEmeraldTradeOffer((ItemLike)((Block)SetupBlocks.DECOR_BOX_FIX_BLOCK.get()).asItem(), 3, 2, 8, 6);
        ItemForEmeraldTradeOffer option4 = new ItemForEmeraldTradeOffer((ItemLike)Items.CHISELED_BOOKSHELF, 9, 1, 8, 8);
        return new VillagerTrades.ItemListing[]{option1, option2, option3, option4};
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel5() {
        ItemForEmeraldTradeOffer option1 = new ItemForEmeraldTradeOffer((ItemLike)Items.PAINTING, 2, 3, 6, 4);
        ItemForEmeraldTradeOffer option2 = new ItemForEmeraldTradeOffer((ItemLike)Items.ARMOR_STAND, 1, 2, 6, 4);
        ItemForEmeraldTradeOffer option3 = new ItemForEmeraldTradeOffer((ItemLike)Items.DECORATED_POT, 2, 3, 6, 4);
        return new VillagerTrades.ItemListing[]{option1, option2, option3};
    }
}

