/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.designer.client;

import com.ryu.minecraft.mod.neoforge.neovillagers.designer.inventory.DesignerMenu;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.item.crafting.DesignerRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;

public class DesignerScreen
extends AbstractContainerScreen<DesignerMenu> {
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_IMAGE_SIZE = 18;
    private static final int RECIPES_ROWS = 3;
    private static final int RESULT_START_X = 41;
    private static final int RESULT_START_Y = 17;
    private static final int SCROLLER_CONTENT_SIZE = 54;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int SCROLLER_START_X = 116;
    private static final int SCROLLER_START_Y = 17;
    private static final int SCROLLER_WIDTH = 12;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"neovillagersdesigner", (String)"textures/gui/container/singlecontainer.png");
    private boolean scrolling;
    private float scrollOffs;
    private int startIndex;
    private boolean displayRecipes;

    public DesignerScreen(DesignerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        pMenu.registerUpdateListener(this::containerChanged);
    }

    private void containerChanged() {
        this.displayRecipes = ((DesignerMenu)this.menu).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }

    protected int getOffscreenRows() {
        return (((DesignerMenu)this.menu).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((DesignerMenu)this.menu).getNumRecipes() > 12;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int indexLastVisibleElement = this.startIndex + 12;
            int initialIngredientPosX = this.leftPos + 41;
            int initialIngredientPosY = this.topPos + 17;
            int initialScrollPosX = this.leftPos + 116;
            int initialScrollPosY = this.topPos + 17;
            int maxScrollPosY = initialScrollPosY + 54;
            for (int i = this.startIndex; i < indexLastVisibleElement; ++i) {
                int indexInScreen = i - this.startIndex;
                int carryX = indexInScreen % 4;
                int carryY = indexInScreen / 4;
                double d0 = event.x() - (double)(initialIngredientPosX + carryX * 18);
                double d1 = event.y() - (double)(initialIngredientPosY + carryY * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 18.0) || !(d1 < 18.0) || !((DesignerMenu)this.menu).clickMenuButton((Player)this.minecraft.player, i)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((DesignerMenu)this.menu).containerId, i);
                return true;
            }
            if (event.x() >= (double)initialScrollPosX && event.x() < (double)(initialScrollPosX + 12) && event.y() >= (double)initialScrollPosY && event.y() < (double)maxScrollPosY) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int initialScrollPosY = this.topPos + 17;
            int maxScrollPosY = initialScrollPosY + 54;
            this.scrollOffs = ((float)event.y() - (float)initialScrollPosY - 7.5f) / ((float)(maxScrollPosY - initialScrollPosY) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(event, mouseX, mouseY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pScrollY / (float)i;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int k = (int)(39.0f * this.scrollOffs);
        int posScrollImageX = this.isScrollBarActive() ? 176 : 188;
        int initialScrollPosX = this.leftPos + 116;
        int initialScrollPosY = this.topPos + 17;
        pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, initialScrollPosX, initialScrollPosY + k, (float)posScrollImageX, 0.0f, 12, 15, 256, 256);
        this.renderButtons(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderButtons(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int initialPosX = this.leftPos + 41;
        int initialPosY = this.topPos + 17;
        int indexLastVisibleElement = this.startIndex + 12;
        List<RecipeHolder<DesignerRecipe>> list = ((DesignerMenu)this.menu).getVisibleRecipes();
        for (int i = this.startIndex; i < indexLastVisibleElement && i < ((DesignerMenu)this.menu).getNumRecipes(); ++i) {
            int indexInScreen = i - this.startIndex;
            int posIngredientX = initialPosX + indexInScreen % 4 * 18;
            int row = indexInScreen / 4;
            int posIngredientY = initialPosY + row * 18;
            int posImageX = 0;
            if (i == ((DesignerMenu)this.menu).getSelectedRecipeIndex()) {
                posImageX = 36;
            } else if (pMouseX >= posIngredientX && pMouseY >= posIngredientY && pMouseX < posIngredientX + 18 && pMouseY < posIngredientY + 18) {
                posImageX = 18;
            }
            pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, posIngredientX, posIngredientY, (float)posImageX, 166.0f, 18, 18, 256, 256);
            pGuiGraphics.renderItem(((DesignerRecipe)list.get(i).value()).getResult(), posIngredientX + 1, posIngredientY + 1);
        }
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        super.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        if (this.displayRecipes) {
            int initialPosX = this.leftPos + 41;
            int initialPosY = this.topPos + 17;
            int indexLastVisibleElement = this.startIndex + 12;
            List<RecipeHolder<DesignerRecipe>> list = ((DesignerMenu)this.menu).getVisibleRecipes();
            for (int i = this.startIndex; i < indexLastVisibleElement && i < ((DesignerMenu)this.menu).getNumRecipes(); ++i) {
                int indexInScreen = i - this.startIndex;
                int posIngredientX = initialPosX + indexInScreen % 4 * 18;
                int row = indexInScreen / 4;
                int posIngredientY = initialPosY + row * 18;
                if (pMouseX < posIngredientX || pMouseY < posIngredientY || pMouseX >= posIngredientX + 18 || pMouseY >= posIngredientY + 18) continue;
                pGuiGraphics.setTooltipForNextFrame(this.font, ((DesignerRecipe)list.get(i).value()).getResult(), pMouseX, pMouseY);
            }
        }
    }
}

