/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.designer.helpers;

import com.ryu.minecraft.mod.neoforge.neovillagers.designer.block.DecorCauldronBlock;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.block.DecorWaterCauldronBlock;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.setup.SetupBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class DecorCauldronHelper {
    public static void fillBucket(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, ItemStack itemStack) {
        if (!pLevel.isClientSide()) {
            Item item = itemStack.getItem();
            ItemStack itemResult = new ItemStack((ItemLike)Items.WATER_BUCKET);
            pPlayer.setItemInHand(pHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)pPlayer, (ItemStack)itemResult));
            pPlayer.awardStat(Stats.USE_CAULDRON);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)item));
            pLevel.setBlockAndUpdate(pPos, ((DecorCauldronBlock)((Object)SetupBlocks.DECOR_CAULDRON_BLOCK.get())).defaultBlockState());
            pLevel.playSound((Entity)((Player)null), pPos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PICKUP, pPos);
        }
    }

    public static void fillCauldron(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, ItemStack itemStack) {
        if (!pLevel.isClientSide()) {
            Item item = itemStack.getItem();
            pPlayer.setItemInHand(pHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)pPlayer, (ItemStack)new ItemStack((ItemLike)Items.BUCKET)));
            pPlayer.awardStat(Stats.FILL_CAULDRON);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)item));
            pLevel.setBlockAndUpdate(pPos, ((DecorWaterCauldronBlock)((Object)SetupBlocks.DECOR_WATER_CAULDRON_BLOCK.get())).defaultBlockState());
            pLevel.playSound((Entity)((Player)null), pPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PLACE, pPos);
        }
    }

    private DecorCauldronHelper() {
    }
}

