/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.designer.inventory;

import com.google.common.collect.Lists;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.inventory.slots.ResultSingleSlot;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.item.crafting.DesignerRecipe;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.network.DesignerRecipes;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.setup.SetupBlocks;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.setup.SetupMenus;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DesignerMenu
extends AbstractContainerMenu {
    public static final String MENU_NAME = "designer";
    private static final int INV_SLOT_START = 2;
    private static final int USE_ROW_SLOT_END = 38;
    private final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private final ContainerLevelAccess access;
    private final Level level;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private final ResultContainer resultContainer = new ResultContainer();
    private ItemStack input = ItemStack.EMPTY;
    private long lastSoundTime;
    protected List<RecipeHolder<DesignerRecipe>> recipes = Lists.newArrayList();
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            DesignerMenu.this.slotsChanged((Container)this);
            DesignerMenu.this.slotUpdateListener.run();
        }
    };

    public DesignerMenu(int pContainerId, Inventory playerInv) {
        this(pContainerId, playerInv, ContainerLevelAccess.NULL);
    }

    public DesignerMenu(int pContainerId, Inventory playerInv, ContainerLevelAccess pAccess) {
        super((MenuType)SetupMenus.DESIGNER.get(), pContainerId);
        this.access = pAccess;
        this.level = playerInv.player.level();
        this.inputSlot = this.addSlot(new Slot(this.container, 0, 16, 33));
        this.resultSlot = this.addSlot(new ResultSingleSlot((Container)this.resultContainer, 1, 140, 33, this));
        this.addInventorySlots(playerInv);
        this.addDataSlot(this.selectedRecipeIndex);
    }

    protected void addInventorySlots(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
    }

    public boolean canTakeItemForPickAll(ItemStack pStack, Slot pSlot) {
        return pSlot.container != this.resultContainer && super.canTakeItemForPickAll(pStack, pSlot);
    }

    public boolean clickMenuButton(Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.selectedRecipeIndex.set(pId);
            this.setupResultSlot();
        }
        return true;
    }

    private SingleRecipeInput createRecipeInput(Container container) {
        return new SingleRecipeInput(container.getItem(0));
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public List<RecipeHolder<DesignerRecipe>> getVisibleRecipes() {
        return this.recipes;
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipes.isEmpty();
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    public void onTake(Player pPlayer, ItemStack pStack) {
        pStack.onCraftedBy(pPlayer, pStack.getCount());
        this.resultContainer.awardUsedRecipes(pPlayer, List.of(this.inputSlot.getItem()));
        ItemStack itemstack = this.inputSlot.remove(1);
        if (!itemstack.isEmpty()) {
            this.setupResultSlot();
        }
        this.access.execute((pLevel, pPos) -> {
            long l = pLevel.getGameTime();
            if (this.lastSoundTime != l) {
                pLevel.playSound(null, pPos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.lastSoundTime = l;
            }
        });
    }

    private boolean quickMoveInventory(int pIndex, ItemStack itemstack1) {
        return pIndex >= 2 && pIndex < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : pIndex >= 29 && pIndex < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (!slot.hasItem()) {
            return itemstack;
        }
        ItemStack itemstack1 = slot.getItem();
        Item item = itemstack1.getItem();
        itemstack = itemstack1.copy();
        if (pIndex == 1) {
            item.onCraftedBy(itemstack1, pPlayer);
            if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(itemstack1, itemstack);
        } else if (pIndex == 0) {
            if (!this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            if (DesignerRecipes.inputs(this.level).test(itemstack1) && !this.moveItemStackTo(itemstack1, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (this.quickMoveInventory(pIndex, itemstack1)) {
                return ItemStack.EMPTY;
            }
        }
        if (itemstack1.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        }
        slot.setChanged();
        if (itemstack1.getCount() == itemstack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(pPlayer, itemstack1);
        this.broadcastChanges();
        return itemstack;
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((pLevel, pPos) -> this.clearContainer(pPlayer, this.container));
    }

    protected void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            RecipeHolder<DesignerRecipe> recipeholder = this.recipes.get(this.selectedRecipeIndex.get());
            ItemStack itemStack = ((DesignerRecipe)recipeholder.value()).assemble(this.createRecipeInput(this.container), (HolderLookup.Provider)this.level.registryAccess());
            if (itemStack.isItemEnabled(this.level.enabledFeatures())) {
                this.resultContainer.setRecipeUsed(recipeholder);
                this.resultSlot.set(itemStack);
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public void slotsChanged(Container pInventory) {
        ItemStack itemstack = this.inputSlot.getItem();
        if (!itemstack.is(this.input.getItem())) {
            this.input = itemstack.copy();
            this.selectedRecipeIndex.set(-1);
            this.resultSlot.set(ItemStack.EMPTY);
            this.recipes = Lists.newArrayList();
            if (!itemstack.isEmpty()) {
                this.recipes = DesignerRecipes.inputs(this.level).recipes().stream().filter(holder -> ((DesignerRecipe)holder.value()).input().test(itemstack)).toList();
            }
        }
    }

    public boolean stillValid(Player pPlayer) {
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)SetupBlocks.DESIGNER.get()));
    }
}

