/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.designer.setup;

import com.google.common.collect.ImmutableSet;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.setup.SetupBlocks;
import com.ryu.minecraft.mod.neoforge.neovillagers.designer.villagers.Designer;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SetupVillagers {
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"neovillagersdesigner");
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)"neovillagersdesigner");
    public static final ResourceKey<VillagerProfession> DESIGNER = SetupVillagers.createKey("designer");
    public static final DeferredHolder<PoiType, PoiType> DESIGNER_POI = POI_TYPES.register("designer_poi", () -> SetupVillagers.createPoiType(SetupBlocks.DESIGNER));

    private static ResourceKey<VillagerProfession> createKey(String pName) {
        return ResourceKey.create((ResourceKey)Registries.VILLAGER_PROFESSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"neovillagersdesigner", (String)pName));
    }

    private static PoiType createPoiType(DeferredBlock<? extends Block> block) {
        return new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)block.get()).getStateDefinition().getPossibleStates()), 1, 1);
    }

    public static void register(IEventBus eventBus) {
        POI_TYPES.register(eventBus);
        VILLAGER_PROFESSIONS.register(eventBus);
    }

    private SetupVillagers() {
    }

    static {
        VILLAGER_PROFESSIONS.register("designer", Designer::registerVillager);
    }
}

