/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.designer.villagers.trades;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class EmeraldForItemByVillagerTypeTradeOffer
implements VillagerTrades.ItemListing {
    private final Map<ResourceKey<VillagerType>, Item> trades;
    private final int cost;
    private final int maxUses;
    private final int villagerXp;

    public EmeraldForItemByVillagerTypeTradeOffer(int pCost, int pMaxUses, int pVillagerXp, Map<ResourceKey<VillagerType>, Item> pTrades) {
        BuiltInRegistries.VILLAGER_TYPE.registryKeySet().stream().filter(key -> !pTrades.containsKey(key)).findAny().ifPresent(ex -> {
            throw new IllegalStateException("Missing trade for villager type: " + String.valueOf(ex));
        });
        this.trades = pTrades;
        this.cost = pCost;
        this.maxUses = pMaxUses;
        this.villagerXp = pVillagerXp;
    }

    @Nullable
    public MerchantOffer getOffer(Entity pTrader, RandomSource pRandom) {
        VillagerDataHolder villagerdataholder;
        Optional resourcekey;
        if (pTrader instanceof VillagerDataHolder && (resourcekey = (villagerdataholder = (VillagerDataHolder)pTrader).getVillagerData().type().unwrapKey()).isPresent()) {
            ItemCost itemstack = new ItemCost((ItemLike)this.trades.get(resourcekey.get()), this.cost);
            return new MerchantOffer(itemstack, new ItemStack((ItemLike)Items.EMERALD), this.maxUses, this.villagerXp, 0.05f);
        }
        return null;
    }
}

