/*
 * Decompiled with CFR 0.152.
 */
package de.imdacro.economySystem;

import de.imdacro.economySystem.commands.BalanceCommand;
import de.imdacro.economySystem.commands.BalanceTopCommand;
import de.imdacro.economySystem.commands.EconomyAdminCommand;
import de.imdacro.economySystem.commands.PayCommand;
import de.imdacro.economySystem.database.DatabaseManager;
import de.imdacro.economySystem.database.LiteSQLManager;
import de.imdacro.economySystem.database.MariaDBManager;
import de.imdacro.economySystem.listener.PlayerJoinListener;
import de.imdacro.economySystem.utils.Messages;
import de.imdacro.economySystem.utils.Metrics;
import de.imdacro.economySystem.vault.Vault;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class EconomySystem
extends JavaPlugin {
    private Messages messages;
    private DatabaseManager databaseManager;

    public void onLoad() {
        this.saveDefaultConfig();
        this.loadMessages();
    }

    public void onEnable() {
        int pluginId = 27089;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("currency_type", () -> this.getConfig().getString("economy.currency-name")));
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getCommand("balance").setExecutor((CommandExecutor)new BalanceCommand(this));
        this.getCommand("pay").setExecutor((CommandExecutor)new PayCommand(this));
        this.getCommand("economyadmin").setExecutor((CommandExecutor)new EconomyAdminCommand(this));
        this.getCommand("balancetop").setExecutor((CommandExecutor)new BalanceTopCommand(this));
        this.setupDatabase();
        new Vault(this);
        this.getServer().getConsoleSender().sendMessage(this.messages.get("plugin-enabled", new Object[0]));
    }

    private void loadMessages() {
        try {
            File file = new File(this.getDataFolder(), "messages.json");
            if (!file.exists()) {
                this.saveResource("messages.json", false);
            }
            this.messages = new Messages(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLogger().severe("Error loading the Messages file!");
        }
    }

    private void setupDatabase() {
        String dbType = this.getConfig().getString("database.type", "litesql");
        switch (dbType.toLowerCase()) {
            case "mariadb": {
                this.databaseManager = new MariaDBManager(this);
                break;
            }
            case "litesql": {
                this.databaseManager = new LiteSQLManager(this);
                break;
            }
            default: {
                this.getLogger().severe("Invalid Database type: " + dbType);
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        this.databaseManager.connect();
    }

    public String formatBalance(double balance) {
        return String.format("%,.0f", balance);
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getServer().getConsoleSender().sendMessage(this.messages.get("plugin-disabled", new Object[0]));
    }

    public Messages getMessages() {
        return this.messages;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }
}

