/*
 * Decompiled with CFR 0.152.
 */
package de.imdacro.economySystem.commands;

import de.imdacro.economySystem.EconomySystem;
import de.imdacro.economySystem.database.DatabaseManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BalanceCommand
implements CommandExecutor {
    private final EconomySystem plugin;

    public BalanceCommand(EconomySystem plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessages().get("player-not-player", new Object[0]));
            return true;
        }
        Player player = (Player)sender;
        DatabaseManager databaseManager = this.plugin.getDatabaseManager();
        if (args.length == 0) {
            String uuid = player.getUniqueId().toString();
            if (!databaseManager.accountExists(uuid)) {
                databaseManager.createAccount(uuid);
            }
            double balance = databaseManager.getBalance(uuid);
            player.sendMessage(this.plugin.getMessages().get("balance-message-own", "%balance%", String.valueOf(balance)));
            return true;
        }
        if (!player.hasPermission("economysystem.command.balance.other")) {
            player.sendMessage(this.plugin.getMessages().get("no-permission", new Object[0]));
            return true;
        }
        OfflinePlayer target = this.plugin.getServer().getOfflinePlayer(args[0]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            player.sendMessage(this.plugin.getMessages().get("player-not-found", new Object[0]));
            return true;
        }
        String targetUuid = target.getUniqueId().toString();
        if (!databaseManager.accountExists(targetUuid)) {
            databaseManager.createAccount(targetUuid);
        }
        double balance = databaseManager.getBalance(targetUuid);
        player.sendMessage(this.plugin.getMessages().get("balance-message-other", "%player%", target.getName(), "%balance%", String.valueOf(balance)));
        return true;
    }
}

