/*
 * Decompiled with CFR 0.152.
 */
package de.imdacro.economySystem.commands;

import de.imdacro.economySystem.EconomySystem;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class BalanceTopCommand
implements CommandExecutor {
    private final EconomySystem plugin;

    public BalanceTopCommand(EconomySystem plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s2, @NotNull String[] strings) {
        HashMap<String, Double> topBalances = this.plugin.getDatabaseManager().getTopBalances(10);
        this.plugin.getLogger().info("BalanceTop: Found " + topBalances.size() + " players");
        commandSender.sendMessage(this.plugin.getMessages().get("top-list-title", new Object[0]));
        if (topBalances.isEmpty()) {
            commandSender.sendMessage(this.plugin.getMessages().get("no-players-found", new Object[0]));
        } else {
            for (int i = 0; i < topBalances.size(); ++i) {
                String uuid = (String)topBalances.keySet().toArray()[i];
                double balance = topBalances.get(uuid);
                commandSender.sendMessage(this.plugin.getMessages().get("top-list-entry", "%position%", String.valueOf(i + 1), "%player%", this.plugin.getServer().getOfflinePlayer(UUID.fromString(uuid)).getName(), "%balance%", String.valueOf(balance)));
            }
        }
        return true;
    }
}

